/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;

public class AGeneralPathDetector
extends ADetector {
    double[] x;
    double[] y;

    AGeneralPathDetector(String name, String projection, String color, double[] x, double[] y, int xSign, int ySign) {
        super(name, projection, color);
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        int i = 0;
        while (i < this.x.length) {
            int n = i;
            this.x[n] = this.x[n] * (double)xSign;
            int n2 = i++;
            this.y[n2] = this.y[n2] * (double)ySign;
        }
    }

    protected ACoord getUser(String proj) {
        if (!this.projection.equals(proj)) {
            return ACoord.NO_DATA;
        }
        double[][] hv = new double[2][this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            hv[0][i] = this.x[i];
            hv[1][i] = this.y[i];
        }
        return new ACoord(hv);
    }
}

