/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ABarrelCalorimeterDetector;
import atlantis.geometry.ABarrelSiliconDetector;
import atlantis.geometry.ABarrelTRTDetector;
import atlantis.geometry.ABoxDetector;
import atlantis.geometry.ADiscDetector;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.geometry.AEndcapCryostatDetector;
import atlantis.geometry.AEndcapSiliconDetector;
import atlantis.geometry.AEndcapTRTDetector;
import atlantis.geometry.AGapCalorimeterDetector;
import atlantis.geometry.AGeneralPathDetector;
import atlantis.geometry.AGeometryConstants;
import atlantis.geometry.ARectangleDetector;
import atlantis.geometry.ATBxDetector;
import atlantis.geometry.ATrapezoidDetector;
import atlantis.gui.AExceptionHandler;
import atlantis.utils.AUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AGeometryFromXMLReader
extends DefaultHandler {
    private static final boolean VALIDATION = false;
    private SAXParser parser;
    private static List detectors;
    private String name;
    private String projection;
    private String color;
    private boolean xReflect;
    private boolean yReflect;
    private int numPoints;
    private double[] x;
    private double[] y;

    public AGeometryFromXMLReader() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            AExceptionHandler.processException("Cannot create AGeometryFromXMLReader", e);
        }
    }

    public List readDetectorGeometryFromXML(String fileName) {
        detectors = new ArrayList(2500);
        try {
            InputStream isGeom = AUtilities.getFileAsStream(fileName);
            this.parser.parse(isGeom, (DefaultHandler)this);
        }
        catch (Exception e) {
            String msg = "Error when reading geometry file:\n" + e.getMessage();
            AExceptionHandler.processException(msg, e);
        }
        return detectors;
    }

    private static double calculatePhi(String name, double phi0, int phiIndex) {
        String technology = name.substring(0, 3);
        if (technology.equals("TGC")) {
            if (name.charAt(6) == 'E' && name.charAt(5) != '4') {
                return Math.toRadians(phi0) + (double)(phiIndex - 1) * Math.PI / 24.0;
            }
            return Math.toRadians(phi0) + (double)(phiIndex - 1) * Math.PI / 12.0;
        }
        return Math.toRadians(phi0) + (double)(phiIndex - 1) * Math.PI / 4.0;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (localName.equals("AGeometryConstant")) {
            AGeometryConstants.getInstance().add(atts.getValue("n"), atts.getValue("value"));
        } else if (localName.equals("ABox") || localName.equals("ATBx")) {
            String name = atts.getValue("n");
            double zi = Double.parseDouble(atts.getValue("zi"));
            double zo = Double.parseDouble(atts.getValue("zo"));
            double ri = Double.parseDouble(atts.getValue("ri"));
            double ro = Double.parseDouble(atts.getValue("ro"));
            double w = Double.parseDouble(atts.getValue("w"));
            double dPhi = Double.parseDouble(atts.getValue("dphi"));
            double rpci = Double.parseDouble(atts.getValue("RPCi"));
            double rpco = Double.parseDouble(atts.getValue("RPCo"));
            double s = Double.parseDouble(atts.getValue("sh"));
            int stationEta = Integer.parseInt(atts.getValue("eta"));
            String[] phis = atts.getValue("phi").split(" ");
            if (localName.equals("ABox")) {
                for (int i = 0; i < phis.length; ++i) {
                    for (int zSide = -1; zSide <= 1; zSide += 2) {
                        int stationPhi = Integer.parseInt(phis[i]);
                        double phi = AGeometryFromXMLReader.calculatePhi(name, dPhi, stationPhi);
                        detectors.add(new ABoxDetector(name, (double)zSide * zi, (double)zSide * zo, ri + rpci, ro - rpco, phi, s, w, zSide * stationEta, stationPhi));
                        if (rpci > 0.0) {
                            detectors.add(new ABoxDetector("RPC" + name.substring(3) + "_I", (double)zSide * zi, (double)zSide * zo, ri, ri + rpci, phi, s, w, zSide * stationEta, stationPhi));
                        }
                        if (!(rpco > 0.0)) continue;
                        detectors.add(new ABoxDetector("RPC" + name.substring(3) + "_O", (double)zSide * zi, (double)zSide * zo, ro - rpco, ro, phi, s, w, zSide * stationEta, stationPhi));
                    }
                }
            } else if (localName.equals("ATBx")) {
                double zis = Double.parseDouble(atts.getValue("zis"));
                double zos = Double.parseDouble(atts.getValue("zos"));
                double ws = Double.parseDouble(atts.getValue("ws"));
                double or = Double.parseDouble(atts.getValue("or"));
                for (int i = 0; i < phis.length; ++i) {
                    for (int zSide = -1; zSide <= 1; zSide += 2) {
                        int stationPhi = Integer.parseInt(phis[i]);
                        double phi = AGeometryFromXMLReader.calculatePhi(name, dPhi, stationPhi);
                        detectors.add(new ATBxDetector(name, (double)zSide * zi, (double)zSide * zo, ri + rpci, ro - rpco, phi, s, w, (double)zSide * zis, (double)zSide * zos, ws, or, zSide * stationEta, stationPhi));
                        if (rpci > 0.0) {
                            detectors.add(new ATBxDetector("RPC" + name.substring(3) + "_I", (double)zSide * zi, (double)zSide * zo, ri, ri + rpci, phi, s, w, (double)zSide * zis, (double)zSide * zos, ws, or, zSide * stationEta, stationPhi));
                        }
                        if (!(rpco > 0.0)) continue;
                        detectors.add(new ATBxDetector("RPC" + name.substring(3) + "_O", (double)zSide * zi, (double)zSide * zo, ro - rpco, ro, phi, s, w, (double)zSide * zis, (double)zSide * zos, ws, or, zSide * stationEta, stationPhi));
                    }
                }
            }
        } else if (localName.equals("ATrd")) {
            String name = atts.getValue("n");
            double zi = Double.parseDouble(atts.getValue("zi"));
            double zo = Double.parseDouble(atts.getValue("zo"));
            double ri = Double.parseDouble(atts.getValue("ri"));
            double ro = Double.parseDouble(atts.getValue("ro"));
            double wi = Double.parseDouble(atts.getValue("wi"));
            double wo = Double.parseDouble(atts.getValue("wo"));
            double dPhi = Double.parseDouble(atts.getValue("dphi"));
            double alpha = Double.parseDouble(atts.getValue("a"));
            int stationEta = Integer.parseInt(atts.getValue("eta"));
            String[] phis = atts.getValue("phi").split(" ");
            for (int i = 0; i < phis.length; ++i) {
                for (int zSide = -1; zSide <= 1; zSide += 2) {
                    int stationPhi = Integer.parseInt(phis[i]);
                    double phi = AGeometryFromXMLReader.calculatePhi(name, dPhi, stationPhi);
                    detectors.add(new ATrapezoidDetector(name, (double)zSide * zi, (double)zSide * zo, ri, ro, phi, wi, wo, alpha, zSide * stationEta, stationPhi));
                }
            }
        } else if (localName.equals("ABarrelCalorimeter")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int sampling = Integer.parseInt(atts.getValue("sampling"));
            int region = Integer.parseInt(atts.getValue("region"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            double eta0 = Double.parseDouble(atts.getValue("eta0"));
            double deta = Double.parseDouble(atts.getValue("deta"));
            int neta = Integer.parseInt(atts.getValue("neta"));
            int meta = Integer.parseInt(atts.getValue("meta"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            detectors.add(new ABarrelCalorimeterDetector(name, color, sampling, region, rMin, rMax, zMin, zMax, eta0, deta, neta, meta, phi0, nphi));
        } else if (localName.equals("AEndcapCalorimeter")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int sampling = Integer.parseInt(atts.getValue("sampling"));
            int region = Integer.parseInt(atts.getValue("region"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            double eta0 = Double.parseDouble(atts.getValue("eta0"));
            double deta = Double.parseDouble(atts.getValue("deta"));
            int neta = Integer.parseInt(atts.getValue("neta"));
            int meta = Integer.parseInt(atts.getValue("meta"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            detectors.add(new AEndcapCalorimeterDetector(name, color, sampling, region, rMin, rMax, zMin, zMax, eta0, deta, neta, meta, phi0, nphi));
        } else if (localName.equals("AEndcapCryostat")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int sampling = Integer.parseInt(atts.getValue("sampling"));
            int region = Integer.parseInt(atts.getValue("region"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            int neta = Integer.parseInt(atts.getValue("neta"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            detectors.add(new AEndcapCryostatDetector(name, color, sampling, region, rMin, rMax, zMin, zMax, neta, nphi));
        } else if (localName.equals("AGapCalorimeter")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int sampling = Integer.parseInt(atts.getValue("sampling"));
            int region = Integer.parseInt(atts.getValue("region"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            int eta = Integer.parseInt(atts.getValue("eta"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            detectors.add(new AGapCalorimeterDetector(name, color, sampling, region, rMin, rMax, zMin, zMax, eta, phi0, nphi));
        } else if (localName.equals("ABarrelSiliconDetector")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int layer = Integer.parseInt(atts.getValue("layer"));
            double length = Double.parseDouble(atts.getValue("length"));
            double width = Double.parseDouble(atts.getValue("width"));
            double thickness = Double.parseDouble(atts.getValue("thickness"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            int nz = Integer.parseInt(atts.getValue("nz"));
            double tilt = Double.parseDouble(atts.getValue("tilt"));
            double r0 = Double.parseDouble(atts.getValue("r0"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            detectors.add(new ABarrelSiliconDetector(name, color, layer, length, width, thickness, nz, nphi, tilt, r0, phi0, zMin, zMax));
        } else if (localName.equals("AEndcapSiliconDetector")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int layer = Integer.parseInt(atts.getValue("layer"));
            double length = Double.parseDouble(atts.getValue("length"));
            double width = Double.parseDouble(atts.getValue("width"));
            double thickness = Double.parseDouble(atts.getValue("thickness"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            int nz = Integer.parseInt(atts.getValue("nz"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            detectors.add(new AEndcapSiliconDetector(name, color, layer, length, width, thickness, nz, nphi, rMin, rMax, phi0, zMin, zMax));
        } else if (localName.equals("ABarrelTRTDetector")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int layer = Integer.parseInt(atts.getValue("layer"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double phiIn = Double.parseDouble(atts.getValue("phiIn"));
            double phiOut = Double.parseDouble(atts.getValue("phiOut"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            detectors.add(new ABarrelTRTDetector(name, color, layer, nphi, rMin, rMax, phiIn, phiOut, zMin, zMax));
        } else if (localName.equals("AEndcapTRTDetector")) {
            String name = atts.getValue("n");
            String color = atts.getValue("c");
            int layer = Integer.parseInt(atts.getValue("layer"));
            int nphi = Integer.parseInt(atts.getValue("nphi"));
            double rMin = Double.parseDouble(atts.getValue("rMin"));
            double rMax = Double.parseDouble(atts.getValue("rMax"));
            double phi0 = Double.parseDouble(atts.getValue("phi0"));
            double zMin = Double.parseDouble(atts.getValue("zMin"));
            double zMax = Double.parseDouble(atts.getValue("zMax"));
            detectors.add(new AEndcapTRTDetector(name, color, layer, nphi, rMin, rMax, phi0, zMin, zMax));
        } else if (localName.equals("ADisc")) {
            String name = atts.getValue("n");
            String projection = atts.getValue("p");
            String color = atts.getValue("c");
            double rInner = Double.parseDouble(atts.getValue("rIn"));
            double rOuter = Double.parseDouble(atts.getValue("rOut"));
            int nInner = Integer.parseInt(atts.getValue("nIn"));
            int nOuter = Integer.parseInt(atts.getValue("nOut"));
            detectors.add(new ADiscDetector(name, projection, color, rInner, rOuter, nInner, nOuter));
        } else if (localName.equals("ARectangle")) {
            String name = atts.getValue("n");
            String projection = atts.getValue("p");
            String color = atts.getValue("c");
            double xMin = Double.parseDouble(atts.getValue("xMin"));
            double xMax = Double.parseDouble(atts.getValue("xMax"));
            double yMin = Double.parseDouble(atts.getValue("yMin"));
            double yMax = Double.parseDouble(atts.getValue("yMax"));
            boolean xReflect = atts.getValue("xR").equals("YES");
            boolean yReflect = atts.getValue("yR").equals("YES");
            detectors.add(new ARectangleDetector(name, projection, color, xMin, xMax, yMin, yMax));
            if (xReflect) {
                detectors.add(new ARectangleDetector(name, projection, color, -xMin, -xMax, yMin, yMax));
            }
            if (yReflect) {
                detectors.add(new ARectangleDetector(name, projection, color, xMin, xMax, -yMin, -yMax));
            }
            if (xReflect && yReflect) {
                detectors.add(new ARectangleDetector(name, projection, color, -xMin, -xMax, -yMin, -yMax));
            }
        } else if (localName.equals("AGeneralPath")) {
            this.name = atts.getValue("n");
            this.projection = atts.getValue("p");
            this.color = atts.getValue("c");
            this.numPoints = Integer.parseInt(atts.getValue("numPoints"));
            this.xReflect = atts.getValue("xR").equals("YES");
            this.yReflect = atts.getValue("yR").equals("YES");
            this.x = new double[this.numPoints];
            this.y = new double[this.numPoints];
            this.numPoints = 0;
        } else if (localName.equals("APoint")) {
            this.x[this.numPoints] = Double.parseDouble(atts.getValue("x"));
            this.y[this.numPoints] = Double.parseDouble(atts.getValue("y"));
            ++this.numPoints;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equals("AGeneralPath")) {
            detectors.add(new AGeneralPathDetector(this.name, this.projection, this.color, this.x, this.y, 1, 1));
            if (this.xReflect) {
                detectors.add(new AGeneralPathDetector(this.name, this.projection, this.color, this.x, this.y, -1, 1));
            }
            if (this.yReflect) {
                detectors.add(new AGeneralPathDetector(this.name, this.projection, this.color, this.x, this.y, 1, -1));
            }
            if (this.xReflect && this.yReflect) {
                detectors.add(new AGeneralPathDetector(this.name, this.projection, this.color, this.x, this.y, -1, -1));
            }
        }
    }
}

