/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.utils.AMath;

public class ARectangleDetector
extends ADetector {
    double xMin;
    double xMax;
    double yMin;
    double yMax;

    ARectangleDetector(String name, String projection, String color, double xMin, double xMax, double yMin, double yMax) {
        super(name, projection, color);
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    protected ACoord getRZUser() {
        return this.getUser("RZ");
    }

    protected ACoord getFZUser() {
        return this.getUser("FZ");
    }

    protected ACoord getXZUser() {
        return this.getUser("XZ");
    }

    protected ACoord getYZUser() {
        return this.getUser("YZ");
    }

    protected ACoord getUser(String proj) {
        if (!this.projection.equals(proj)) {
            return ACoord.NO_DATA;
        }
        return new ACoord(AMath.xBox((this.xMin + this.xMax) / 2.0, (this.xMax - this.xMin) / 2.0), AMath.yBox((this.yMin + this.yMax) / 2.0, (this.yMax - this.yMin) / 2.0));
    }
}

