/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ABoxDetector;
import atlantis.graphics.ACoord;

public class ATBxDetector
extends ABoxDetector {
    double zis;
    double zos;
    double ws;
    double or;

    public ATBxDetector(String name, double zMin, double zMax, double rMin, double rMax, double phi, double excl, double size, double zis, double zos, double ws, double or, int etaIndex, int phiIndex) {
        super(name, zMin, zMax, rMin, rMax, phi, excl, size, etaIndex, phiIndex);
        this.zis = zis;
        this.zos = zos;
        this.ws = ws;
        this.or = or;
    }

    protected ACoord getFZUser() {
        double[][] hv = new double[2][8];
        double cosPhi = Math.cos(this.phi);
        double sinPhi = Math.sin(this.phi);
        double d = this.size / 2.0;
        double r = this.rMin;
        double x = r * cosPhi - this.excl * sinPhi;
        double y = r * sinPhi + this.excl * cosPhi;
        double dsinPhi = d * sinPhi;
        double dcosPhi = d * cosPhi;
        double phi1 = Math.toDegrees(Math.atan2(y - dcosPhi, x + dsinPhi));
        double phi2 = Math.toDegrees(Math.atan2(y + dcosPhi, x - dsinPhi));
        if (phi1 < 0.0) {
            phi1 += 360.0;
        }
        if (phi2 < 0.0) {
            phi2 += 360.0;
        }
        if (phi1 - phi2 > 180.0) {
            phi1 -= 360.0;
        }
        if (phi2 - phi1 > 180.0) {
            phi2 -= 360.0;
        }
        double phiLower = Math.min(phi1, phi2);
        double phiUpper = Math.max(phi1, phi2);
        double phiMid = phiLower + this.ws / this.size * (phiUpper - phiLower);
        hv[0][0] = this.zMin;
        hv[0][1] = this.zMin;
        hv[0][2] = this.zis;
        hv[0][3] = this.zis;
        hv[0][4] = this.zos;
        hv[0][5] = this.zos;
        hv[0][6] = this.zMax;
        hv[0][7] = this.zMax;
        if (this.or > 90.0) {
            phiMid = phiLower + this.ws / this.size * (phiUpper - phiLower);
            hv[1][0] = phiUpper;
            hv[1][1] = phiMid;
            hv[1][2] = phiMid;
            hv[1][3] = phiLower;
            hv[1][4] = phiLower;
            hv[1][5] = phiMid;
            hv[1][6] = phiMid;
            hv[1][7] = phiUpper;
        } else {
            phiMid = phiUpper - this.ws / this.size * (phiUpper - phiLower);
            hv[1][0] = phiLower;
            hv[1][1] = phiMid;
            hv[1][2] = phiMid;
            hv[1][3] = phiUpper;
            hv[1][4] = phiUpper;
            hv[1][5] = phiMid;
            hv[1][6] = phiMid;
            hv[1][7] = phiLower;
        }
        return new ACoord(hv);
    }
}

