/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AMath;

public class ATrapezoidDetector
extends ADetector {
    double zMin;
    double zMax;
    double rMin;
    double rMax;
    double phi;
    double sizeS;
    double sizeL;
    double alpha;
    int stationEta;
    int stationPhi;
    int sector;

    public ATrapezoidDetector(String name, double zMin, double zMax, double rMin, double rMax, double phi, double sizeS, double sizeL, double alpha, int stationEta, int stationPhi) {
        super(name, "  ", name.substring(0, 3));
        this.zMin = zMin;
        this.zMax = zMax;
        this.rMin = rMin;
        this.rMax = rMax;
        this.phi = phi;
        this.sizeS = sizeS;
        this.sizeL = sizeL;
        this.alpha = alpha;
        this.stationEta = stationEta;
        this.stationPhi = stationPhi;
        this.sector = (int)((phi + 0.19634954084936207) / 0.39269908169872414) % 16;
    }

    protected boolean equalsYX(ADetector o) {
        if (o instanceof ATrapezoidDetector) {
            ATrapezoidDetector that = (ATrapezoidDetector)o;
            return this.rMin == that.rMin && this.rMax == that.rMax && this.phi == that.phi && this.sizeS == that.sizeS && this.sizeL == that.sizeL;
        }
        return false;
    }

    protected boolean equalsRZ(ADetector o) {
        if (o instanceof ATrapezoidDetector) {
            ATrapezoidDetector that = (ATrapezoidDetector)o;
            return this.rMin == that.rMin && this.rMax == that.rMax && this.zMin == that.zMin && this.zMax == that.zMax && this.alpha == that.alpha;
        }
        return false;
    }

    protected ACoord getRZUser() {
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        double phiDiff = Math.abs(this.phi - phiMid);
        double sign = -1.0;
        if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
            sign = 1.0;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getXZUser() {
        AParameter p = APar.get("XZ", "Phi");
        if (p.getD() % 22.5 < 0.01) {
            int sect = (int)Math.round(p.getD() % 360.0 / 22.5);
            if (this.sector == sect) {
                return this.getXZRZUser(1.0);
            }
            if (this.sector == sect - 8 || this.sector == sect + 8) {
                return this.getXZRZUser(-1.0);
            }
        }
        return ACoord.NO_DATA;
    }

    protected ACoord getXZRZUser(double sign) {
        if (this.alpha == 0.0) {
            return new ACoord(AMath.xBox((this.zMin + this.zMax) / 2.0, (this.zMax - this.zMin) / 2.0), AMath.yBox(sign * (this.rMin + this.rMax) / 2.0, sign * (this.rMax - this.rMin) / 2.0));
        }
        double[][] hv = new double[2][];
        double zMid = (this.zMin + this.zMax) / 2.0;
        double rMid = (this.rMin + this.rMax) / 2.0;
        double dRho = (this.rMax - this.rMin) / 2.0;
        double dZ = (this.zMax - this.zMin) / 2.0;
        double sinAlpha = Math.sin(Math.toRadians(this.alpha));
        double cosAlpha = Math.cos(Math.toRadians(this.alpha));
        if (zMid * rMid > 0.0) {
            sinAlpha *= -1.0;
        }
        hv[0] = new double[]{zMid - sinAlpha * dRho - cosAlpha * dZ, zMid - sinAlpha * dRho + cosAlpha * dZ, zMid + sinAlpha * dRho + cosAlpha * dZ, zMid + sinAlpha * dRho - cosAlpha * dZ};
        hv[1] = new double[]{sign * (rMid + cosAlpha * dRho - sinAlpha * dZ), sign * (rMid + cosAlpha * dRho + sinAlpha * dZ), sign * (rMid - cosAlpha * dRho + sinAlpha * dZ), sign * (rMid - cosAlpha * dRho - sinAlpha * dZ)};
        return new ACoord(hv);
    }

    protected ACoord getFZUser() {
        double deltaPhi = Math.max(Math.atan2(this.sizeL / 2.0, this.rMax), Math.atan2(this.sizeS / 2.0, this.rMin));
        if (this.alpha == 0.0) {
            return new ACoord(AMath.xBox((this.zMin + this.zMax) / 2.0, (this.zMax - this.zMin) / 2.0), AMath.yBox(Math.toDegrees(this.phi), Math.toDegrees(deltaPhi)));
        }
        double[][] hv = new double[2][];
        double zMid = (this.zMin + this.zMax) / 2.0;
        double rMid = (this.rMin + this.rMax) / 2.0;
        double dRho = (this.rMax - this.rMin) / 2.0;
        double dZ = (this.zMax - this.zMin) / 2.0;
        double sinAlpha = Math.sin(Math.toRadians(this.alpha));
        double cosAlpha = Math.cos(Math.toRadians(this.alpha));
        if (zMid * rMid > 0.0) {
            sinAlpha *= -1.0;
        }
        hv[0] = new double[]{zMid - sinAlpha * dRho - cosAlpha * dZ, zMid - sinAlpha * dRho - cosAlpha * dZ, zMid + sinAlpha * dRho + cosAlpha * dZ, zMid + sinAlpha * dRho + cosAlpha * dZ};
        hv[1] = new double[]{Math.toDegrees(this.phi - deltaPhi), Math.toDegrees(this.phi + deltaPhi), Math.toDegrees(this.phi + deltaPhi), Math.toDegrees(this.phi - deltaPhi)};
        return new ACoord(hv);
    }

    protected ACoord getYXUser() {
        return this.getYXUser(0);
    }

    protected ACoord getFRUser() {
        return this.convertYXToFR(this.getYXUser(1));
    }

    private ACoord getYXUser(int flag) {
        boolean splitIt;
        int[] split = new int[]{12, 1, 12, 1};
        int numPoints = 4;
        boolean bl = splitIt = APar.get("YX", "FishEye").getStatus() || APar.get("YX", "Clock").getStatus() || flag == 1;
        if (splitIt) {
            numPoints = 26;
        }
        double[] temp = new double[4];
        double[][] hv = new double[2][numPoints];
        double cosPhi = Math.cos(this.phi);
        double sinPhi = Math.sin(this.phi);
        double d = this.sizeS / 2.0;
        double r = this.rMin;
        double x = r * cosPhi;
        double y = r * sinPhi;
        double dx = d * sinPhi;
        double dy = d * cosPhi;
        hv[0][0] = x + dx;
        hv[1][0] = y - dy;
        hv[0][1] = x - dx;
        hv[1][1] = y + dy;
        r = this.rMax;
        x = r * cosPhi;
        y = r * sinPhi;
        d = this.sizeL / 2.0;
        dx = d * sinPhi;
        dy = d * cosPhi;
        hv[0][3] = x + dx;
        hv[1][3] = y - dy;
        hv[0][2] = x - dx;
        hv[1][2] = y + dy;
        if (splitIt) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 4; ++k) {
                    temp[k] = hv[j][k];
                }
                AMath.splitArrayIntoPieces(temp, hv[j], split);
            }
        }
        return new ACoord(hv);
    }
}

