/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.ATrapezoidDetector;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import java.util.ArrayList;
import java.util.List;

public final class ATrapezoidDetectors
extends ADetectors {
    private int numRZTypes;
    private int[] typeRZ;
    private int numYXTypes;
    private int[] typeYX;
    private ATrapezoidDetector[] trapezoid;

    public ATrapezoidDetectors(List detectors) {
        super(ATrapezoidDetectors.filterTrapezoidDetectors(detectors));
        int j;
        int i;
        this.trapezoid = new ATrapezoidDetector[this.det.length];
        for (i = 0; i < this.trapezoid.length; ++i) {
            this.trapezoid[i] = (ATrapezoidDetector)this.det[i];
        }
        this.typeYX = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.typeYX[i] = -1;
        }
        this.numYXTypes = 0;
        for (i = 0; i < this.numData; ++i) {
            if (this.typeYX[i] != -1) continue;
            this.typeYX[i] = this.numYXTypes;
            for (j = i + 1; j < this.numData; ++j) {
                if (this.typeYX[j] != -1 || !this.det[i].equalsYX(this.det[j])) continue;
                this.typeYX[j] = this.numYXTypes;
            }
            ++this.numYXTypes;
        }
        this.typeRZ = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.typeRZ[i] = -1;
        }
        this.numRZTypes = 0;
        for (i = 0; i < this.numData; ++i) {
            if (this.typeRZ[i] != -1) continue;
            this.typeRZ[i] = this.numRZTypes;
            for (j = i + 1; j < this.numData; ++j) {
                if (this.typeRZ[j] != -1 || !this.det[i].equalsRZ(this.det[j])) continue;
                this.typeRZ[j] = this.numRZTypes;
            }
            ++this.numRZTypes;
        }
    }

    private static ADetector[] filterTrapezoidDetectors(List detectors) {
        ArrayList tempDetectors = new ArrayList(detectors.size());
        for (Object o : detectors) {
            if (!(o instanceof ATrapezoidDetector)) continue;
            tempDetectors.add(o);
        }
        return tempDetectors.toArray(new ADetector[tempDetectors.size()]);
    }

    private void makeDrawListYX() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode == 0) {
            this.numDraw = 0;
        } else {
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                double z = this.trapezoid[i].zMin;
                String name = this.det[i].getName().substring(4, 6);
                if (z > 0.0 && (mode == 1 && name.equals("T4") || mode == 2 && name.equals("T1") || mode == 3 && name.equals("T2") || mode == 4 && name.equals("T3") || mode == 5 && (name.equals("EI") || name.equals("CS")) || mode == 6 && name.equals("EE") || mode == 7 && name.equals("EM") || mode == 8 && name.equals("EO"))) {
                    this.listdl[num++] = i;
                }
                this.numDraw = num;
            }
        }
    }

    private void makeDrawListXZ() {
        AParameter p = APar.get("XZ", "Phi");
        if (p.getD() % 22.5 < 0.01) {
            int sect = (int)Math.round(p.getD() % 360.0 / 22.5);
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                int s = this.trapezoid[i].sector;
                if (s != sect && s != sect - 8 && s != sect + 8) continue;
                this.listdl[num++] = i;
            }
            this.numDraw = num;
        } else {
            this.numDraw = 0;
        }
    }

    private void makeDrawListRZ() {
        int i;
        int[] pos = new int[this.typeRZ.length];
        int[] neg = new int[this.typeRZ.length];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (i = 0; i < this.numRZTypes; ++i) {
            pos[i] = -1;
            neg[i] = -1;
        }
        for (i = 0; i < this.numData; ++i) {
            double phiDiff = Math.abs(this.trapezoid[i].phi - phiMid);
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                pos[this.typeRZ[i]] = i;
                continue;
            }
            neg[this.typeRZ[i]] = i;
        }
        int num = 0;
        for (int i2 = 0; i2 < this.numRZTypes; ++i2) {
            if (pos[i2] != -1) {
                this.listdl[num++] = pos[i2];
            }
            if (neg[i2] == -1) continue;
            this.listdl[num++] = neg[i2];
        }
        this.numDraw = num;
    }

    private void makeDrawListFZ() {
        if (APar.get("FZ", "Mode").getI() == 0) {
            this.constructDefaultDrawList();
        } else {
            this.numDraw = 0;
        }
    }

    protected void makeDrawList(String projection) {
        if (projection.equals("YX") || projection.equals("FR")) {
            this.makeDrawListYX();
        } else if (projection.equals("FZ")) {
            this.makeDrawListFZ();
        } else if (projection.equals("RZ")) {
            this.makeDrawListRZ();
        } else if (projection.equals("XZ")) {
            this.makeDrawListXZ();
        } else {
            this.numDraw = 0;
        }
    }
}

