/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.graphics.ACoord;
import atlantis.utils.AClipPolygon;
import atlantis.utils.APolygon;
import java.awt.Rectangle;

public class AClipper {
    double[] upper;
    double[] lower;
    double[][] x = new double[2][2];
    boolean[][] below;
    boolean[][] within;
    boolean[][] above;
    double hLower;
    double hUpper;
    double vLower;
    double vUpper;
    public static final int NONE_WITHIN = 0;
    public static final int MAYBE_WITHIN = 1;
    public static final int ALL_WITHIN = 2;

    public AClipper(double hLower, double hUpper, double vLower, double vUpper) {
        this.upper = new double[2];
        this.lower = new double[2];
        this.below = new boolean[2][2];
        this.within = new boolean[2][2];
        this.above = new boolean[2][2];
        this.upper[0] = hUpper;
        this.upper[1] = vUpper;
        this.lower[0] = hLower;
        this.lower[1] = vLower;
        this.hUpper = hUpper;
        this.hLower = hLower;
        this.vUpper = vUpper;
        this.vLower = vLower;
    }

    public AClipper(Rectangle clipBounds) {
        this(clipBounds.getX(), clipBounds.getX() + clipBounds.getWidth(), clipBounds.getY(), clipBounds.getY() + clipBounds.getHeight());
    }

    public boolean isPointWithin(double h0, double v0) {
        return this.hLower <= h0 && h0 <= this.hUpper && this.vLower <= v0 && v0 <= this.vUpper;
    }

    public boolean isLineWithin(double h0, double v0, double h1, double v1) {
        int roughCheck = this.fastWithin(h0, v0, h1, v1);
        if (roughCheck == 0) {
            return false;
        }
        this.x[0][0] = h0;
        this.x[1][0] = v0;
        this.x[0][1] = h1;
        this.x[1][1] = v1;
        if (roughCheck == 2) {
            return true;
        }
        this.update(0);
        this.update(1);
        block0: while (!this.lineFullyInside()) {
            if (this.lineFullyOutside()) {
                return false;
            }
            for (int i = 0; i < 2; ++i) {
                for (int point = 0; point < 2; ++point) {
                    if (this.within[i][point]) continue;
                    if (this.below[i][point]) {
                        double[] dArray = this.x[1 - i];
                        int n = point;
                        dArray[n] = dArray[n] + (this.x[1 - i][1 - point] - this.x[1 - i][point]) / (this.x[i][1 - point] - this.x[i][point]) * (this.lower[i] - this.x[i][point]);
                        this.x[i][point] = this.lower[i];
                    } else if (this.above[i][point]) {
                        double[] dArray = this.x[1 - i];
                        int n = point;
                        dArray[n] = dArray[n] + (this.x[1 - i][1 - point] - this.x[1 - i][point]) / (this.x[i][1 - point] - this.x[i][point]) * (this.upper[i] - this.x[i][point]);
                        this.x[i][point] = this.upper[i];
                    }
                    this.update(point);
                    continue block0;
                }
            }
        }
        return this.x[0][0] != this.x[0][1] || this.x[1][0] != this.x[1][1];
    }

    private void update(int p) {
        for (int i = 0; i < 2; ++i) {
            this.below[i][p] = false;
            this.within[i][p] = false;
            this.above[i][p] = false;
            if (this.x[i][p] < this.lower[i]) {
                this.below[i][p] = true;
                continue;
            }
            if (this.x[i][p] > this.upper[i]) {
                this.above[i][p] = true;
                continue;
            }
            this.within[i][p] = true;
        }
    }

    public boolean lineFullyInside() {
        boolean inside = true;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                inside = inside && this.within[i][j];
            }
        }
        return inside;
    }

    public boolean lineFullyOutside() {
        boolean outside = false;
        for (int i = 0; i < 2; ++i) {
            outside = outside || this.below[i][0] && this.below[i][1];
            outside = outside || this.above[i][0] && this.above[i][1];
        }
        return outside;
    }

    public double[][] getHV() {
        return this.x;
    }

    public double getH0() {
        return this.x[0][0];
    }

    public double getV0() {
        return this.x[1][0];
    }

    public double getH1() {
        return this.x[0][1];
    }

    public double getV1() {
        return this.x[1][1];
    }

    public int fastWithin(double h0, double v0, double h1, double v1) {
        if (h0 < this.hLower && h1 < this.hLower) {
            return 0;
        }
        if (h0 > this.hUpper && h1 > this.hUpper) {
            return 0;
        }
        if (v0 < this.vLower && v1 < this.vLower) {
            return 0;
        }
        if (v0 > this.vUpper && v1 > this.vUpper) {
            return 0;
        }
        if (this.hLower <= h0 && h0 <= this.hUpper && this.hLower <= h1 && h1 <= this.hUpper && this.vLower <= v0 && v0 <= this.vUpper && this.vLower <= v1 && v1 <= this.vUpper) {
            return 2;
        }
        return 1;
    }

    public int fastWithin(double[] h, double[] v, int numPoints) {
        int i;
        int num;
        boolean firstWithin;
        if (numPoints == 0) {
            return 0;
        }
        boolean bl = firstWithin = this.hLower <= h[0] && h[0] <= this.hUpper && this.vLower <= v[0] && v[0] <= this.vUpper;
        if (firstWithin) {
            for (int i2 = 1; i2 < numPoints; ++i2) {
                if (this.hLower <= h[i2] && h[i2] <= this.hUpper && this.vLower <= v[i2] && v[i2] <= this.vUpper) continue;
                return 1;
            }
            return 2;
        }
        if (h[0] < this.hLower) {
            num = 1;
            for (i = 1; i < numPoints && h[i] < this.hLower; ++i) {
                ++num;
            }
            if (num == numPoints) {
                return 0;
            }
        }
        if (h[0] > this.hUpper) {
            num = 1;
            for (i = 1; i < numPoints && h[i] > this.hUpper; ++i) {
                ++num;
            }
            if (num == numPoints) {
                return 0;
            }
        }
        if (v[0] < this.vLower) {
            num = 1;
            for (i = 1; i < numPoints && v[i] < this.vLower; ++i) {
                ++num;
            }
            if (num == numPoints) {
                return 0;
            }
        }
        if (v[0] > this.vUpper) {
            num = 1;
            for (i = 1; i < numPoints && v[i] > this.vUpper; ++i) {
                ++num;
            }
            if (num == numPoints) {
                return 0;
            }
        }
        return 1;
    }

    public ACoord clipPolygon(double[] h, double[] v, int numPoints) {
        double[] clipH = new double[]{this.lower[0], this.upper[0], this.upper[0], this.lower[0]};
        double[] clipV = new double[]{this.lower[1], this.lower[1], this.upper[1], this.upper[1]};
        AClipPolygon clipArea = new AClipPolygon(clipH, clipV);
        APolygon badPolygon = new APolygon(h, v);
        badPolygon.clip(clipArea);
        h = badPolygon.getX();
        v = badPolygon.getY();
        return new ACoord(h, v);
    }
}

