/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.ALogger;

public class ACoord {
    private static ALogger logger = ALogger.getLogger(ACoord.class);
    public double[][][] hv;
    public int[] index;
    protected int type = 4;
    public ADrawable source;
    public static final int SYMBOLS = 1;
    public static final int LINES = 2;
    public static final int POLYLINES = 3;
    public static final int POLYGONS = 4;
    public static final int DOTTED_POLYGONS = 5;
    public static final int SMOOTH_POLYLINES = 6;
    public static final ACoord NO_DATA = new ACoord(new double[2][0][0], new int[0]);
    public static final ACoord NO_POLYGONS = new ACoord(new double[2][0][0], new int[0]);
    public static final ACoord NO_POLYLINES = new ACoord(new double[2][0][0], new int[0]);
    public static final ACoord[] NO_HISTOGRAMS = new ACoord[0];

    ACoord() {
    }

    public ACoord(double h, double v, int index) {
        this(h, v);
        this.index = new int[]{index};
    }

    public ACoord(double h, double v) {
        this.hv = new double[2][1][1];
        this.hv[0][0][0] = h;
        this.hv[1][0][0] = v;
        this.index = null;
        this.type = 1;
    }

    public ACoord(double[] h, double[] v) {
        this.hv = new double[2][1][];
        this.hv[0][0] = h;
        this.hv[1][0] = v;
        this.index = new int[]{0};
    }

    public ACoord(double[][] hv, int[] index) {
        if (hv.length != 2) {
            throw new IllegalArgumentException("hv.length=" + hv.length);
        }
        this.hv = new double[2][1][0];
        this.hv[0][0] = hv[0];
        this.hv[1][0] = hv[1];
        this.index = index;
    }

    public ACoord(double[][] hv, int[] index, ADrawable source) {
        this(hv, index);
        this.source = source;
    }

    public ACoord(double[][] hv) {
        if (hv.length != 2) {
            throw new IllegalArgumentException("hv.length=" + hv.length);
        }
        this.hv = new double[2][1][];
        this.hv[0][0] = hv[0];
        this.hv[1][0] = hv[1];
        this.index = null;
    }

    public ACoord(double[][][] hv, int[] index) {
        if (hv.length != 2) {
            throw new IllegalArgumentException("hv.length=" + hv.length);
        }
        this.hv = hv;
        this.index = index;
    }

    public ACoord(double[][][] hv, int[] index, ADrawable source) {
        this(hv, index);
        this.source = source;
    }

    public ACoord(double[][][] hv) {
        if (hv.length != 2) {
            throw new IllegalArgumentException("hv.length=" + hv.length);
        }
        this.hv = hv;
        this.index = null;
    }

    public ACoord(ACoord a) {
        int i;
        this.hv = new double[a.hv.length][][];
        for (i = 0; i < a.hv.length; ++i) {
            this.hv[i] = new double[a.hv[i].length][];
            for (int j = 0; j < a.hv[i].length; ++j) {
                this.hv[i][j] = new double[a.hv[i][j].length];
                for (int k = 0; k < a.hv[i][j].length; ++k) {
                    this.hv[i][j][k] = a.hv[i][j][k];
                }
            }
        }
        this.index = new int[a.index.length];
        for (i = 0; i < a.index.length; ++i) {
            this.index[i] = a.index[i];
        }
        this.type = a.type;
        this.source = a.source;
    }

    public ACoord(double[][] hv, int[] index, ADrawable source, int type) {
        this(hv, index, source);
        this.type = type;
    }

    public ACoord(double[][][] hv, int[] index, ADrawable source, int type) {
        this(hv, index, source);
        this.type = type;
    }

    public ACoord(double[][][] hv, int[] index, int type) {
        this(hv, index);
        this.type = type;
    }

    public ACoord(double[] h, double[] v, int[] index, ADrawable source) {
        if (h.length != v.length) {
            throw new IllegalArgumentException("h.length " + h.length + " !=v.length " + v.length);
        }
        if (h.length != index.length) {
            throw new IllegalArgumentException("h.length " + h.length + " !=index.length " + index.length);
        }
        this.hv = new double[2][1][];
        this.hv[0][0] = h;
        this.hv[1][0] = v;
        this.index = index;
        this.type = 1;
        this.source = source;
    }

    public void print() {
        for (int j = 0; j < this.hv[0].length; ++j) {
            logger.debug(" index = " + this.index[j]);
            for (int i = 0; i < 2; ++i) {
                if (i == 0) {
                    logger.debug("h ");
                } else {
                    logger.debug("v ");
                }
                for (int k = 0; k < this.hv[0][j].length; ++k) {
                    logger.debug((float)this.hv[i][j][k] + "\t");
                }
            }
        }
    }

    public ACoord(ACoord a, ACoord b) {
        this.hv = new double[2][a.hv[0].length + b.hv[0].length][];
        this.index = new int[a.hv[0].length + b.hv[0].length];
        this.type = a.type;
        this.source = a.source;
        for (int i = 0; i < 2; ++i) {
            int j;
            int num = 0;
            for (j = 0; j < a.hv[i].length; ++j) {
                this.hv[i][num] = a.hv[i][j];
                this.index[num] = a.index[j];
                ++num;
            }
            for (j = 0; j < b.hv[i].length; ++j) {
                this.hv[i][num] = b.hv[i][j];
                this.index[num] = b.index[j];
                ++num;
            }
        }
    }

    public ACoord trim() {
        return this;
    }

    public ACoord convertYXToFR() {
        if (this.type == 1 || this.type == 2) {
            for (int j = 0; j < this.hv[0][0].length; ++j) {
                double phiLast = 0.0;
                for (int i = 0; i < this.hv[0].length; ++i) {
                    double xx = this.hv[0][i][j];
                    double yy = this.hv[1][i][j];
                    double rho = Math.sqrt(xx * xx + yy * yy);
                    double phi = Math.toDegrees(Math.atan2(yy, xx));
                    if (phi < 0.0) {
                        phi += 360.0;
                    }
                    if (i > 0) {
                        if (phi - phiLast > 180.0) {
                            phi -= 360.0;
                        }
                        if (phi - phiLast < -180.0) {
                            phi += 360.0;
                        }
                    }
                    this.hv[0][i][j] = rho;
                    this.hv[1][i][j] = phi;
                    phiLast = phi;
                }
            }
        } else {
            for (int i = 0; i < this.hv[0].length; ++i) {
                double phiLast = 0.0;
                for (int j = 0; j < this.hv[0][i].length; ++j) {
                    double xx = this.hv[0][i][j];
                    double yy = this.hv[1][i][j];
                    double rho = Math.sqrt(xx * xx + yy * yy);
                    double phi = Math.toDegrees(Math.atan2(yy, xx));
                    if (phi < 0.0) {
                        phi += 360.0;
                    }
                    if (j > 0) {
                        if (phi - phiLast > 180.0) {
                            phi -= 360.0;
                        }
                        if (phi - phiLast < -180.0) {
                            phi += 360.0;
                        }
                    }
                    this.hv[0][i][j] = rho;
                    this.hv[1][i][j] = phi;
                    phiLast = phi;
                }
            }
        }
        return this;
    }

    public ACoord includePhiWrapAround(String projectionName) {
        int numFrames = APar.get(projectionName, "FramesCount").getI();
        int initialFrame = APar.get(projectionName, "InitialFrame").getI();
        if (this.type == 1 || this.type == 2) {
            int numPoints = this.hv[1].length;
            int numInitialData = this.hv[1][0].length;
            double[][][] hvtemp = new double[2][numPoints][numFrames * numInitialData];
            int[] indextemp = new int[numFrames * numInitialData];
            int num = 0;
            for (int f = initialFrame; f < initialFrame + numFrames; ++f) {
                for (int i = 0; i < numInitialData; ++i) {
                    if (this.index != null) {
                        indextemp[num] = this.index[i];
                    }
                    for (int j = 0; j < numPoints; ++j) {
                        hvtemp[0][j][num] = this.hv[0][j][i];
                        hvtemp[1][j][num] = this.hv[1][j][i] + (double)f * 360.0;
                    }
                    ++num;
                }
            }
            this.hv = hvtemp;
            if (this.index != null) {
                this.index = indextemp;
            }
        } else {
            int numInitialData = this.hv[1].length;
            double[][][] hvtemp = new double[2][numFrames * numInitialData][];
            int[] indextemp = new int[numFrames * numInitialData];
            int num = 0;
            for (int f = initialFrame; f < initialFrame + numFrames; ++f) {
                for (int i = 0; i < numInitialData; ++i) {
                    int numPoints = this.hv[1][i].length;
                    hvtemp[0][num] = new double[numPoints];
                    hvtemp[1][num] = new double[numPoints];
                    for (int j = 0; j < numPoints; ++j) {
                        hvtemp[0][num][j] = this.hv[0][i][j];
                        hvtemp[1][num][j] = this.hv[1][i][j] + (double)f * 360.0;
                    }
                    if (this.index != null) {
                        indextemp[num] = this.index[i];
                    }
                    ++num;
                }
            }
            this.hv = hvtemp;
            if (this.index != null) {
                this.index = indextemp;
            }
        }
        return this;
    }

    public ACoord toSymbols(boolean forceSymbols, int minSize) {
        if (this.type == 2) {
            int i;
            double dmax2 = 0.0;
            for (i = 0; i < this.hv[0][0].length; ++i) {
                double dh = this.hv[0][0][i] - this.hv[0][1][i];
                double dv = this.hv[1][0][i] - this.hv[1][1][i];
                double d = dh * dh + dv * dv;
                if (!(d > dmax2)) continue;
                dmax2 = d;
            }
            if (Math.sqrt(dmax2) < (double)minSize || forceSymbols) {
                this.type = 1;
                for (i = 0; i < this.hv[0][0].length; ++i) {
                    this.hv[0][0][i] = (this.hv[0][0][i] + this.hv[0][1][i]) / 2.0;
                    this.hv[1][0][i] = (this.hv[1][0][i] + this.hv[1][1][i]) / 2.0;
                }
            }
        } else if (this.type == 3 || this.type == 4) {
            double dmax2 = 0.0;
            for (int j = 0; j < this.hv[0].length; ++j) {
                for (int i = 0; i < this.hv[0][j].length; ++i) {
                    double dh = this.hv[0][j][0] - this.hv[0][j][i];
                    double dv = this.hv[1][j][0] - this.hv[1][j][i];
                    double d = dh * dh + dv * dv;
                    if (!(d > dmax2)) continue;
                    dmax2 = d;
                }
            }
            if (Math.sqrt(dmax2) < (double)minSize || forceSymbols) {
                this.type = 1;
                double[][][] hvnew = new double[2][1][this.hv[0].length];
                for (int j = 0; j < this.hv[0].length; ++j) {
                    double h = 0.0;
                    double v = 0.0;
                    for (int i = 0; i < this.hv[0][j].length; ++i) {
                        h += this.hv[0][j][i];
                        v += this.hv[1][j][i];
                    }
                    hvnew[0][0][j] = h /= (double)this.hv[0][j].length;
                    hvnew[1][0][j] = v /= (double)this.hv[0][j].length;
                }
                this.hv = hvnew;
            }
        }
        return this;
    }

    public ACoord mirrorH() {
        ACoord coord = new ACoord(this);
        for (int i = 0; i < coord.hv[0].length; ++i) {
            int j = 0;
            while (j < coord.hv[0][i].length) {
                double[] dArray = coord.hv[0][i];
                int n = j++;
                dArray[n] = dArray[n] * -1.0;
            }
        }
        return coord;
    }

    public ACoord mirrorV() {
        ACoord coord = new ACoord(this);
        for (int i = 0; i < coord.hv[1].length; ++i) {
            int j = 0;
            while (j < coord.hv[1][i].length) {
                double[] dArray = coord.hv[1][i];
                int n = j++;
                dArray[n] = dArray[n] * -1.0;
            }
        }
        return coord;
    }
}

