/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.canvas.AWindow;
import atlantis.data.ACalorimeterData;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.gui.ALegendWindow;
import atlantis.gui.APreferencesControl;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.utils.AMath;
import atlantis.utils.APolygon;
import java.awt.Color;

public class ADrawCalorimeterSummedEndcaps {
    static int minEtaIndex;
    static int minPhiIndex;
    static int maxEtaIndex;
    static int maxPhiIndex;
    static int numCombinedCells;
    static int binvalue;
    static int SmallestEtaBinNumber;
    static int LargestEtaBinNumber;
    static double etaBin;
    static double phiBin;
    static double SmallestZMin;
    static double maxCellEnergy;
    static double minCellEnergy;
    static String name;

    public static void drawCalorimeterSummedEndcaps(AWindow window, AGraphics ag, AProjection2D projection, ACalorimeterData calorimeter, short[] etaIndex, short[] phiIndex, byte[] side) {
        double[] EndcapBinnedEnergyList;
        ACoord data;
        ADrawCalorimeterSummedEndcaps.resetGlobalValues(calorimeter.getName());
        double[][] EndcapBinnedEnergy = new double[36 / binvalue][64 / binvalue];
        calorimeter.makeDrawList();
        ADrawCalorimeterSummedEndcaps.setSmallestAndLargest(calorimeter);
        for (int k = 0; k < calorimeter.getNumDraw(); ++k) {
            int j = calorimeter.getDrawIndex(k);
            short detectorIndex = (short)ACalorimeterDetector.getDetectorIndex(calorimeter.getIdFromIndex(j));
            ACalorimeterDetector currentDetector = ACalorimeterDetector.get(detectorIndex);
            if (detectorIndex < 0) continue;
            ACoord coord = currentDetector.getCell(projection, etaIndex[j], phiIndex[j], side[j]);
            if (coord.hv[0].length <= 0) continue;
            double cellEnergy = calorimeter.getEnergy(j);
            double[] etaminmax = ADrawCalorimeterSummedEndcaps.findEtaMinAndMax(currentDetector, etaIndex[j], side[j]);
            if (etaminmax[2] == 1.0) {
                double middle = APar.get("YX", "SplitEta").getD() - 0.5 * etaBin;
                double[] minmax1 = ADrawCalorimeterSummedEndcaps.findMinAndMax(currentDetector, etaminmax[0], middle, phiIndex[j]);
                int totNumOfCells1 = ADrawCalorimeterSummedEndcaps.findNumberOfCells(minmax1);
                middle = APar.get("YX", "SplitEta").getD() + 0.5 * etaBin;
                double[] minmax2 = ADrawCalorimeterSummedEndcaps.findMinAndMax(currentDetector, middle, etaminmax[1], phiIndex[j]);
                int totNumOfCells2 = ADrawCalorimeterSummedEndcaps.findNumberOfCells(minmax1);
                int NumOfCellsTotal = 0;
                if (totNumOfCells1 > 0) {
                    NumOfCellsTotal += totNumOfCells1;
                } else {
                    System.out.println("Found negative amount of cells!?!");
                }
                if (totNumOfCells2 > 0) {
                    NumOfCellsTotal += totNumOfCells2;
                } else {
                    System.out.println("Found negative amount of cells!?!");
                }
                if (NumOfCellsTotal <= 0) continue;
                cellEnergy /= (double)NumOfCellsTotal;
                if (totNumOfCells1 > 0) {
                    EndcapBinnedEnergy = ADrawCalorimeterSummedEndcaps.AddOnToEnergy(EndcapBinnedEnergy, cellEnergy, minmax1);
                }
                if (totNumOfCells2 <= 0) continue;
                EndcapBinnedEnergy = ADrawCalorimeterSummedEndcaps.AddOnToEnergy(EndcapBinnedEnergy, cellEnergy, minmax2);
                continue;
            }
            double[] minmax = ADrawCalorimeterSummedEndcaps.findMinAndMax(currentDetector, etaminmax[0], etaminmax[1], phiIndex[j]);
            int totNumOfCells = ADrawCalorimeterSummedEndcaps.findNumberOfCells(minmax);
            if (totNumOfCells > 0) {
                EndcapBinnedEnergy = ADrawCalorimeterSummedEndcaps.AddOnToEnergy(EndcapBinnedEnergy, cellEnergy /= (double)totNumOfCells, minmax);
                continue;
            }
            System.out.println("Found negative amount of cells!?!");
        }
        if (numCombinedCells == 0) {
            return;
        }
        double[] YXBinnedEnergyList = new double[numCombinedCells];
        double[][][] YXhv = new double[2][numCombinedCells][0];
        int currentCount = 0;
        for (int a = minEtaIndex; a <= maxEtaIndex; ++a) {
            for (int b = minPhiIndex; b <= maxPhiIndex; ++b) {
                if (!(EndcapBinnedEnergy[a][b] > 0.0)) continue;
                ACoord coord = ADrawCalorimeterSummedEndcaps.calculateCellGeometry(a, b);
                YXhv[0][currentCount] = coord.hv[0][0];
                YXhv[1][currentCount] = coord.hv[1][0];
                YXBinnedEnergyList[currentCount] = EndcapBinnedEnergy[a][b];
                ++currentCount;
                if (EndcapBinnedEnergy[a][b] > maxCellEnergy) {
                    maxCellEnergy = EndcapBinnedEnergy[a][b];
                }
                if (!(EndcapBinnedEnergy[a][b] < minCellEnergy)) continue;
                minCellEnergy = EndcapBinnedEnergy[a][b];
            }
        }
        ACoord YXData = new ACoord(YXhv);
        if (projection instanceof AProjectionFR) {
            data = ADrawCalorimeterSummedEndcaps.convertToFR(YXData, window);
            EndcapBinnedEnergyList = new double[3 * numCombinedCells];
            for (int j = 0; j < numCombinedCells; ++j) {
                EndcapBinnedEnergyList[j] = YXBinnedEnergyList[j];
                EndcapBinnedEnergyList[j + ADrawCalorimeterSummedEndcaps.numCombinedCells] = YXBinnedEnergyList[j];
                EndcapBinnedEnergyList[j + 2 * ADrawCalorimeterSummedEndcaps.numCombinedCells] = YXBinnedEnergyList[j];
            }
            numCombinedCells *= 3;
        } else {
            EndcapBinnedEnergyList = YXBinnedEnergyList;
            data = YXData;
        }
        data = window.calculateDisplay(projection.nonLinearTransform(data));
        boolean drawCells = APar.get(name, "Cells").getStatus();
        if (drawCells) {
            ADrawCalorimeterSummedEndcaps.drawCells(window, ag, data, EndcapBinnedEnergyList);
        }
        ACalorimeterData.drawEndcapHistogram(calorimeter, window, ag, projection);
    }

    protected static void resetGlobalValues(String CalName) {
        name = CalName;
        minEtaIndex = 999;
        minPhiIndex = 999;
        maxEtaIndex = 0;
        maxPhiIndex = 0;
        numCombinedCells = 0;
        SmallestZMin = 99999.0;
        SmallestEtaBinNumber = 99999;
        LargestEtaBinNumber = 0;
        maxCellEnergy = 0.0;
        minCellEnergy = 99999.0;
        binvalue = name.equals("HEC") ? APar.get("YX", "HECBin").getI() : APar.get("YX", "LArBin").getI();
        if (binvalue == 3) {
            etaBin = 0.1;
            phiBin = 0.09817477042468103;
            binvalue = 1;
        } else {
            etaBin = 0.1 * (double)binvalue;
            phiBin = 0.09817477042468103 * (double)binvalue;
        }
    }

    protected static void setSmallestAndLargest(ACalorimeterData calorimeter) {
        double largestRho = 0.0;
        double smallestRho = 99999.0;
        double largestEtaValue = 0.0;
        double smallestEtaValue = 99999.0;
        short prevDetectorIndex = 999;
        for (int k = 0; k < calorimeter.getNumDraw(); ++k) {
            int j = calorimeter.getDrawIndex(k);
            short detectorIndex = (short)ACalorimeterDetector.getDetectorIndex(calorimeter.getIdFromIndex(j));
            ACalorimeterDetector currentDetector = ACalorimeterDetector.get(detectorIndex);
            String detectorName = currentDetector.getName();
            if (detectorIndex == prevDetectorIndex || detectorIndex < 0 || detectorName.indexOf("Endcap") <= 0 && detectorName.indexOf("EC") < 0 && !detectorName.equals("HEC")) continue;
            prevDetectorIndex = detectorIndex;
            if (currentDetector.getZMin() < SmallestZMin) {
                SmallestZMin = currentDetector.getZMin();
            }
            if (currentDetector.getRMin() < smallestRho) {
                smallestRho = currentDetector.getRMin();
                largestEtaValue = AMath.etaAbs(currentDetector.getZMin(), smallestRho);
            }
            if (!(currentDetector.getRMax() > largestRho)) continue;
            largestRho = currentDetector.getRMax();
            smallestEtaValue = AMath.etaAbs(currentDetector.getZMin(), largestRho);
        }
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && !APar.getUnknown("Det", "CaloDetail").getStatus()) {
            ACalorimeterDetector.setEtaSplit();
        }
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && smallestEtaValue >= APar.get("YX", "SplitEta").getD()) {
            double belowSplit = APar.get("YX", "SplitEta").getD() / 0.1;
            double aboveSplit = (smallestEtaValue - APar.get("YX", "SplitEta").getD()) / 0.2;
            SmallestEtaBinNumber = (int)Math.floor(belowSplit + aboveSplit);
        } else {
            SmallestEtaBinNumber = (int)Math.floor(smallestEtaValue / etaBin);
        }
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && largestEtaValue >= APar.get("YX", "SplitEta").getD()) {
            double belowSplit = APar.get("YX", "SplitEta").getD() / 0.1;
            double aboveSplit = (largestEtaValue - APar.get("YX", "SplitEta").getD()) / 0.2;
            LargestEtaBinNumber = (int)Math.floor(belowSplit + aboveSplit);
        } else {
            LargestEtaBinNumber = (int)Math.floor(largestEtaValue / etaBin);
        }
    }

    protected static boolean splitBinning() {
        int test = 0;
        test = name.equals("HEC") ? APar.get("YX", "HECBin").getI() : APar.get("YX", "LArBin").getI();
        return test == 3;
    }

    protected static double[] findEtaMinAndMax(ACalorimeterDetector currentDetector, short etaIndex, byte side) {
        double maxEta;
        double minEta;
        double realEtaBin = etaBin;
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && Math.abs(currentDetector.getEtaMin(etaIndex, side)) >= APar.get("YX", "SplitEta").getD()) {
            realEtaBin = 0.2;
        }
        double zFactor = SmallestZMin / currentDetector.getZMin();
        double calcEtaMin = Math.abs(currentDetector.getEtaMin(etaIndex, side));
        double asinhOf = zFactor * Math.sinh(calcEtaMin);
        calcEtaMin = Math.log(asinhOf + Math.sqrt(asinhOf * asinhOf + 1.0));
        double calcEta = Math.abs(currentDetector.getEta(etaIndex, side));
        asinhOf = zFactor * Math.sinh(calcEta);
        calcEta = Math.log(asinhOf + Math.sqrt(asinhOf * asinhOf + 1.0));
        double deta = currentDetector.getDeltaEta();
        if (deta > realEtaBin) {
            minEta = calcEtaMin;
            maxEta = minEta + deta;
        } else {
            maxEta = minEta = calcEta;
        }
        if (minEta < (double)SmallestEtaBinNumber * 0.1) {
            minEta = (double)SmallestEtaBinNumber * 0.1;
        }
        double[] minAndMax = new double[3];
        minAndMax[0] = minEta;
        minAndMax[1] = maxEta;
        minAndMax[2] = ADrawCalorimeterSummedEndcaps.splitBinning() ? (minEta < APar.get("YX", "SplitEta").getD() && maxEta > APar.get("YX", "SplitEta").getD() ? 1.0 : 0.0) : 0.0;
        return minAndMax;
    }

    protected static double[] findMinAndMax(ACalorimeterDetector currentDetector, double minEta, double maxEta, short phiIndex) {
        double maxPhi;
        double minPhi;
        double belowSplit;
        double realEtaBin = etaBin;
        double realPhiBin = phiBin;
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && minEta >= APar.get("YX", "SplitEta").getD()) {
            realEtaBin = 0.2;
            realPhiBin = 0.19634954084936207;
        }
        double deta = currentDetector.getDeltaEta();
        double dphi = currentDetector.getDeltaPhi();
        if (deta > realEtaBin) {
            if (realEtaBin == etaBin) {
                minEta = Math.floor(minEta / realEtaBin);
                maxEta = Math.floor(maxEta / realEtaBin);
            } else {
                belowSplit = APar.get("YX", "SplitEta").getD() / 0.1;
                double aboveSplit = (minEta - APar.get("YX", "SplitEta").getD()) / 0.2;
                minEta = Math.floor(belowSplit + aboveSplit);
                aboveSplit = (maxEta - APar.get("YX", "SplitEta").getD()) / 0.2;
                maxEta = Math.floor(belowSplit + aboveSplit);
            }
        } else {
            if (realEtaBin == etaBin) {
                minEta = Math.floor(minEta / realEtaBin);
            } else {
                belowSplit = APar.get("YX", "SplitEta").getD() / 0.1;
                double aboveSplit = (minEta - APar.get("YX", "SplitEta").getD()) / 0.2;
                minEta = Math.floor(belowSplit + aboveSplit);
            }
            maxEta = minEta;
        }
        if (dphi > realPhiBin) {
            minPhi = Math.abs(currentDetector.getPhiMin(phiIndex));
            minPhi = Math.floor(minPhi / realPhiBin);
            maxPhi = Math.floor(minPhi + dphi / realPhiBin);
        } else {
            minPhi = Math.abs(currentDetector.getPhi(phiIndex));
            maxPhi = minPhi = Math.floor(minPhi / realPhiBin);
        }
        if (maxPhi >= (double)(64 / binvalue)) {
            maxPhi = 64 / binvalue - 1;
            if (minPhi >= (double)(64 / binvalue - 1)) {
                minPhi = 64 / binvalue - 1;
            }
        }
        if (minPhi < 0.0) {
            minPhi = 0.0;
            if (maxPhi < 0.0) {
                maxPhi = 0.0;
            }
        }
        if (maxEta >= (double)(36 / binvalue)) {
            maxEta = 36 / binvalue - 1;
            if (minEta >= (double)(36 / binvalue)) {
                minEta = 36 / binvalue - 1;
            }
        }
        if (maxEta > (double)LargestEtaBinNumber) {
            maxEta = LargestEtaBinNumber;
            if (minEta > (double)LargestEtaBinNumber) {
                minEta = LargestEtaBinNumber;
            }
        }
        if (minEta < (double)SmallestEtaBinNumber) {
            minEta = SmallestEtaBinNumber;
            if (maxEta < (double)SmallestEtaBinNumber) {
                maxEta = SmallestEtaBinNumber;
            }
        }
        if (minEta < (double)minEtaIndex) {
            minEtaIndex = (int)minEta;
        }
        if (maxEta > (double)maxEtaIndex) {
            maxEtaIndex = (int)maxEta;
        }
        if (minPhi < (double)minPhiIndex) {
            minPhiIndex = (int)minPhi;
        }
        if (maxPhi > (double)maxPhiIndex) {
            maxPhiIndex = (int)maxPhi;
        }
        double[] minAndMax = new double[]{minEta, maxEta, minPhi, maxPhi};
        return minAndMax;
    }

    protected static int findNumberOfCells(double[] minmax) {
        int numOfEtaCells = 0;
        int numOfPhiCells = 0;
        double minEta = minmax[0];
        double maxEta = minmax[1];
        double minPhi = minmax[2];
        double maxPhi = minmax[3];
        numOfEtaCells = (int)((double)numOfEtaCells + (maxEta - minEta + 1.0));
        numOfPhiCells = (int)((double)numOfPhiCells + (maxPhi - minPhi + 1.0));
        int totNumOfCells = numOfEtaCells * numOfPhiCells;
        return totNumOfCells;
    }

    protected static double[][] AddOnToEnergy(double[][] EndcapBinnedEnergy, double cellEnergy, double[] minmax) {
        for (int a = (int)minmax[0]; a <= (int)minmax[1]; ++a) {
            int b = (int)minmax[2];
            while (b <= (int)minmax[3]) {
                if (EndcapBinnedEnergy[a][b] == 0.0) {
                    ++numCombinedCells;
                }
                double[] dArray = EndcapBinnedEnergy[a];
                int n = b++;
                dArray[n] = dArray[n] + cellEnergy;
            }
        }
        return EndcapBinnedEnergy;
    }

    protected static ACoord calculateCellGeometry(int a, int b) {
        double realEtaBin = etaBin;
        double realPhiBin = phiBin;
        double eta = (double)a * etaBin;
        double phi = (double)b * phiBin;
        if (ADrawCalorimeterSummedEndcaps.splitBinning() && eta >= APar.get("YX", "SplitEta").getD()) {
            realEtaBin = 0.2;
            realPhiBin = 0.19634954084936207;
            double belowSplit = APar.get("YX", "SplitEta").getD() / 0.1;
            double aboveSplit = (double)a - belowSplit;
            eta = aboveSplit * 0.2 + belowSplit * 0.1;
            phi = (double)b * realPhiBin;
        }
        double[][] temphv = new double[2][];
        double newrMax = SmallestZMin / Math.sinh(eta);
        double newrMin = SmallestZMin / Math.sinh(eta + realEtaBin);
        temphv[0] = new double[]{newrMax * Math.cos(phi), newrMax * Math.cos(phi + realPhiBin), newrMin * Math.cos(phi + realPhiBin), newrMin * Math.cos(phi)};
        temphv[1] = new double[]{newrMax * Math.sin(phi), newrMax * Math.sin(phi + realPhiBin), newrMin * Math.sin(phi + realPhiBin), newrMin * Math.sin(phi)};
        return new ACoord(temphv);
    }

    protected static ACoord convertToFR(ACoord YXData, AWindow window) {
        YXData.convertYXToFR();
        double[][][] FRhv = new double[2][3 * numCombinedCells][YXData.hv[0][0].length];
        double phiTop = window.getUserCorners()[0].y;
        double phiBottom = window.getUserCorners()[2].y;
        int factor = 0;
        if (phiTop > 720.0) {
            factor = (int)Math.ceil(phiTop / 360.0) - 2;
        }
        if (phiBottom < -360.0) {
            factor = (int)Math.floor(phiBottom / 360.0) - 1;
        }
        for (int j = 0; j < numCombinedCells; ++j) {
            for (int k = 0; k < YXData.hv[0][j].length; ++k) {
                FRhv[1][j][k] = YXData.hv[1][j][k] + 360.0 * (double)(factor - 1);
                FRhv[1][ADrawCalorimeterSummedEndcaps.numCombinedCells + j][k] = YXData.hv[1][j][k] + 360.0 * (double)factor;
                FRhv[1][2 * ADrawCalorimeterSummedEndcaps.numCombinedCells + j][k] = YXData.hv[1][j][k] + 360.0 * (double)(factor + 1);
                FRhv[0][j][k] = YXData.hv[0][j][k];
                FRhv[0][ADrawCalorimeterSummedEndcaps.numCombinedCells + j][k] = YXData.hv[0][j][k];
                FRhv[0][2 * ADrawCalorimeterSummedEndcaps.numCombinedCells + j][k] = YXData.hv[0][j][k];
            }
        }
        return new ACoord(FRhv);
    }

    protected static void drawCells(AWindow window, AGraphics ag, ACoord data, double[] EndcapBinnedEnergyList) {
        int j;
        int j2;
        Color[] colorMap = AColorMap.getColors();
        boolean drawFrame = APar.get(name, "Frame").getStatus();
        int frameColor = APar.get(name, "Frame").getI();
        drawFrame = drawFrame && AColorMap.drawFrames();
        AParameter cellGeometry = APar.get(name, "CellGeometry");
        if (drawFrame && cellGeometry.getStatus()) {
            for (int j3 = 0; j3 < numCombinedCells; ++j3) {
                ag.setColor(colorMap[frameColor]);
                ag.drawPolygon(data.hv[0][j3], data.hv[1][j3], data.hv[0][j3].length);
            }
        }
        AParameter cellOutline = APar.get(name, "CellOutline");
        if (cellGeometry.getStatus()) {
            for (j2 = 0; j2 < numCombinedCells; ++j2) {
                ag.setColor(colorMap[cellGeometry.getI()]);
                ag.fillPolygon(data.hv[0][j2], data.hv[1][j2], data.hv[0][j2].length);
            }
        }
        if (cellOutline.getStatus()) {
            ag.updateDrawParameters(new ADrawParameters(true, cellOutline.getI(), 0, 1, 0, 0, false, 1, 0));
            for (j2 = 0; j2 < numCombinedCells; ++j2) {
                ag.drawPolygon(data.hv[0][j2], data.hv[1][j2], data.hv[0][j2].length);
            }
        }
        data = ADrawCalorimeterSummedEndcaps.scaleEndcapPolygons(EndcapBinnedEnergyList, data, minCellEnergy, maxCellEnergy);
        byte[] EndcapColor = ADrawCalorimeterSummedEndcaps.internalEndcapColor(EndcapBinnedEnergyList, minCellEnergy, maxCellEnergy);
        AParameter colorFunction = APar.get(name, "ColorFunction");
        if (colorFunction.getI() == 4) {
            switch (AColorMap.getColorMap()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    colorMap = AColorMap.getColors(7);
                    break;
                }
                case 5: 
                case 6: {
                    colorMap = AColorMap.getColors(8);
                }
            }
            if (APreferencesControl.getLegMenuItem()) {
                if (AColorMap.getColorMap() != 6) {
                    double[] colorEnergy = ADrawCalorimeterSummedEndcaps.energyOfEndcapColor(minCellEnergy, maxCellEnergy);
                    ALegendWindow.getInstance().addEnergyText(window, colorEnergy, maxCellEnergy, colorMap);
                } else {
                    ALegendWindow.getInstance().addEnergyText(window, minCellEnergy, maxCellEnergy);
                }
            }
        } else if (APreferencesControl.getLegMenuItem()) {
            ALegendWindow.getInstance().clearText(window);
        }
        for (j = 0; j < numCombinedCells; ++j) {
            ag.setColor(colorMap[EndcapColor[j]]);
            ag.fillPolygon(data.hv[0][j], data.hv[1][j], data.hv[0][j].length);
        }
        if (drawFrame && !cellGeometry.getStatus()) {
            for (j = 0; j < numCombinedCells; ++j) {
                ag.setColor(colorMap[frameColor]);
                ag.drawPolygon(data.hv[0][j], data.hv[1][j], data.hv[0][j].length);
            }
        }
    }

    protected static ACoord scaleEndcapPolygons(double[] cellEnergy, ACoord coord, double minEnergy, double maxEnergy) {
        int energyMode = APar.get(name, "EnergyMode").getI();
        for (int i = 0; i < cellEnergy.length; ++i) {
            double factor;
            if (cellEnergy[i] == 0.0) continue;
            if (APar.get(name, "ColorFunction").getI() != 4) {
                double density = cellEnergy[i];
                double minDensity = minEnergy;
                double maxDensity = maxEnergy;
                switch (energyMode) {
                    case 0: 
                    case 1: {
                        factor = Math.sqrt(density / maxDensity);
                        break;
                    }
                    case 2: 
                    case 3: {
                        double magnitude = Math.floor(Math.log10(Math.sqrt(maxDensity / minDensity)) + 1.0);
                        factor = (Math.log10(Math.sqrt(density / maxDensity)) + magnitude) / magnitude;
                        break;
                    }
                    case 4: 
                    case 5: {
                        factor = Math.sqrt(Math.sqrt(density / maxDensity));
                        break;
                    }
                    default: {
                        factor = ACalorimeterData.getNonScalingFactor();
                        break;
                    }
                }
            } else {
                factor = ACalorimeterData.getNonScalingFactor();
            }
            if (!(factor <= 1.0)) continue;
            APolygon.scale(coord.hv[0][i], coord.hv[1][i], factor);
        }
        return coord;
    }

    protected static byte[] internalEndcapColor(double[] cellEnergy, double minEnergy, double maxEnergy) {
        byte[] EndcapColor = new byte[cellEnergy.length];
        int colorFunction = APar.get(name, "ColorFunction").getI();
        int constantColor = APar.get(name, "Constant").getI();
        switch (colorFunction) {
            case 0: {
                for (int i = 0; i < cellEnergy.length; ++i) {
                    EndcapColor[i] = (byte)constantColor;
                }
                break;
            }
            case 4: {
                EndcapColor = ADrawCalorimeterSummedEndcaps.colorEndcapByEnergy(cellEnergy, minEnergy, maxEnergy);
                break;
            }
            default: {
                for (int i = 0; i < cellEnergy.length; ++i) {
                    EndcapColor[i] = (byte)constantColor;
                }
            }
        }
        return EndcapColor;
    }

    protected static byte[] colorEndcapByEnergy(double[] cellEnergy, double minEnergy, double maxEnergy) {
        byte[] EndcapColor = new byte[cellEnergy.length];
        byte numColors = 17;
        for (int i = 0; i < cellEnergy.length; ++i) {
            if (AColorMap.getColorMap() == 6) {
                EndcapColor[i] = 26;
                continue;
            }
            switch (APar.get(name, "EnergyMode").getI()) {
                case 0: 
                case 1: {
                    EndcapColor[i] = (byte)((double)numColors * (cellEnergy[i] - minEnergy) / (maxEnergy - minEnergy));
                    break;
                }
                case 2: 
                case 3: {
                    EndcapColor[i] = (byte)((double)numColors * (Math.log(cellEnergy[i]) - Math.log(minEnergy)) / (Math.log(maxEnergy) - Math.log(minEnergy)));
                    break;
                }
                case 4: 
                case 5: {
                    EndcapColor[i] = (byte)((double)numColors * Math.sqrt((cellEnergy[i] - minEnergy) / (maxEnergy - minEnergy)));
                }
            }
            if (EndcapColor[i] < numColors) continue;
            EndcapColor[i] = (byte)(numColors - 1);
        }
        return EndcapColor;
    }

    protected static double[] energyOfEndcapColor(double minEnergy, double maxEnergy) {
        int numColors = 17;
        double[] colorEnergy = new double[numColors];
        for (int i = 0; i < numColors; ++i) {
            switch (APar.get(name, "EnergyMode").getI()) {
                case 0: 
                case 1: {
                    colorEnergy[i] = (double)i * (maxEnergy - minEnergy) / (double)numColors + minEnergy;
                    break;
                }
                case 2: 
                case 3: {
                    colorEnergy[i] = Math.exp((double)i * (Math.log(maxEnergy) - Math.log(minEnergy)) / (double)numColors + Math.log(minEnergy));
                    break;
                }
                case 4: 
                case 5: {
                    colorEnergy[i] = Math.pow(i / numColors, 2.0) * (maxEnergy - minEnergy) + minEnergy;
                }
            }
            if (!(colorEnergy[i] >= (double)numColors)) continue;
            colorEnergy[i] = (byte)(numColors - 1);
        }
        return colorEnergy;
    }

    static {
        binvalue = 1;
    }
}

