/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.gui.AColorMap;
import java.awt.Color;

public class ADrawParameters {
    boolean draw;
    Color color;
    int size;
    int minSize = 0;
    boolean forceSymbols = false;
    int lineWidth;
    int frameWidth;
    int symbol;
    int drawOrFill = 0;

    public ADrawParameters(boolean draw, int color, int size, int lineWidth, int frameWidth, int symbol) {
        Color[] colorMap = AColorMap.getColors();
        this.draw = draw;
        this.color = color != -1 ? colorMap[color] : null;
        this.size = size;
        this.lineWidth = lineWidth;
        this.frameWidth = frameWidth;
        this.symbol = symbol;
    }

    public ADrawParameters(boolean draw, int color, int size, int lineWidth, int frameWidth, int symbol, boolean forceSymbols, int minSize, int drawOrFill) {
        Color[] colorMap = AColorMap.getColors();
        this.draw = draw;
        this.color = color != -1 ? colorMap[color] : null;
        this.size = size;
        this.lineWidth = lineWidth;
        this.frameWidth = frameWidth;
        this.symbol = symbol;
        this.forceSymbols = forceSymbols;
        this.minSize = minSize;
        this.drawOrFill = drawOrFill;
    }

    public ADrawParameters(boolean draw, Color color, int size, int lineWidth, int frameWidth, int symbol, int drawOrFill) {
        this.draw = draw;
        this.color = color;
        this.size = size;
        this.lineWidth = lineWidth;
        this.frameWidth = frameWidth;
        this.symbol = symbol;
        this.drawOrFill = drawOrFill;
    }

    public void setColor(int color) {
        Color[] colorMap = AColorMap.getColors();
        this.color = colorMap[color];
    }

    public void setFrameWidth(int width) {
        this.frameWidth = width;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean toBeDrawn() {
        return this.draw;
    }

    public int getSize() {
        return this.size;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public boolean getForceSymbols() {
        return this.forceSymbols;
    }

    public int getDrawOrFill() {
        return this.drawOrFill;
    }
}

