/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.AHistogram;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.AGraphics;
import atlantis.graphics.ATemplateGraphics2D;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.utils.ALogger;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.HashMap;

public class ADrawnGraphics2D
extends ATemplateGraphics2D {
    private static ALogger logger = ALogger.getLogger(ADrawnGraphics2D.class);
    private static HashMap map;
    private static ArrayList histogramList;

    public ADrawnGraphics2D(Rectangle bounds) {
        super(bounds);
        map = new HashMap();
        histogramList = new ArrayList();
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event != null) {
            AData[] data = event.getData();
            for (int i = 0; i < data.length; ++i) {
                map.put(data[i], new boolean[data[i].getNumData()]);
            }
        }
    }

    ADrawnGraphics2D(ADrawnGraphics2D a) {
        super(a);
    }

    public static void updateLastDrawn() {
        AListManager.getInstance().clearLastDrawn();
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event != null) {
            boolean[] drawn;
            int i;
            AData[] data = event.getData();
            for (i = 0; i < data.length; ++i) {
                drawn = (boolean[])map.get(data[i]);
                if (data[i] instanceof ACalorimeterData) {
                    drawn = ((ACalorimeterData)data[i]).expandDrawn(drawn);
                }
                AListManager.getInstance().addLastDrawn(new AList(data[i], drawn));
            }
            for (i = 0; i < histogramList.size(); ++i) {
                drawn = (boolean[])map.get(histogramList.get(i));
                AListManager.getInstance().addLastDrawn(new AList((AData)histogramList.get(i), drawn));
            }
        }
    }

    public Graphics create() {
        return new ADrawnGraphics2D(this);
    }

    public void drawLine(double h0, double v0, double h1, double v1) {
        if (AGraphics.currentData != null) {
            ((boolean[])ADrawnGraphics2D.map.get((Object)AGraphics.currentData))[AGraphics.currentIndex] = true;
        }
    }

    public void fillRect(int h, int v, int width, int height) {
        double dh = (double)width / 2.0;
        double dv = (double)height / 2.0;
        this.drawLine((double)h - dh, (double)v - dv, (double)h + dh, (double)v - dv);
        this.drawLine((double)h + dh, (double)v - dv, (double)h + dh, (double)v + dv);
        this.drawLine((double)h + dh, (double)v + dv, (double)h - dh, (double)v + dv);
        this.drawLine((double)h - dh, (double)v + dv, (double)h - dh, (double)v - dv);
    }

    public void draw(Shape s) {
        PathIterator path = s.getPathIterator(null);
        double[] coords = new double[6];
        double h0 = 0.0;
        double v0 = 0.0;
        double h1 = 0.0;
        double v1 = 0.0;
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    h0 = coords[0];
                    v0 = coords[1];
                    break;
                }
                case 1: 
                case 3: {
                    h1 = coords[0];
                    v1 = coords[1];
                    this.drawLine(h0, v0, h1, v1);
                    h0 = h1;
                    v0 = v1;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    logger.error(" Error unknown segment type");
                }
            }
            path.next();
        }
    }

    public void fill(Shape s) {
        this.draw(s);
    }

    public void addHistogramData(AHistogram data) {
        histogramList.add(data);
        map.put(data, new boolean[data.getNumData()]);
    }
}

