/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.canvas.AGLGraphics;
import atlantis.event.AData;
import atlantis.geometry.ADetectors;
import atlantis.graphics.AClipper;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.ADrawable;
import atlantis.graphics.ADrawnGraphics2D;
import atlantis.graphics.AGLPixelGraphics;
import atlantis.graphics.APickingGraphics2D;
import atlantis.graphics.APixelGraphics;
import atlantis.graphics.AVectorGraphics;
import atlantis.gui.AColorMap;
import atlantis.utils.APolygon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public abstract class AGraphics {
    protected Graphics2D g;
    AClipper clipper = null;
    Color currentColor;
    Color lastDrawnColor = null;
    Rectangle bounds;
    int lineWidth = 1;
    int size;
    int symbol;
    ADrawParameters lastDrawParameters = null;
    static AData currentData = null;
    static ADetectors currentDetector = null;
    static int currentIndex;
    public static final int SYMBOL_FILLED_BOX = 0;
    public static final int SYMBOL_HORIZONTAL_LINE = 1;
    public static final int SYMBOL_VERTICAL_LINE = 2;
    public static final int SYMBOL_PLUS = 3;
    public static final int DRAW = 0;
    public static final int FILL = 1;
    protected static final int NUM_LAYERS = 2;
    protected static final int FULLY_INSIDE = 0;
    protected static final int FULLY_OUTSIDE = 1;
    protected static final int CONTAINS = 2;
    protected static final int INTERSECTS = 3;
    protected static final int POLYGON = 0;
    protected static final int POLYLINE = 1;

    AGraphics(Graphics g) {
        this.g = (Graphics2D)g;
        if (g.getClipBounds() != null) {
            this.clipper = new AClipper(g.getClipBounds());
        }
        this.currentColor = g.getColor();
    }

    public Graphics2D getGraphics2D() {
        return this.g;
    }

    public static AGraphics makeAGraphics(Graphics g) {
        if (g instanceof EpsGraphics2D || g instanceof APickingGraphics2D || g instanceof ADrawnGraphics2D) {
            return new AVectorGraphics(g);
        }
        if (g instanceof AGLGraphics) {
            return new AGLPixelGraphics((AGLGraphics)g);
        }
        return new APixelGraphics(g);
    }

    public static void setCurrentDataAndIndex(AData current, int index) {
        currentData = current;
        currentIndex = index;
    }

    public static void setCurrentDetectorAndIndex(ADetectors current, int index) {
        currentDetector = current;
        currentIndex = index;
    }

    public static void clearCurrentDetectorAndIndex() {
        currentDetector = null;
        currentIndex = -1;
    }

    public static void clearCurrentDataAndIndex() {
        currentData = null;
        currentIndex = -1;
    }

    public void setFont(Font f) {
        this.g.setFont(f);
    }

    public void setStroke(Stroke s) {
        this.g.setStroke(s);
    }

    public void setColor(Color c) {
        this.currentColor = c;
    }

    public void updateColor() {
        if (this.currentColor != this.lastDrawnColor) {
            this.g.setColor(this.currentColor);
            this.lastDrawnColor = this.currentColor;
        }
    }

    public abstract void setLineWidth(int var1);

    public void updateDrawParameters(ADrawParameters dp) {
        if (dp != this.lastDrawParameters) {
            this.setColor(dp.color);
            this.lineWidth = Math.max(dp.lineWidth, 1) + 2 * dp.frameWidth;
            this.setLineWidth(this.lineWidth);
            this.size = dp.size + 2 * dp.frameWidth;
            this.symbol = dp.symbol;
            this.lastDrawParameters = dp;
        }
    }

    public void drawString(String str, double x, double y) {
        this.g.drawString(str, (int)x, (int)y);
    }

    public void draw(Shape s) {
        this.g.draw(s);
    }

    public void drawPoint(AData detector, int index, double h, double v, int pixelsH, int pixelsV) {
        AGraphics.setCurrentDataAndIndex(detector, index);
        this.drawPoint(h, v, pixelsH, pixelsV);
        AGraphics.clearCurrentDataAndIndex();
    }

    public void drawPoint(double h, double v, int pixelsH, int pixelsV) {
        if (this.clipper.isPointWithin(h, v)) {
            this.fillRect(h, v, pixelsH, pixelsV);
        }
    }

    public void drawSymbol(double h, double v) {
        if (this.clipper.isPointWithin(h, v)) {
            if (this.symbol == 0) {
                this.fillRect(h, v, this.size, this.size);
            } else if (this.symbol == 1) {
                this.fillRect(h, v, this.size, this.lineWidth);
            } else if (this.symbol == 2) {
                this.fillRect(h, v, this.lineWidth, this.size);
            } else if (this.symbol == 3) {
                this.fillRect(h, v, this.size, this.lineWidth);
                this.fillRect(h, v, this.lineWidth, this.size);
            }
        }
    }

    public void drawImage(Image img, int x, int y) {
        this.g.drawImage(img, x, y, null);
    }

    public void fillPolygon(AData detector, int index, double[] h, double[] v, int numPoints) {
        AGraphics.setCurrentDataAndIndex(detector, index);
        this.fillPolygon(h, v, numPoints);
        AGraphics.clearCurrentDataAndIndex();
    }

    public void fillRect(int h, int v, int width, int height) {
        this.updateColor();
        this.g.fillRect(h, v, width, height);
    }

    public abstract void drawPolyline(double[] var1, double[] var2, int var3);

    public abstract void drawDottedPolyline(double[] var1, double[] var2, int var3);

    public abstract void drawSmoothPolyline(double[] var1, double[] var2, int var3);

    public abstract void drawLine(double var1, double var3, double var5, double var7);

    public abstract void drawPolygon(double[] var1, double[] var2, int var3);

    protected abstract void fillRect(double var1, double var3, int var5, int var6);

    public void fillPolygon(ADetectors det, int index, double[] h, double[] v, int numPoints) {
        AGraphics.setCurrentDetectorAndIndex(det, index);
        this.fillPolygon(h, v, numPoints);
        AGraphics.clearCurrentDetectorAndIndex();
    }

    protected int getContainmentType(double[] h, double[] v, int numPoints, int shape) {
        double yCentreClipped;
        int within = this.clipper.fastWithin(h, v, numPoints);
        if (within == 0) {
            return 1;
        }
        if (within == 2) {
            return 0;
        }
        for (int i = 0; i < numPoints - 1; ++i) {
            if (!this.clipper.isLineWithin(h[i], v[i], h[i + 1], v[i + 1])) continue;
            return 3;
        }
        if (shape == 0 && numPoints > 1 && this.clipper.isLineWithin(h[numPoints - 1], v[numPoints - 1], h[0], v[0])) {
            return 3;
        }
        Rectangle bounds = this.g.getClipBounds();
        double xCentreClipped = bounds.getX() + bounds.getWidth() / 2.0;
        if (AGraphics.isPointInside(h, v, numPoints, xCentreClipped, yCentreClipped = bounds.getY() + bounds.getHeight() / 2.0)) {
            return 2;
        }
        return 1;
    }

    public abstract void fillPolygon(double[] var1, double[] var2, int var3);

    public void drawPolygon(APolygon p) {
        this.drawPolygon(p.getX(), p.getY(), p.nrNodes());
    }

    public static boolean isPointInside(double[] h, double[] v, int numPoints, double hP, double vP) {
        double[] a = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            a[i] = Math.atan2(v[i] - vP, h[i] - hP);
        }
        double[] d = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            d[i] = i < numPoints - 1 ? a[i + 1] - a[i] : a[0] - a[i];
            if (d[i] > Math.PI) {
                int n = i;
                d[n] = d[n] - Math.PI * 2;
                continue;
            }
            if (!(d[i] < -Math.PI)) continue;
            int n = i;
            d[n] = d[n] + Math.PI * 2;
        }
        double sum = 0.0;
        for (int i = 0; i < numPoints; ++i) {
            sum += d[i];
        }
        return Math.abs(sum) > Math.PI;
    }

    public void draw(ACoord display) {
        ADrawable source = display.source;
        if (source == null) {
            return;
        }
        ADrawParameters adp = source.getDrawParameters(0, 0);
        if (adp.getForceSymbols() || adp.getMinSize() > 0) {
            display.toSymbols(adp.getForceSymbols(), adp.getMinSize());
        }
        Color[] colorMap = AColorMap.getColors();
        int[] index = display.index;
        int[] c = source.getColor(index);
        int[] t = source.getType(index);
        double[][] h = display.hv[0];
        double[][] v = display.hv[1];
        for (int layer = 0; layer < 2; ++layer) {
            for (int type = 0; type < source.getNumTypes(); ++type) {
                ADrawParameters dp = source.getDrawParameters(layer, type);
                int drawType = dp.getDrawOrFill();
                this.updateDrawParameters(dp);
                if (!dp.draw) continue;
                for (int j = 0; j < t.length; ++j) {
                    if (t[j] != type) continue;
                    if (layer == 1) {
                        this.setColor(colorMap[c[j]]);
                        if (source instanceof AData) {
                            AGraphics.setCurrentDataAndIndex((AData)source, index[j]);
                        }
                    }
                    if (display.type == 1) {
                        this.drawSymbol(h[0][j], v[0][j]);
                    } else if (display.type == 4 && h[j].length == 1) {
                        this.drawSymbol(h[j][0], v[j][0]);
                    } else if (display.type == 2) {
                        this.drawLine(h[0][j], v[0][j], h[1][j], v[1][j]);
                    } else if (display.type == 3) {
                        this.drawPolyline(h[j], v[j], h[j].length);
                    } else if (display.type == 6) {
                        this.drawSmoothPolyline(h[j], v[j], h[j].length);
                    } else if (display.type == 5) {
                        this.drawDottedPolyline(h[j], v[j], h[j].length);
                    } else if (display.type == 4) {
                        if (drawType == 0) {
                            this.drawPolygon(h[j], v[j], h[j].length);
                        } else if (drawType == 1) {
                            this.fillPolygon(h[j], v[j], h[j].length);
                        }
                    }
                    AGraphics.clearCurrentDataAndIndex();
                }
            }
        }
    }
}

