/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.canvas.AWindow;
import atlantis.data.ALVL1ResultData;
import atlantis.data.ATriggerInfoData;
import atlantis.event.AEvent;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionLegoPlot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class ALegoDraw {
    private static int legendHeight = 0;
    private static int lineHeight = 17;
    private static Color textColor = Color.white;
    private static Color backgroundColor = AColorMap.getColors()[APar.get("Det", "BkgFill").getI()];
    private static Color borderColor = Color.lightGray;

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void fillBackground(AWindow window, AGraphics ag) {
        backgroundColor = AColorMap.getColors()[APar.get("Det", "BkgFill").getI()];
        ag.setColor(backgroundColor);
        ag.fillRect(0, 0, window.getWidth(), window.getHeight());
    }

    public static void drawLegend(AWindow window, AGraphics ag, AEvent event, double met, double maxEt, double AODmaxEt) {
        boolean drawLegend;
        textColor = Color.black;
        if (backgroundColor.getBlue() + backgroundColor.getGreen() + backgroundColor.getRed() < 400) {
            textColor = Color.white;
        }
        float originalFontSize = ag.g.getFont().getSize2D();
        float newFontSize = 0.9f * originalFontSize;
        ag.g.setFont(ag.g.getFont().deriveFont(newFontSize));
        legendHeight = lineHeight + 2;
        int indent = window.getWidth() - 200;
        int pos = 90;
        String[] colLvl1 = event.getActiveCollectionNames("LVL1Result");
        ALVL1ResultData[] lvl1ResultData = null;
        if (colLvl1.length > 0) {
            lvl1ResultData = new ALVL1ResultData[colLvl1.length];
        }
        for (int i = 0; i < colLvl1.length; ++i) {
            lvl1ResultData[i] = (ALVL1ResultData)event.get(colLvl1[i]);
        }
        ATriggerInfoData triggerInfoData = event.getTriggerInfoData();
        if (window.getWidth() < 250 || window.getHeight() < 250) {
            ALegoDraw.drawWindowTooSmall(window, ag, indent);
            ag.g.setFont(ag.g.getFont().deriveFont(originalFontSize));
            return;
        }
        if (APar.get("LegoPlot", "MainLegend").getStatus()) {
            ALegoDraw.drawLegendMain(window, ag, event, met, maxEt, AODmaxEt, lvl1ResultData, indent, pos);
        }
        if (APar.get("LegoPlot", "L1EtLegend").getStatus()) {
            ALegoDraw.drawLegendL1ET(ag, lvl1ResultData, triggerInfoData, indent);
        }
        if (!(drawLegend = false) && APar.get("LegoPlot", "L1Items").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "L2Items").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "EFItems").getStatus()) {
            drawLegend = true;
        }
        if (drawLegend) {
            ALegoDraw.drawLegendItems(window, ag, lvl1ResultData, indent);
        }
        ag.g.setFont(ag.g.getFont().deriveFont(originalFontSize));
    }

    public static void drawWindowTooSmall(AWindow window, AGraphics ag, int indent) {
        ag.setColor(borderColor);
        ag.fillRect((indent += 135) - 4, 5, 65, 3 * lineHeight);
        ag.setColor(backgroundColor);
        ag.fillRect(indent - 4 + 2, 7, 61, 3 * lineHeight - 4);
        ag.setColor(textColor);
        ag.updateColor();
        ag.drawString("Window", indent + 6, legendHeight);
        ag.drawString("too small", indent + 6, legendHeight += lineHeight);
        ag.drawString("for legend", indent + 6, legendHeight += lineHeight);
        legendHeight += lineHeight;
    }

    public static void drawLegendMain(AWindow window, AGraphics ag, AEvent event, double met, double maxEt, double AODmaxEt, ALVL1ResultData[] lvl1ResultData, int indent, int pos) {
        ag.setColor(borderColor);
        ag.fillRect(indent - 4, 5, 200, 105);
        ag.setColor(backgroundColor);
        ag.fillRect(indent - 4 + 2, 7, 196, 101);
        ag.setColor(textColor);
        ag.updateColor();
        if (met != 0.0) {
            ALegoDraw.drawLegendPartMain1(ag, event, met, indent, pos);
        } else {
            ag.drawString("No Missing Et", indent + 6, legendHeight);
        }
        legendHeight += lineHeight;
        ag.setColor(textColor);
        ag.updateColor();
        if (maxEt != 0.0 && AProjectionLegoPlot.colorset.size() > 0) {
            ALegoDraw.drawLegendMain2(ag, indent, pos);
        } else {
            ag.setColor(textColor);
            ag.updateColor();
            ag.drawString("No cells", indent + 6, legendHeight);
        }
        legendHeight += lineHeight;
        ag.setColor(textColor);
        ag.updateColor();
        if (maxEt != 0.0 || AODmaxEt != 0.0) {
            ALegoDraw.drawLegendMain3(ag, maxEt, AODmaxEt, indent, pos);
        } else {
            ag.drawString("No towers", indent + 6, legendHeight);
            legendHeight += lineHeight;
        }
        legendHeight += lineHeight;
        ag.setColor(textColor);
        ag.updateColor();
        if (lvl1ResultData == null) {
            ag.drawString("Trigger Decision N/A", indent + 6, legendHeight);
            legendHeight += lineHeight;
        } else if (lvl1ResultData.length > 1) {
            ag.drawString(">1 LVL1Result collections selected", indent + 6, legendHeight);
            ag.drawString("View on event properties or choose 1", indent + 6, legendHeight += lineHeight);
        } else {
            ALegoDraw.drawLegendMain4(ag, lvl1ResultData[0], indent, pos);
        }
        legendHeight += lineHeight;
        ag.setColor(textColor);
        ag.updateColor();
    }

    public static void drawLegendPartMain1(AGraphics ag, AEvent event, double met, int indent, int pos) {
        ag.setColor(AProjectionLegoPlot.defaultColorMap[APar.get("ETMis", "Constant").getI()]);
        ag.fillRect(indent + 6, 11, 5, 3);
        ag.fillRect(indent + 6 + 10, 11, 5, 3);
        ag.fillRect(indent + 6 + 20, 11, 5, 3);
        ag.fillRect(indent + 6 + 30, 11, 5, 3);
        ag.setColor(textColor);
        ag.updateColor();
        String[] names = event.getActiveCollectionNames("ETMis");
        if (names.length == 1) {
            ag.drawString("Missing ET= " + Math.round(met) + " GeV", (double)indent + 0.6 * (double)pos, legendHeight);
        } else {
            ag.drawString("Max Missing ET= " + Math.round(met) + " GeV", (double)indent + 0.6 * (double)pos, legendHeight);
        }
    }

    public static void drawLegendMain2(AGraphics ag, int indent, int pos) {
        String modeName = AProjectionLegoPlot.mode == 0 ? "LAr" : (AProjectionLegoPlot.mode == 1 ? "LVL1TriggerTower" : "LVL1JetElement");
        AEnumeratorParameter param = (AEnumeratorParameter)APar.get(modeName, "ColorFunction");
        String colorFunction = param.getText(param.getI());
        ag.drawString(colorFunction + " (1-" + AProjectionLegoPlot.colorset.size() + ")", indent + pos, legendHeight);
        int barwidth = 6;
        int barheight = 6;
        if (AProjectionLegoPlot.getDrawEMHAD()) {
            if (AProjectionLegoPlot.colorset.size() == 2) {
                ag.setColor(AProjectionLegoPlot.defaultColorMap[AProjectionLegoPlot.colorEM]);
                ag.fillRect(indent + barwidth * 2, 28, barwidth * 2, barheight);
                ag.setColor(AProjectionLegoPlot.defaultColorMap[AProjectionLegoPlot.colorHad]);
                ag.fillRect(indent + 2 * barwidth * 2, 28, barwidth * 2, barheight);
            } else {
                int c = 0;
                ag.setColor(AProjectionLegoPlot.defaultColorMap[AProjectionLegoPlot.colorEM]);
                ag.fillRect(indent + ++c * barwidth, 28, barwidth, barheight);
                ag.setColor(AProjectionLegoPlot.defaultColorMap[AProjectionLegoPlot.colorHad]);
                ag.fillRect(indent + ++c * barwidth, 28, barwidth, barheight);
                for (int i = 0; i < AProjectionLegoPlot.caloColorMap.length; ++i) {
                    if (!AProjectionLegoPlot.colorset.contains(new Integer(i)) || i == AProjectionLegoPlot.colorEM || i == AProjectionLegoPlot.colorHad) continue;
                    ag.setColor(AProjectionLegoPlot.caloColorMap[i]);
                    ag.fillRect(indent + ++c * barwidth, 28, barwidth, barheight);
                }
            }
        } else {
            int c = 0;
            barwidth = 90 / AProjectionLegoPlot.caloColorMap.length;
            for (int i = 0; i < AProjectionLegoPlot.caloColorMap.length; ++i) {
                if (!AProjectionLegoPlot.colorset.contains(new Integer(i))) continue;
                ag.setColor(AProjectionLegoPlot.caloColorMap[i]);
                ag.fillRect(indent + ++c * barwidth, 28, barwidth, barheight);
            }
        }
    }

    public static void drawLegendMain3(AGraphics ag, double maxEt, double AODmaxEt, int indent, int pos) {
        ag.drawString("Height of tallest tower:", indent + 6, legendHeight);
        legendHeight += lineHeight;
        if (APar.get("LegoPlot", "ETAxisHeight").getD() > 0.0) {
            ag.drawString("User selection: " + Math.round(maxEt) + " GeV ", indent + 6, legendHeight);
        } else if (APar.get("LegoPlot", "ScaleToAOD").getStatus()) {
            ag.drawString("Scale to AOD: " + Math.round(maxEt) + " GeV ", indent + 6, legendHeight);
        } else if (maxEt != 0.0) {
            ag.drawString("Cells: " + Math.round(maxEt) + " GeV ", indent + 6, legendHeight);
            if (AODmaxEt != 0.0) {
                ag.drawString("AOD: " + Math.round(AODmaxEt) + " GeV ", indent + pos, legendHeight);
            }
        } else {
            ag.drawString("AOD: " + Math.round(AODmaxEt) + " GeV ", indent + 6, legendHeight);
        }
    }

    public static void drawLegendMain4(AGraphics ag, ALVL1ResultData lvl1ResultData, int indent, int pos) {
        ag.drawString("Trigger Decision:", indent + 6, legendHeight);
        legendHeight += lineHeight;
        String[] trigRes = new String[]{"NA", "NA", "NA"};
        int[] temp = new int[]{lvl1ResultData.getPassedL1(0), lvl1ResultData.getPassedL2(0), lvl1ResultData.getPassedEF(0)};
        block5: for (int i = 0; i < 3; ++i) {
            switch (temp[i]) {
                case -1: {
                    trigRes[i] = "N/C";
                    continue block5;
                }
                case 0: {
                    trigRes[i] = "failed";
                    continue block5;
                }
                case 1: {
                    trigRes[i] = "passed";
                    continue block5;
                }
                default: {
                    trigRes[i] = "NA";
                }
            }
        }
        ag.drawString("L1:" + trigRes[0] + " L2:" + trigRes[1] + " EF:" + trigRes[2], indent + 6, legendHeight);
    }

    public static void drawLegendL1ET(AGraphics ag, ALVL1ResultData[] lvl1ResultData, ATriggerInfoData triggerInfoData, int indent) {
        ag.setColor(borderColor);
        ag.fillRect(indent - 4, legendHeight, 200, (int)((double)lineHeight * 1.5));
        ag.setColor(backgroundColor);
        ag.fillRect(indent - 4 + 2, legendHeight + 2, 196, (int)((double)lineHeight * 1.5 - 4.0));
        ag.setColor(textColor);
        ag.updateColor();
        legendHeight += lineHeight;
        if (triggerInfoData == null && lvl1ResultData != null && lvl1ResultData.length > 1) {
            ag.drawString(">1 LVL1Result collections selected", indent + 6, legendHeight);
            legendHeight += lineHeight;
            return;
        }
        float LVL1EtMiss = -1.0f;
        float LVL1SumEt = -1.0f;
        if (triggerInfoData != null) {
            LVL1EtMiss = triggerInfoData.getEnergyEtMiss(0);
            LVL1SumEt = triggerInfoData.getEnergySumEt(0);
        } else if (lvl1ResultData != null && lvl1ResultData.length == 1) {
            LVL1EtMiss = lvl1ResultData[0].getEnergyEtMiss(0);
            LVL1SumEt = lvl1ResultData[0].getEnergySumEt(0);
        }
        String LVL1EtMissOutput = LVL1EtMiss > 0.0f ? "" + LVL1EtMiss : "N/A";
        String LVL1SumEtOutput = LVL1SumEt > 0.0f ? "" + LVL1SumEt : "N/A";
        ag.drawString("L1-EtMiss: " + LVL1EtMissOutput + " L1-SumEt: " + LVL1SumEtOutput, indent, legendHeight);
        legendHeight += lineHeight;
    }

    public static void drawLegendItems(AWindow window, AGraphics ag, ALVL1ResultData[] lvl1ResultData, int indent) {
        int i;
        if (lvl1ResultData != null && lvl1ResultData.length > 1) {
            ag.setColor(borderColor);
            ag.fillRect(indent - 4, legendHeight, 200, (int)((double)lineHeight * 5.5));
            ag.setColor(backgroundColor);
            ag.fillRect(indent - 4 + 2, legendHeight + 2, 196, (int)((double)lineHeight * 5.5 - 4.0));
            ag.setColor(textColor);
            ag.updateColor();
            ag.drawString(">1 LVL1Result collections selected", indent + 6, legendHeight += lineHeight);
            ag.drawString("Either select 1 LVL1Result collection", indent + 6, legendHeight += lineHeight);
            ag.drawString("from: Calo->LVL1Result", indent + 6, legendHeight += lineHeight);
            ag.drawString("or to see all items select:", indent + 6, legendHeight += lineHeight);
            ag.drawString("file->Event Properties", indent + 6, legendHeight += lineHeight);
            legendHeight += lineHeight;
            return;
        }
        if (lvl1ResultData == null) {
            ag.setColor(borderColor);
            ag.updateColor();
            ag.fillRect(window.getWidth() - 200 - 4, legendHeight + 4, 200, (int)Math.round(1.5 * (double)lineHeight));
            ag.setColor(backgroundColor);
            ag.updateColor();
            ag.fillRect(window.getWidth() - 200 - 4 + 2, legendHeight + 4 + 2, 196, (int)Math.round(1.5 * (double)lineHeight) - 4);
            ag.setColor(textColor);
            ag.updateColor();
            ag.drawString("No LVL1Result collection in event", window.getWidth() - 200 + 2, (legendHeight += lineHeight) + 4);
            return;
        }
        int origlineHeight = lineHeight;
        lineHeight = (int)((double)lineHeight * 0.8);
        int startrowHeight = legendHeight;
        int dolist1 = APar.get("LegoPlot", "L1Items").getStatus() ? 1 : 0;
        int dolist2 = APar.get("LegoPlot", "L2Items").getStatus() ? 1 : 0;
        int dolist3 = APar.get("LegoPlot", "EFItems").getStatus() ? 1 : 0;
        int maxItems = (int)Math.round((0.8 * (double)window.getHeight() - (double)legendHeight) / (double)lineHeight - 0.5);
        int columnWidth = 72;
        int maxColumns = (int)Math.floor(0.9 * (double)window.getWidth() / (double)columnWidth);
        String[][] items = new String[3][];
        if (dolist1 > 0) {
            items[0] = ALegoDraw.newList("---L1 items---", lvl1ResultData[0].getCtpItemListSplit(0, true));
        }
        if (dolist2 > 0) {
            items[1] = ALegoDraw.newList("---L2 items---", lvl1ResultData[0].getitemListL2Split(0, true));
        }
        if (dolist3 > 0) {
            items[2] = ALegoDraw.newList("---EF items---", lvl1ResultData[0].getitemListEFSplit(0, true));
        }
        int[] num = new int[]{dolist1 == 0 ? 0 : (int)Math.ceil((double)items[0].length / (double)maxItems), dolist2 == 0 ? 0 : (int)Math.ceil((double)items[1].length / (double)maxItems), dolist3 == 0 ? 0 : (int)Math.ceil((double)items[2].length / (double)maxItems)};
        boolean doWarning = false;
        if (num[0] + num[1] + num[2] > maxColumns) {
            int av = (int)Math.floor((double)maxColumns / (double)(dolist1 + dolist2 + dolist3));
            if (dolist1 > 0) {
                num[0] = av;
            }
            if (dolist2 > 0) {
                num[1] = av;
            }
            if (dolist3 > 0) {
                num[2] = av;
            }
            doWarning = true;
        }
        int noOfColumns = num[0] + num[1] + num[2];
        String[][] list = new String[noOfColumns][maxItems];
        int list_counter = 0;
        for (i = 0; i < 3; ++i) {
            int item_counter = 0;
            for (int j = 0; j < num[i]; ++j) {
                for (int k = 0; k < maxItems; ++k) {
                    list[list_counter][k] = item_counter < items[i].length ? items[i][item_counter] : "";
                    ++item_counter;
                }
                ++list_counter;
            }
        }
        ag.setColor(borderColor);
        ag.fillRect(window.getWidth() - noOfColumns * columnWidth - 4, legendHeight, noOfColumns * columnWidth, (int)Math.round(((double)maxItems + 0.5) * (double)lineHeight));
        for (i = 0; i < noOfColumns; ++i) {
            legendHeight = startrowHeight;
            ag.setColor(backgroundColor);
            ag.updateColor();
            ag.fillRect(window.getWidth() - (noOfColumns - i) * columnWidth - 4 + 2, legendHeight + 2, columnWidth - 4, (int)Math.round(((double)maxItems + 0.5) * (double)lineHeight) - 4);
            ag.setColor(textColor);
            ag.updateColor();
            for (int j = 0; j < maxItems; ++j) {
                ag.drawString(list[i][j], window.getWidth() - (noOfColumns - i) * columnWidth + 2, legendHeight += lineHeight);
            }
        }
        if (doWarning) {
            ag.setColor(borderColor);
            ag.updateColor();
            ag.fillRect(window.getWidth() - 90 - 4, (legendHeight += lineHeight) + 4, 90, (int)Math.round(2.5 * (double)lineHeight));
            ag.setColor(backgroundColor);
            ag.updateColor();
            ag.fillRect(window.getWidth() - 90 - 4 + 2, legendHeight + 4 + 2, 86, (int)Math.round(2.5 * (double)lineHeight) - 4);
            ag.setColor(textColor);
            ag.updateColor();
            ag.drawString(" more items in", window.getWidth() - 90 + 2, (legendHeight += lineHeight) + 4);
            ag.drawString("event properties", window.getWidth() - 90 + 2, (legendHeight += lineHeight) + 4);
        }
        lineHeight = origlineHeight;
    }

    static String[] newList(String first, String[] rest) {
        int counter = 2;
        if (rest != null) {
            counter += rest.length - 1;
        }
        String[] editedList = new String[counter];
        editedList[0] = first;
        if (rest != null) {
            System.arraycopy(rest, 0, editedList, 1, rest.length);
        } else {
            editedList[1] = "N/A";
        }
        return editedList;
    }

    static void drawline(AWindow window, AGraphics ag, Point2D.Double from, Point2D.Double to) {
        from = window.calculateDisplay(from);
        to = window.calculateDisplay(to);
        ag.drawLine(from.x, from.y, to.x, to.y);
    }

    static void drawline(AWindow window, AGraphics ag, double fromX, double fromY, double toX, double toY) {
        Point2D.Double from = new Point2D.Double(fromX, fromY);
        Point2D.Double to = new Point2D.Double(toX, toY);
        ALegoDraw.drawline(window, ag, from, to);
    }

    static void drawline(AWindow window, AGraphics ag, double fromX, double fromY, double toX, double toY, int etAxisMaximum) {
        fromY = -5.0 - (1.0 - AProjectionLegoPlot.getyz(window.getIndex())) * 50.0 * (fromY / (double)etAxisMaximum) * 0.9;
        toY = -5.0 - (1.0 - AProjectionLegoPlot.getyz(window.getIndex())) * 50.0 * (toY / (double)etAxisMaximum) * 0.9;
        Point2D.Double from = new Point2D.Double(fromX, fromY);
        Point2D.Double to = new Point2D.Double(toX, toY);
        ALegoDraw.drawline(window, ag, from, to);
    }

    static void drawstring(AWindow window, AGraphics ag, String str, double hereX, double hereY) {
        Point2D.Double here = new Point2D.Double(hereX, hereY);
        here = window.calculateDisplay(here);
        ag.drawString(str, here.x, here.y);
    }

    static void drawstring(AWindow window, AGraphics ag, String str, double hereX, double hereY, int etAxisMaximum) {
        hereY = -5.0 - (1.0 - AProjectionLegoPlot.getyz(window.getIndex())) * 50.0 * (hereY / (double)etAxisMaximum) * 0.9;
        Point2D.Double here = new Point2D.Double(hereX, hereY);
        here = window.calculateDisplay(here);
        ag.drawString(str, here.x, here.y);
    }

    public static void drawGrid(AWindow window, AGraphics ag, double maxEt) {
        String str;
        int width = window.getSize().width;
        int dpi = 72;
        int newFontSize = (int)Math.round(35.0 * Math.sqrt(width) / (double)dpi);
        float originalFontSize = ag.g.getFont().getSize2D();
        Font f = new Font("SansSerif", 0, newFontSize);
        ag.setFont(f);
        ag.setColor(Color.darkGray);
        if (backgroundColor.getBlue() + backgroundColor.getGreen() + backgroundColor.getRed() < 400) {
            ag.setColor(Color.lightGray);
        }
        ag.updateColor();
        ag.setLineWidth(3);
        int etAxisMaximum = (int)(maxEt *= (double)AProjectionLegoPlot.nPhiCells / 64.0 * (double)AProjectionLegoPlot.nEtaCells / 100.0);
        int etAxisScale = 10;
        if (AProjectionLegoPlot.defaultScale == 1) {
            etAxisScale = 1;
        } else if (maxEt > 10.0) {
            etAxisScale = 10 * (int)Math.ceil(maxEt / 100.0);
        } else if (maxEt == 10.0) {
            etAxisScale = 5;
        } else if (maxEt < 10.0) {
            etAxisScale = 2;
        }
        double lowPhi = -360.0 * AProjectionLegoPlot.getxz(window.getIndex());
        int ticksizex = 10;
        double ticksizey = 0.5;
        ALegoDraw.drawline(window, ag, lowPhi, 0.0, lowPhi, etAxisMaximum, etAxisMaximum);
        int s = etAxisMaximum - etAxisScale;
        while ((double)s >= 0.0) {
            ALegoDraw.drawline(window, ag, lowPhi, s, lowPhi + (double)ticksizex, s, etAxisMaximum);
            if (AProjectionLegoPlot.defaultScale == 1) {
                ALegoDraw.drawstring(window, ag, "10^" + Integer.toString(s + AProjectionLegoPlot.minimumofLogScale), lowPhi + (double)(2 * ticksizex), s, etAxisMaximum);
            } else {
                ALegoDraw.drawstring(window, ag, Integer.toString(s), lowPhi + (double)(2 * ticksizex), s, etAxisMaximum);
            }
            s -= etAxisScale;
        }
        ALegoDraw.drawline(window, ag, lowPhi, etAxisMaximum, lowPhi + (double)ticksizex, etAxisMaximum, etAxisMaximum);
        if (AProjectionLegoPlot.defaultScale == 1) {
            ALegoDraw.drawstring(window, ag, "10^" + Integer.toString(etAxisMaximum + AProjectionLegoPlot.minimumofLogScale) + " ET/R(.01) (GeV)", lowPhi + (double)(2 * ticksizex), etAxisMaximum, etAxisMaximum);
        } else if (AProjectionLegoPlot.defaultScale == 2) {
            ALegoDraw.drawstring(window, ag, Integer.toString(etAxisMaximum) + " ET/R(.01) (GeV)^1/2", lowPhi + (double)(2 * ticksizex), etAxisMaximum, etAxisMaximum);
        } else {
            ALegoDraw.drawstring(window, ag, Integer.toString(etAxisMaximum) + " ET/R(.01) (GeV)", lowPhi + (double)(2 * ticksizex), etAxisMaximum, etAxisMaximum);
        }
        int t = -1;
        for (double p = 0.0; p <= 1.0; p += 0.125) {
            ALegoDraw.drawline(window, ag, 360.0 * p + lowPhi, -5.0, 360.0 * p, 5.0);
            if (++t % 2 != 0) continue;
            ALegoDraw.drawline(window, ag, 360.0 * p, 5.0, 360.0 * p, 5.0 + ticksizey);
            str = new Integer((int)(360.0 * p)).toString();
            ALegoDraw.drawstring(window, ag, str, 360.0 * p - 7.0, 5.0 + 2.0 * Math.sqrt(ticksizey));
        }
        ALegoDraw.drawstring(window, ag, "\u03a6", 216.0, 5.0 + 3.0 * Math.sqrt(ticksizey));
        for (double e = 0.0; e <= 1.0; e += 0.1) {
            ALegoDraw.drawline(window, ag, lowPhi * (1.0 - e), 10.0 * e - 5.0, 360.0 + lowPhi * (1.0 - e), 10.0 * e - 5.0);
            ALegoDraw.drawline(window, ag, lowPhi * (1.0 - e), 10.0 * e - 5.0, lowPhi * (1.0 - e), 10.0 * e - 5.0 + ticksizey);
            str = new Integer((int)Math.round(e * 10.0) - 5).toString();
            if (AProjectionLegoPlot.reverse) {
                str = new Integer((int)Math.round(-e * 10.0) + 5).toString();
            }
            ALegoDraw.drawstring(window, ag, str, lowPhi * (1.0 - e) - 20.0, 10.0 * e - 5.0 + 3.0 * Math.sqrt(ticksizey));
        }
        ALegoDraw.drawstring(window, ag, "\u03b7", 0.5 * lowPhi - 30.0, 5.0 * Math.sqrt(ticksizey));
        ag.g.setFont(ag.g.getFont().deriveFont(originalFontSize));
    }

    public static void drawJet(double et, double eta, double phi, Color color, AWindow window, AGraphics ag, double radius) {
        int i;
        double x = phi * 360.0 / (Math.PI * 2);
        int numPoints = 128;
        double[][] hj = new double[2][numPoints];
        double[][] vj = new double[2][numPoints];
        int phiwrap = 0;
        double old_jetx = -1.0;
        int[] pj = new int[2];
        pj[1] = 0;
        pj[0] = 0;
        for (int p = 0; p < numPoints; ++p) {
            double jetx_diff;
            double jetx = x + radius * 36.0 * Math.cos(Math.PI * 2 * (double)p / (double)(numPoints - 1));
            if (jetx < 0.0) {
                jetx += 360.0;
            }
            if (jetx >= 360.0) {
                jetx -= 360.0;
            }
            if (old_jetx > 0.0 && (jetx_diff = Math.abs(jetx - old_jetx)) > 180.0) {
                phiwrap = (phiwrap + 1) % 2;
            }
            old_jetx = jetx;
            double y = eta;
            if (AProjectionLegoPlot.reverse) {
                y = -y;
            }
            double jety = y + radius * Math.sin(Math.PI * 2 * (double)p / (double)(numPoints - 1));
            jetx = AProjectionLegoPlot.adjustPhi(window, jetx, jety);
            Point2D.Double[] corners = window.getUserCorners();
            if (jetx < corners[0].x || jetx > corners[1].x || jety < corners[1].y || jety > corners[2].y) continue;
            hj[phiwrap][pj[phiwrap]] = jetx;
            vj[phiwrap][pj[phiwrap]] = jety;
            int n = phiwrap;
            pj[n] = pj[n] + 1;
        }
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        for (i = 0; i < pj[0]; ++i) {
            p = window.calculateDisplay(hj[0][i], vj[0][i]);
            hj[0][i] = p.x;
            vj[0][i] = p.y;
        }
        p.x = 0.0;
        p.y = 0.0;
        for (i = 0; i < pj[1]; ++i) {
            p = window.calculateDisplay(hj[1][i], vj[1][i]);
            hj[1][i] = p.x;
            vj[1][i] = p.y;
        }
        Stroke origStroke = ag.getGraphics2D().getStroke();
        boolean drawFrames = AColorMap.drawFrames();
        ag.setStroke(new BasicStroke(3.0f));
        if (drawFrames) {
            ag.setColor(AProjectionLegoPlot.defaultColorMap[26]);
        } else {
            ag.setColor(color);
        }
        if (pj[0] > 2) {
            ag.drawPolygon(hj[0], vj[0], pj[0]);
        }
        if (pj[1] > 2) {
            ag.drawPolygon(hj[1], vj[1], pj[1]);
        }
        if (drawFrames && !color.equals(AProjectionLegoPlot.defaultColorMap[26])) {
            ag.setStroke(new BasicStroke(1.0f));
            ag.setColor(color);
            if (pj[0] > 2) {
                ag.drawPolygon(hj[0], vj[0], pj[0]);
            }
            if (pj[1] > 2) {
                ag.drawPolygon(hj[1], vj[1], pj[1]);
            }
        }
        ag.setStroke(origStroke);
    }

    public static void drawJetText(double et, double eta, double phi, Color color, AWindow window, AGraphics ag, double radius) {
        double x = phi * 360.0 / (Math.PI * 2);
        int numPoints = 128;
        double[][] hj = new double[2][numPoints];
        double[][] vj = new double[2][numPoints];
        int phiwrap = 0;
        double old_jetx = -1.0;
        int[] pj = new int[2];
        pj[1] = 0;
        pj[0] = 0;
        for (int p = 0; p < numPoints; ++p) {
            double jetx_diff;
            double jetx = x + radius * 36.0 * Math.cos(Math.PI * 2 * (double)p / (double)(numPoints - 1));
            if (jetx < 0.0) {
                jetx += 360.0;
            }
            if (jetx >= 360.0) {
                jetx -= 360.0;
            }
            if (old_jetx > 0.0 && (jetx_diff = Math.abs(jetx - old_jetx)) > 180.0) {
                phiwrap = (phiwrap + 1) % 2;
            }
            old_jetx = jetx;
            double y = eta;
            if (AProjectionLegoPlot.reverse) {
                y = -y;
            }
            double jety = y + radius * Math.sin(Math.PI * 2 * (double)p / (double)(numPoints - 1));
            jetx = AProjectionLegoPlot.adjustPhi(window, jetx, jety);
            Point2D.Double[] corners = window.getUserCorners();
            if (jetx < corners[0].x || jetx > corners[1].x || jety < corners[1].y || jety > corners[2].y) continue;
            hj[phiwrap][pj[phiwrap]] = jetx;
            vj[phiwrap][pj[phiwrap]] = jety;
            int n = phiwrap;
            pj[n] = pj[n] + 1;
        }
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < pj[0]; ++i) {
            p = window.calculateDisplay(hj[0][i], vj[0][i]);
            hj[0][i] = p.x;
            vj[0][i] = p.y;
        }
        String s = Double.toString(et);
        int dot = s.indexOf(46);
        String ss = s.substring(0, dot + 0);
        float originalFontSize = ag.g.getFont().getSize2D();
        float newFontSize = 25.0f;
        ag.g.setFont(ag.g.getFont().deriveFont(newFontSize));
        ag.g.setColor(color);
        ag.drawString(" " + ss, hj[0][0], vj[0][0]);
        ag.g.setFont(ag.g.getFont().deriveFont(originalFontSize));
    }

    public static void drawMissEt(AWindow window, AGraphics ag, int phi, double pt, Color color, double maxEt) {
        ag.setColor(color);
        int etabin = AProjectionLegoPlot.nEtaCells / 2;
        ALegoDraw.drawBox(window, ag, phi, etabin, -21, 0.0, pt, maxEt);
        double phibinsize = 360.0 / (double)AProjectionLegoPlot.nPhiCells;
        double[] h = new double[4];
        double[] v = new double[4];
        double etaChange = 0.5;
        for (double etaStart = -5.0; etaStart < 5.0; etaStart += 2.0 * etaChange) {
            v[0] = etaStart;
            h[0] = AProjectionLegoPlot.adjustPhi(window, (double)phi * phibinsize, v[0]);
            v[1] = v[0] + etaChange;
            h[1] = AProjectionLegoPlot.adjustPhi(window, (double)phi * phibinsize, v[1]);
            v[2] = v[1];
            h[2] = h[1] + phibinsize;
            v[3] = v[0];
            h[3] = h[0] + phibinsize;
            Point2D.Double p = new Point2D.Double(0.0, 0.0);
            for (int i = 0; i < 4; ++i) {
                p = window.calculateDisplay(h[i], v[i]);
                h[i] = p.x;
                v[i] = p.y;
            }
            ag.fillPolygon(h, v, 4);
        }
    }

    public static void drawBox(AWindow window, AGraphics ag, int phi, int eta, int colouring, double et1, double et2, double maxEt) {
        Color drawingColor;
        switch (colouring) {
            case -21: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("ETMis", "Constant").getI()];
                break;
            }
            case -2: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("Muon", "Constant").getI()];
                break;
            }
            case -3: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("Electron", "Constant").getI()];
                break;
            }
            case -4: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("Photon", "Constant").getI()];
                break;
            }
            case -5: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("Cluster", "Constant").getI()];
                break;
            }
            case -6: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("CompositeParticle", "Constant").getI()];
                break;
            }
            case -7: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("BJet", "Constant").getI()];
                break;
            }
            case -8: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("TauJet", "Constant").getI()];
                break;
            }
            case -9: {
                drawingColor = AProjectionLegoPlot.defaultColorMap[APar.get("Jet", "Constant").getI()];
                break;
            }
            default: {
                drawingColor = AProjectionLegoPlot.caloColorMap[colouring];
            }
        }
        int object = -colouring;
        switch (APar.get("LegoPlot", "TowerOutlines").getI()) {
            case 0: {
                break;
            }
            case 1: {
                colouring *= -1;
                break;
            }
            case 2: {
                colouring = -1;
                break;
            }
            case 3: {
                colouring = 1;
            }
        }
        double phibinsize = 360.0 / (double)AProjectionLegoPlot.nPhiCells;
        double etabinsize = 10.0 / (double)AProjectionLegoPlot.nEtaCells;
        double x = (double)phi * phibinsize;
        double y = (double)eta * etabinsize - 5.0;
        if (object > 0) {
            phibinsize = 5.625;
            etabinsize = 0.1;
        }
        double x1 = AProjectionLegoPlot.adjustPhi(window, x, y);
        double x2 = AProjectionLegoPlot.adjustPhi(window, x, y - etabinsize);
        double[][] h = new double[3][4];
        double[][] v = new double[3][4];
        et1 = (1.0 - AProjectionLegoPlot.getyz(window.getIndex())) * 50.0 * (et1 / maxEt) * 0.9;
        et2 = et1 + (1.0 - AProjectionLegoPlot.getyz(window.getIndex())) * 50.0 * (et2 / maxEt) * 0.9;
        if (object > 0) {
            et1 /= (double)AProjectionLegoPlot.nPhiCells / 64.0 * (double)AProjectionLegoPlot.nEtaCells / 100.0;
            et2 /= (double)AProjectionLegoPlot.nPhiCells / 64.0 * (double)AProjectionLegoPlot.nEtaCells / 100.0;
        }
        h[0][0] = x1;
        v[0][0] = y - et1;
        h[0][1] = x1;
        v[0][1] = y - et2;
        h[0][2] = x1 + phibinsize;
        v[0][2] = y - et2;
        h[0][3] = x1 + phibinsize;
        v[0][3] = y - et1;
        h[1][0] = x2;
        v[1][0] = y - et2 - etabinsize;
        h[1][1] = x1;
        v[1][1] = y - et2;
        h[1][2] = x1 + phibinsize;
        v[1][2] = y - et2;
        h[1][3] = x2 + phibinsize;
        v[1][3] = y - et2 - etabinsize;
        h[2][0] = x2;
        v[2][0] = y - et2 - etabinsize;
        h[2][1] = x1;
        v[2][1] = y - et2;
        h[2][2] = x1;
        v[2][2] = y - et1;
        h[2][3] = x2;
        v[2][3] = y - et1 - etabinsize;
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < 4; ++i) {
            p = window.calculateDisplay(h[0][i], v[0][i]);
            h[0][i] = p.x;
            v[0][i] = p.y;
            p.x = 0.0;
            p.y = 0.0;
            p = window.calculateDisplay(h[1][i], v[1][i]);
            h[1][i] = p.x;
            v[1][i] = p.y;
            p.x = 0.0;
            p.y = 0.0;
            p = window.calculateDisplay(h[2][i], v[2][i]);
            h[2][i] = p.x;
            v[2][i] = p.y;
        }
        Color dc = drawingColor.darker();
        ag.setColor(new Color(dc.getRed(), dc.getGreen(), dc.getBlue()));
        if (colouring >= 0) {
            ag.fillPolygon(h[2], v[2], 4);
        } else {
            ag.drawPolygon(h[2], v[2], 4);
        }
        ag.setColor(drawingColor);
        if (colouring >= 0) {
            ag.fillPolygon(h[0], v[0], 4);
        } else {
            ag.drawPolygon(h[0], v[0], 4);
        }
        Color ddc = drawingColor.darker().darker();
        ag.setColor(new Color(ddc.getRed(), ddc.getGreen(), ddc.getBlue()));
        if (colouring >= 0) {
            ag.fillPolygon(h[1], v[1], 4);
        } else {
            ag.drawPolygon(h[1], v[1], 4);
        }
    }
}

