/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ATrackData;
import atlantis.data.ATrackResidualData;
import atlantis.event.AData;
import atlantis.graphics.AGraphics;
import atlantis.graphics.ATemplateGraphics2D;
import atlantis.list.AList;
import atlantis.projection.AProjectionTrackResidual;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class APickingGraphics2D
extends ATemplateGraphics2D {
    private static ALogger logger = ALogger.getLogger(APickingGraphics2D.class);
    public static final int PICK_HITS_AND_TRACKS = 0;
    public static final int PICK_DETECTORS = 1;
    public static final int MOVE = 2;
    public static final int PICK_RESIDUAL = 3;
    public static int mode;
    static AData pickedData;
    static ATrackResidualData pickedResidual;
    static ArrayList pickedDetectors;
    static int pickedIndex;
    public static Point pickedPoint;
    static double minDist;
    public static double pickedH;
    public static double pickedV;
    private static JPopupMenu residualPopupMenu;
    private static final String SHOW_RESIDUALS_X = "Show Residual X";
    private static final String SHOW_PULLS_X = "Show Pull X";

    public APickingGraphics2D(Rectangle bounds, int m, Point p) {
        super(bounds);
        mode = m;
        pickedPoint = p;
        minDist = 1.0E7;
        if (mode != 2) {
            pickedData = null;
            pickedIndex = -1;
        }
        if (pickedDetectors == null) {
            pickedDetectors = new ArrayList();
        } else {
            pickedDetectors.clear();
        }
    }

    APickingGraphics2D(APickingGraphics2D a) {
        super(a);
    }

    public Graphics create() {
        return new APickingGraphics2D(this);
    }

    public void drawLine(double h0, double v0, double h1, double v1) {
        double vClosest;
        double hClosest;
        double u;
        double vPicked;
        double delV;
        if (mode == 1) {
            return;
        }
        if (AGraphics.currentData == null) {
            return;
        }
        if (mode == 2 && (AGraphics.currentData != pickedData || AGraphics.currentIndex != pickedIndex)) {
            return;
        }
        double hPicked = pickedPoint.getX();
        double delH = h0 - hPicked;
        double dist = delH * delH + (delV = v0 - (vPicked = pickedPoint.getY())) * delV;
        if (dist < minDist) {
            minDist = dist;
            APickingGraphics2D.setPicked(h0, v0);
        }
        if ((dist = (delH = h1 - hPicked) * delH + (delV = v1 - vPicked) * delV) < minDist) {
            minDist = dist;
            APickingGraphics2D.setPicked(h1, v1);
        }
        double h10 = h1 - h0;
        double v10 = v1 - v0;
        double hp0 = hPicked - h0;
        double vp0 = vPicked - v0;
        double size = h10 * h10 + v10 * v10;
        if (size > 0.0 && (u = (h10 * hp0 + v10 * vp0) / size) > 0.0 && u < 1.0 && (dist = (delH = (hClosest = h0 + u * h10) - hPicked) * delH + (delV = (vClosest = v0 + u * v10) - vPicked) * delV) < minDist) {
            minDist = dist;
            APickingGraphics2D.setPicked(hClosest, vClosest);
        }
    }

    public void fillRect(int h, int v, int width, int height) {
        String info;
        if (mode == 1 && AGraphics.currentDetector != null && !pickedDetectors.contains(info = AGraphics.currentDetector.getInfo(AGraphics.currentIndex))) {
            pickedDetectors.add(info);
        }
        double dh = (double)width / 2.0;
        double dv = (double)height / 2.0;
        this.drawLine((double)h - dh, (double)v - dv, (double)h + dh, (double)v - dv);
        this.drawLine((double)h + dh, (double)v - dv, (double)h + dh, (double)v + dv);
        this.drawLine((double)h + dh, (double)v + dv, (double)h - dh, (double)v + dv);
        this.drawLine((double)h - dh, (double)v + dv, (double)h - dh, (double)v - dv);
    }

    public void draw(Shape s) {
        PathIterator path = s.getPathIterator(null);
        double[] coords = new double[6];
        double h0 = 0.0;
        double v0 = 0.0;
        double h1 = 0.0;
        double v1 = 0.0;
        double hInit = 0.0;
        double vInit = 0.0;
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    h0 = coords[0];
                    v0 = coords[1];
                    hInit = h0;
                    vInit = v0;
                    break;
                }
                case 1: 
                case 3: {
                    h1 = coords[0];
                    v1 = coords[1];
                    this.drawLine(h0, v0, h1, v1);
                    h0 = h1;
                    v0 = v1;
                    break;
                }
                case 4: {
                    this.drawLine(h0, v0, hInit, vInit);
                    break;
                }
                default: {
                    logger.error(" Error unknown segment type");
                }
            }
            path.next();
        }
    }

    public void fill(Shape s) {
        if (mode == 1 && AGraphics.currentDetector != null) {
            String info;
            double[][] hv = this.getPolygon(s);
            if (AGraphics.isPointInside(hv[0], hv[1], hv[0].length, pickedPoint.getX(), pickedPoint.getY()) && !pickedDetectors.contains(info = AGraphics.currentDetector.getInfo(AGraphics.currentIndex))) {
                pickedDetectors.add(info);
            }
        } else {
            this.draw(s);
        }
    }

    public double[][] getPolygon(Shape s) {
        double[] coords = new double[6];
        int numPoints = 0;
        PathIterator path = s.getPathIterator(null);
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    ++numPoints;
                    break;
                }
                case 1: 
                case 3: {
                    ++numPoints;
                    break;
                }
                case 4: {
                    break;
                }
            }
            path.next();
        }
        double[][] hv = new double[2][numPoints];
        numPoints = 0;
        path = s.getPathIterator(null);
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    hv[0][numPoints] = coords[0];
                    hv[1][numPoints] = coords[1];
                    ++numPoints;
                    break;
                }
                case 1: 
                case 3: {
                    hv[0][numPoints] = coords[0];
                    hv[1][numPoints] = coords[1];
                    ++numPoints;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    logger.error(" Error unknown segment type");
                }
            }
            path.next();
        }
        return hv;
    }

    private static void setPicked(double h, double v) {
        pickedData = AGraphics.currentData;
        pickedIndex = AGraphics.currentIndex;
        pickedH = h;
        pickedV = v;
    }

    public static AData getPickedData() {
        return pickedData;
    }

    public static ATrackResidualData getPickedResidual() {
        return pickedResidual;
    }

    public static int getPickedH() {
        return (int)Math.rint(pickedH);
    }

    public static int getPickedV() {
        return (int)Math.rint(pickedV);
    }

    public static AList getPickedHit() {
        if (pickedData != null) {
            return new AList(pickedData, pickedIndex);
        }
        return null;
    }

    public static Integer getPickedHitIndex() {
        if (pickedData != null) {
            return new Integer(pickedIndex);
        }
        return null;
    }

    public static void setPicked(AData data, int index) {
        pickedData = data;
        pickedIndex = index;
    }

    public static void setPicked(ATrackResidualData data) {
        pickedResidual = data;
    }

    public static void printPicked() {
        if (mode == 3) {
            AOutput.alwaysAppend("\n\n" + pickedResidual.getHitInfo(), "PICK");
            mode = 0;
        } else if (pickedData != null) {
            AOutput.alwaysAppend("\n\n" + pickedData.getHitInfo(pickedIndex), "PICK");
        } else if (pickedDetectors != null && pickedDetectors.size() > 0) {
            AOutput.alwaysAppend("\n\nYou are inside:\n", "PICK");
            for (int i = 0; i < pickedDetectors.size(); ++i) {
                AOutput.alwaysAppend(" " + pickedDetectors.get(i) + "\n", "PICK");
            }
        }
    }

    public static void navigatePicked() {
        if (pickedData != null) {
            String navigateInfo = pickedData.navigate(pickedIndex);
            AOutput.alwaysAppend("\n" + navigateInfo + "\n", "PICK");
        }
    }

    public static void showTrackResiduals(AWindow window, int x, int y) {
        residualPopupMenu.show(window, x, y);
    }

    static {
        pickedData = null;
        pickedResidual = null;
        residualPopupMenu = new JPopupMenu();
        ResidualPopupMenuActionListener residualPopupActionListener = new ResidualPopupMenuActionListener();
        residualPopupMenu.add(SHOW_RESIDUALS_X).addActionListener(residualPopupActionListener);
        residualPopupMenu.add(SHOW_PULLS_X).addActionListener(residualPopupActionListener);
    }

    static class ResidualPopupMenuActionListener
    implements ActionListener {
        ResidualPopupMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            String residualWindowName = "B";
            if (ACanvas.getCanvas().isValidWindowName(residualWindowName)) {
                AWindow residualWindow = ACanvas.getCanvas().getWindow(residualWindowName);
                AProjectionTrackResidual residualProj = (AProjectionTrackResidual)AProjectionsManager.getProjection("TrackResidual");
                if (action.equals(APickingGraphics2D.SHOW_RESIDUALS_X)) {
                    residualProj.setResidualType(ATrackResidualData.RESIDUAL_X);
                } else if (action.equals(APickingGraphics2D.SHOW_PULLS_X)) {
                    residualProj.setResidualType(ATrackResidualData.PULL_X);
                }
                ATrackData trackData = (ATrackData)pickedData;
                residualProj.setResidual(trackData.getTrackResidual(pickedIndex));
                ACanvas.getCanvas().moveToFrontWindow(residualWindowName);
                residualWindow.setProjection(residualProj);
            } else {
                AOutput.append("\nWindow " + residualWindowName + " is not available in current layout" + "\n", "WARNING");
            }
        }
    }
}

