/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.graphics.APickingGraphics2D;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class APixelGraphics
extends AGraphics {
    APixelGraphics(Graphics g) {
        super(g);
    }

    public void setLineWidth(int lineWidth) {
    }

    public void drawLine(double h0, double v0, double h1, double v1) {
        if (this.clipper.isLineWithin(h0, v0, h1, v1)) {
            double[][] hvClipped = this.clipper.getHV();
            double h0Clipped = hvClipped[0][0];
            double v0Clipped = hvClipped[1][0];
            double h1Clipped = hvClipped[0][1];
            double v1Clipped = hvClipped[1][1];
            if (this.lineWidth == 1) {
                this.updateColor();
                this.g.drawLine((int)h0Clipped, (int)v0Clipped, (int)h1Clipped, (int)v1Clipped);
            } else {
                this.drawThickLine(h0Clipped, v0Clipped, h1Clipped, v1Clipped);
            }
        }
    }

    private void drawThickLine(double h0, double v0, double h1, double v1) {
        double h = Math.abs(h1 - h0);
        double v = Math.abs(v1 - v0);
        for (int i = 0; i < this.lineWidth; ++i) {
            int d = i + (101 - this.lineWidth) / 2 - 50;
            int h0new = (int)h0;
            int v0new = (int)v0;
            int h1new = (int)h1;
            int v1new = (int)v1;
            if (h > v) {
                v0new += d;
                v1new += d;
            } else {
                h0new += d;
                h1new += d;
            }
            if (!this.clipper.isLineWithin(h0new, v0new, h1new, v1new)) continue;
            this.updateColor();
            h0new = (int)this.clipper.getH0();
            v0new = (int)this.clipper.getV0();
            h1new = (int)this.clipper.getH1();
            v1new = (int)this.clipper.getV1();
            this.g.drawLine(h0new, v0new, h1new, v1new);
        }
    }

    public void drawSmoothLine(double h0, double v0, double ch0, double cv0, double ch1, double cv1, double h1, double v1) {
        GeneralPath curve = new GeneralPath();
        for (int i = 0; i < this.lineWidth; ++i) {
            float dv;
            float dh;
            int d = i + (101 - this.lineWidth) / 2 - 50;
            if (Math.abs(h1 - h0) > Math.abs(v1 - v0)) {
                dh = 0.0f;
                dv = d;
            } else {
                dh = d;
                dv = 0.0f;
            }
            curve.moveTo((float)h0 + dh, (float)v0 + dv);
            curve.curveTo((float)ch0 + dh, (float)cv0 + dv, (float)ch1 + dh, (float)cv1 + dv, (float)h1 + dh, (float)v1 + dv);
        }
        this.updateColor();
        this.g.draw(curve);
    }

    protected void fillRect(double h, double v, int width, int height) {
        this.updateColor();
        this.g.fillRect((int)(h - (double)width / 2.0), (int)(v - (double)height / 2.0), width, height);
    }

    public void drawPolygon(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 0);
        if (type == 0 || type == 3) {
            for (int i = 0; i < numPoints - 1; ++i) {
                this.drawLine(h[i], v[i], h[i + 1], v[i + 1]);
            }
            if (numPoints > 1) {
                this.drawLine(h[numPoints - 1], v[numPoints - 1], h[0], v[0]);
            }
        }
    }

    public void drawPolyline(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 1);
        if (type == 0 || type == 3) {
            double lasth = 0.0;
            double lastv = 0.0;
            for (int i = 0; i < numPoints - 1; ++i) {
                double diffv;
                double diffh;
                if (i == 0) {
                    lasth = h[1];
                    lastv = v[1];
                    this.drawLine(h[0], v[0], h[1], v[1]);
                }
                if (!((diffh = h[i + 1] - lasth) * diffh + (diffv = v[i + 1] - lastv) * diffv > 1.0)) continue;
                this.drawLine(lasth, lastv, h[i + 1], v[i + 1]);
                lasth = h[i + 1];
                lastv = v[i + 1];
            }
        }
    }

    public void drawDottedPolyline(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 1);
        if (type == 0 || type == 3) {
            for (int i = 0; i < numPoints - 1; i += 2) {
                this.drawLine(h[i], v[i], h[i + 1], v[i + 1]);
            }
        }
    }

    public void drawSmoothPolyline(double[] h0, double[] v0, int numPoints0) {
        if (numPoints0 < 3 || this.g instanceof APickingGraphics2D) {
            this.drawPolyline(h0, v0, numPoints0);
            return;
        }
        int type = this.getContainmentType(h0, v0, numPoints0, 1);
        if (type == 0 || type == 3) {
            int i;
            int numPoints = 3 * numPoints0 - 2;
            float[] h = new float[numPoints];
            float[] v = new float[numPoints];
            block5: for (i = 0; i < numPoints; ++i) {
                switch (i % 3) {
                    case 0: {
                        h[i] = (float)h0[i / 3];
                        v[i] = (float)v0[i / 3];
                        continue block5;
                    }
                    case 1: {
                        h[i] = (float)(0.6666666666666666 * h0[i / 3] + 0.3333333333333333 * h0[i / 3 + 1]);
                        v[i] = (float)(0.6666666666666666 * v0[i / 3] + 0.3333333333333333 * v0[i / 3 + 1]);
                        continue block5;
                    }
                    case 2: {
                        h[i] = (float)(0.3333333333333333 * h0[i / 3] + 0.6666666666666666 * h0[i / 3 + 1]);
                        v[i] = (float)(0.3333333333333333 * v0[i / 3] + 0.6666666666666666 * v0[i / 3 + 1]);
                    }
                }
            }
            for (i = 3; i < numPoints - 2; i += 3) {
                double phiRight;
                double lenLeft = Math.sqrt(Math.pow(h[i] - h[i - 1], 2.0) + Math.pow(v[i] - v[i - 1], 2.0));
                double lenRight = Math.sqrt(Math.pow(h[i + 1] - h[i], 2.0) + Math.pow(v[i + 1] - v[i], 2.0));
                if (lenLeft < 1.0E-6 || lenRight < 1.0E-6) continue;
                double phiLeft = Math.atan2(v[i] - v[i - 1], h[i] - h[i - 1]);
                if (phiLeft - (phiRight = Math.atan2(v[i + 1] - v[i], h[i + 1] - h[i])) > Math.PI) {
                    phiRight += Math.PI * 2;
                } else if (phiRight - phiLeft > Math.PI) {
                    phiLeft += Math.PI * 2;
                }
                if (Math.abs(phiLeft - phiRight) > 1.5707963267948966) {
                    float f = h[i];
                    h[i + 1] = f;
                    h[i - 1] = f;
                    float f2 = v[i];
                    v[i + 1] = f2;
                    v[i - 1] = f2;
                    continue;
                }
                double phi = (lenRight * phiLeft + lenLeft * phiRight) / (lenLeft + lenRight);
                h[i - 1] = h[i] - (float)(lenLeft * Math.cos(phi));
                v[i - 1] = v[i] - (float)(lenLeft * Math.sin(phi));
                h[i + 1] = h[i] + (float)(lenRight * Math.cos(phi));
                v[i + 1] = v[i] + (float)(lenRight * Math.sin(phi));
            }
            for (i = 0; i < numPoints - 1; i += 3) {
                this.drawSmoothLine(h[i], v[i], h[i + 1], v[i + 1], h[i + 2], v[i + 2], h[i + 3], v[i + 3]);
            }
        }
    }

    public void fillPolygon(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 0);
        if (type == 0 || type == 3) {
            if (type == 3) {
                ACoord clipped = this.clipper.clipPolygon(h, v, numPoints);
                h = clipped.hv[0][0];
                v = clipped.hv[1][0];
                numPoints = h.length;
            }
            int[] hInt = new int[numPoints];
            int[] vInt = new int[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                hInt[i] = (int)h[i];
                vInt[i] = (int)v[i];
            }
            this.updateColor();
            this.g.fillPolygon(hInt, vInt, numPoints);
            this.drawPolygon(h, v, numPoints);
        } else if (type == 2) {
            Rectangle bounds = this.g.getClipBounds();
            this.updateColor();
            this.g.fillRect((int)Math.rint(bounds.getX()), (int)Math.rint(bounds.getY()), (int)Math.rint(bounds.getWidth()), (int)Math.rint(bounds.getHeight()));
        }
    }
}

