/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics;

import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.graphics.APickingGraphics2D;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class AVectorGraphics
extends AGraphics {
    private GeneralPath path = new GeneralPath();

    AVectorGraphics(Graphics g) {
        super(g);
    }

    public void setLineWidth(int lineWidth) {
        this.setStroke(new BasicStroke(lineWidth));
    }

    public void drawLine(int h0, int v0, int h1, int v1) {
        this.drawLine((double)h0, (double)v0, (double)h1, (double)v1);
    }

    public void drawLine(double h0, double v0, double h1, double v1) {
        if (this.clipper.isLineWithin(h0, v0, h1, v1)) {
            double[][] hvClipped = this.clipper.getHV();
            double h0Clipped = hvClipped[0][0];
            double v0Clipped = hvClipped[1][0];
            double h1Clipped = hvClipped[0][1];
            double v1Clipped = hvClipped[1][1];
            this.path.reset();
            this.path.moveTo((float)h0Clipped, (float)v0Clipped);
            this.path.lineTo((float)h1Clipped, (float)v1Clipped);
            this.updateColor();
            this.g.draw(this.path);
        }
    }

    protected void fillRect(double h, double v, int width, int height) {
        this.path.reset();
        float h0 = (float)h;
        float v0 = (float)v;
        float dh = (float)((double)width / 2.0);
        float dv = (float)((double)height / 2.0);
        this.path.moveTo(h0 - dh, v0 - dv);
        this.path.lineTo(h0 + dh, v0 - dv);
        this.path.lineTo(h0 + dh, v0 + dv);
        this.path.lineTo(h0 - dh, v0 + dv);
        this.path.closePath();
        this.updateColor();
        this.g.fill(this.path);
    }

    public void drawPolygon(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 0);
        if (type == 0 || type == 3) {
            if (type == 3) {
                ACoord clipped = this.clipper.clipPolygon(h, v, numPoints);
                h = clipped.hv[0][0];
                v = clipped.hv[1][0];
                numPoints = h.length;
            }
            this.path.reset();
            for (int i = 0; i < numPoints; ++i) {
                if (i == 0) {
                    this.path.moveTo((float)h[i], (float)v[i]);
                    continue;
                }
                this.path.lineTo((float)h[i], (float)v[i]);
            }
            if (numPoints > 0) {
                this.path.closePath();
                this.updateColor();
                this.g.draw(this.path);
            }
        }
    }

    public void drawPolyline(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 1);
        if (type == 0 || type == 3) {
            int i;
            int start = 0;
            int end = numPoints - 1;
            if (type == 3) {
                for (i = 0; i < numPoints - 1; ++i) {
                    if (!this.clipper.isLineWithin(h[i], v[i], h[i + 1], v[i + 1])) continue;
                    start = i;
                    break;
                }
                for (i = numPoints - 1; i > start; --i) {
                    if (!this.clipper.isLineWithin(h[i], v[i], h[i - 1], v[i - 1])) continue;
                    end = i;
                    break;
                }
                for (i = start; i < end; ++i) {
                    if (this.clipper.isLineWithin(h[i], v[i], h[i + 1], v[i + 1])) continue;
                    start = 0;
                    end = numPoints - 1;
                    break;
                }
            }
            this.path.reset();
            for (i = start; i <= end; ++i) {
                if (i == start) {
                    this.path.moveTo((float)h[i], (float)v[i]);
                    continue;
                }
                this.path.lineTo((float)h[i], (float)v[i]);
            }
            if (end - start > 0) {
                this.updateColor();
                this.g.draw(this.path);
            }
        }
    }

    public void drawDottedPolyline(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 1);
        if (type == 0 || type == 3) {
            int start = 0;
            int end = numPoints - 1;
            if (type == 3) {
                int i;
                for (i = 0; i < numPoints - 1; ++i) {
                    if (!this.clipper.isLineWithin(h[i], v[i], h[i + 1], v[i + 1])) continue;
                    start = i;
                    break;
                }
                for (i = numPoints - 1; i > start; --i) {
                    if (!this.clipper.isLineWithin(h[i], v[i], h[i - 1], v[i - 1])) continue;
                    end = i;
                    break;
                }
                for (i = start; i < end; ++i) {
                    if (this.clipper.isLineWithin(h[i], v[i], h[i + 1], v[i + 1])) continue;
                    start = 0;
                    end = numPoints - 1;
                    break;
                }
            }
            this.path.reset();
            boolean drawFlag = false;
            for (int i = start; i <= end; ++i) {
                if (drawFlag) {
                    this.path.lineTo((float)h[i], (float)v[i]);
                } else {
                    this.path.moveTo((float)h[i], (float)v[i]);
                }
                drawFlag = !drawFlag;
            }
            if (end - start > 0) {
                this.updateColor();
                this.g.draw(this.path);
            }
        }
    }

    public void drawSmoothPolyline(double[] h0, double[] v0, int numPoints0) {
        if (numPoints0 < 3 || this.g instanceof APickingGraphics2D) {
            this.drawPolyline(h0, v0, numPoints0);
            return;
        }
        int type = this.getContainmentType(h0, v0, numPoints0, 1);
        if (type == 0 || type == 3) {
            int i;
            GeneralPath curve = new GeneralPath();
            int numPoints = 3 * numPoints0 - 2;
            float[] h = new float[numPoints];
            float[] v = new float[numPoints];
            block5: for (i = 0; i < numPoints; ++i) {
                switch (i % 3) {
                    case 0: {
                        h[i] = (float)h0[i / 3];
                        v[i] = (float)v0[i / 3];
                        continue block5;
                    }
                    case 1: {
                        h[i] = (float)(0.6666666666666666 * h0[i / 3] + 0.3333333333333333 * h0[i / 3 + 1]);
                        v[i] = (float)(0.6666666666666666 * v0[i / 3] + 0.3333333333333333 * v0[i / 3 + 1]);
                        continue block5;
                    }
                    case 2: {
                        h[i] = (float)(0.3333333333333333 * h0[i / 3] + 0.6666666666666666 * h0[i / 3 + 1]);
                        v[i] = (float)(0.3333333333333333 * v0[i / 3] + 0.6666666666666666 * v0[i / 3 + 1]);
                    }
                }
            }
            for (i = 3; i < numPoints - 2; i += 3) {
                double phiRight;
                double lenLeft = Math.sqrt(Math.pow(h[i] - h[i - 1], 2.0) + Math.pow(v[i] - v[i - 1], 2.0));
                double lenRight = Math.sqrt(Math.pow(h[i + 1] - h[i], 2.0) + Math.pow(v[i + 1] - v[i], 2.0));
                if (lenLeft < 1.0E-6 || lenRight < 1.0E-6) continue;
                double phiLeft = Math.atan2(v[i] - v[i - 1], h[i] - h[i - 1]);
                if (phiLeft - (phiRight = Math.atan2(v[i + 1] - v[i], h[i + 1] - h[i])) > Math.PI) {
                    phiRight += Math.PI * 2;
                } else if (phiRight - phiLeft > Math.PI) {
                    phiLeft += Math.PI * 2;
                }
                if (Math.abs(phiLeft - phiRight) > 1.5707963267948966) {
                    float f = h[i];
                    h[i + 1] = f;
                    h[i - 1] = f;
                    float f2 = v[i];
                    v[i + 1] = f2;
                    v[i - 1] = f2;
                    continue;
                }
                double phi = (lenRight * phiLeft + lenLeft * phiRight) / (lenLeft + lenRight);
                h[i - 1] = h[i] - (float)(lenLeft * Math.cos(phi));
                v[i - 1] = v[i] - (float)(lenLeft * Math.sin(phi));
                h[i + 1] = h[i] + (float)(lenRight * Math.cos(phi));
                v[i + 1] = v[i] + (float)(lenRight * Math.sin(phi));
            }
            curve.moveTo(h[0], v[0]);
            for (i = 3; i < numPoints; i += 3) {
                curve.curveTo(h[i - 2], v[i - 2], h[i - 1], v[i - 1], h[i], v[i]);
            }
            this.updateColor();
            this.g.draw(curve);
        }
    }

    public void fillPolygon(double[] h, double[] v, int numPoints) {
        int type = this.getContainmentType(h, v, numPoints, 0);
        if (type == 0 || type == 3) {
            if (type == 3) {
                ACoord clipped = this.clipper.clipPolygon(h, v, numPoints);
                h = clipped.hv[0][0];
                v = clipped.hv[1][0];
                numPoints = h.length;
            }
            this.path.reset();
            for (int i = 0; i < numPoints; ++i) {
                if (i == 0) {
                    this.path.moveTo((float)h[i], (float)v[i]);
                    continue;
                }
                this.path.lineTo((float)h[i], (float)v[i]);
            }
            if (numPoints > 0) {
                this.path.closePath();
                this.updateColor();
                this.g.fill(this.path);
                this.g.draw(this.path);
            }
        } else if (type == 2) {
            Rectangle bounds = this.g.getClipBounds();
            this.updateColor();
            this.g.fillRect((int)Math.rint(bounds.getX()), (int)Math.rint(bounds.getY()), (int)Math.rint(bounds.getWidth()), (int)Math.rint(bounds.getHeight()));
        }
    }
}

