/*
 * Decompiled with CFR 0.152.
 */
package atlantis.graphics.encoders;

import atlantis.canvas.ACanvas;
import atlantis.graphics.encoders.PngEncoder;
import atlantis.utils.ALogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public class AImageEncoder {
    private static final ALogger logger = ALogger.getLogger(AImageEncoder.class);

    public byte[] getPNGData(int imageWidth, int imageHeight) {
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        ACanvas.getCanvas().drawScaledCanvas(((Image)image).getGraphics(), imageWidth, imageHeight, "png");
        PngEncoder encoder = new PngEncoder(image, true, 0, 9);
        byte[] data = encoder.pngEncode();
        return data;
    }

    public byte[] getScaledPNGData(int width, int height, double scale) {
        BufferedImage inputImage = new BufferedImage(width, height, 2);
        ACanvas.getCanvas().drawScaledCanvas(((Image)inputImage).getGraphics(), width, height, "png");
        int targetHeight = (int)(scale * (double)height);
        int targetWidth = (int)(scale * (double)width);
        while (((Image)inputImage).getWidth(null) != targetWidth) {
            if ((double)(((Image)inputImage).getWidth(null) / targetWidth) > 2.0) {
                width = (int)((double)((Image)inputImage).getWidth(null) / 2.0);
                height = (int)((double)((Image)inputImage).getHeight(null) / 2.0);
            } else {
                width = targetWidth;
                height = targetHeight;
            }
            logger.debug("Rescaling image from " + ((Image)inputImage).getWidth(null) + "x" + ((Image)inputImage).getHeight(null) + " to " + width + "x" + height);
            BufferedImage scaledImage = new BufferedImage(width, height, 2);
            Graphics2D scaledGraphics = scaledImage.createGraphics();
            scaledGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            scaledGraphics.drawImage(inputImage, 0, 0, width, height, null);
            scaledGraphics.dispose();
            inputImage = scaledImage;
        }
        PngEncoder encoder = new PngEncoder(inputImage, true, 0, 9);
        byte[] data = encoder.pngEncode();
        return data;
    }

    public void saveEPS(int imageWidth, int imageHeight, File saveFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(saveFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        EpsGraphics2D g = new EpsGraphics2D("Atlantis", (OutputStream)bos, 0, 0, imageWidth, imageHeight);
        g.setAccurateTextMode(true);
        ACanvas.getCanvas().drawScaledCanvas((Graphics)g, imageWidth, imageHeight, "eps");
        g.flush();
        g.close();
        fos.close();
        bos.close();
    }
}

