/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.graphics.encoders.AImageEncoder;
import atlantis.gui.ASaveCanvasDialog;
import atlantis.gui.AnimatedEvent;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.interactions.AZMRInteraction;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class AAnimationControl {
    private static ALogger logger = ALogger.getLogger(AAnimationControl.class);
    private static ASaveCanvasDialog saver = null;
    private static Hashtable saveDataTypesState = null;
    private static byte[] noDataArray = null;
    private static byte[] hitsOnlyArray = null;
    private static byte[] tracksOnlyArray = null;
    private static byte[] recoArray = null;
    private static String[] otherTypes = new String[]{"SVx", "RVx", "Cluster", "EmTauROI", "JetROI", "MuonROI", "Jet", "BJet", "ETMis"};
    private static String[] trackTypes = new String[]{"STr", "InDetSegment", "MuonSegment", "InDetTrack", "MuonTrack", "SNP", "SMTr", "Electron", "Muon", "Photon", "TauJet", "CompositeParticle"};
    private static String[] hitTypes = new String[]{"S3D", "PixelCluster", "PixelRDO", "TrigS3D", "SiCluster", "SiClusterRDO", "TRT", "LAr", "TILE", "HEC", "FCAL", "MDT", "CSC", "RPC", "TGC"};

    public static String saveImage(String picPrefix, byte[] data) throws Exception {
        try {
            String name = Atlantis.getHomeDirectory() + picPrefix + saver.getDefaultFileName() + ".png";
            File file = new File(name);
            String absPath = file.getAbsolutePath();
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(absPath));
            ((OutputStream)stream).write(data);
            ((OutputStream)stream).close();
            return name;
        }
        catch (Exception e) {
            throw new Exception("Saving canvas failed.\n" + e.getMessage());
        }
    }

    private static void setDataType(String parName, boolean state, boolean save) {
        AParameter p = APar.get("Data", parName);
        if (save) {
            saveDataTypesState.put(parName, new Boolean(p.getStatus()));
        }
        p.setStatus(state);
    }

    private static void setAllDataTypes(boolean state, boolean save) {
        int i;
        for (i = 0; i < otherTypes.length; ++i) {
            AAnimationControl.setDataType(otherTypes[i], state, save);
        }
        for (i = 0; i < trackTypes.length; ++i) {
            AAnimationControl.setDataType(trackTypes[i], state, save);
        }
        for (i = 0; i < hitTypes.length; ++i) {
            AAnimationControl.setDataType(hitTypes[i], state, save);
        }
    }

    private static void resumeDataType(String parName) {
        AParameter p = APar.get("Data", parName);
        Boolean state = (Boolean)saveDataTypesState.get(parName);
        p.setStatus(state);
    }

    private static void resumeDataTypesState() {
        int i;
        for (i = 0; i < otherTypes.length; ++i) {
            AAnimationControl.resumeDataType(otherTypes[i]);
        }
        for (i = 0; i < trackTypes.length; ++i) {
            AAnimationControl.resumeDataType(trackTypes[i]);
        }
        for (i = 0; i < hitTypes.length; ++i) {
            AAnimationControl.resumeDataType(hitTypes[i]);
        }
    }

    protected static void clenupActions() {
        saver = null;
        AAnimationControl.resumeDataTypesState();
        AZMRInteraction.setPaintCenterDot(true);
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public AAnimationControl() {
        AParameter p;
        int i;
        AZMRInteraction.setPaintCenterDot(false);
        ACanvas.getCanvas().setCurrentWindow("W");
        AProjection proj = AProjectionsManager.getProjection("YX");
        ACanvas.getCanvas().getCurrentWindow().setProjection(proj);
        APar.get("YX", "FishEye").setD(6.0);
        saveDataTypesState = new Hashtable();
        AImageEncoder imageEncoder = new AImageEncoder();
        int width = ACanvas.getCanvas().getRootPane().getWidth();
        int height = ACanvas.getCanvas().getRootPane().getHeight();
        AAnimationControl.setAllDataTypes(false, true);
        ACanvas.getCanvas().repaintAllFromScratch();
        try {
            noDataArray = imageEncoder.getPNGData(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), ex.getMessage(), "Error saving canvas", 0);
            AAnimationControl.clenupActions();
            return;
        }
        APar.get("CutsInDet", "HitsByRTr").setI(1);
        for (i = 0; i < hitTypes.length; ++i) {
            p = APar.get("Data", hitTypes[i]);
            p.setStatus(true);
        }
        ACanvas.getCanvas().repaintAllFromScratch();
        try {
            hitsOnlyArray = imageEncoder.getPNGData(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), ex.getMessage(), "Error saving canvas", 0);
            AAnimationControl.clenupActions();
            return;
        }
        APar.get("InDetTrack", "LineWidth").setI(4);
        APar.get("MuonTrack", "LineWidth").setI(4);
        APar.get("InDetTrack", "DrawnAs").setI(1);
        APar.get("Data", "InDetTrack").setStatus(true);
        APar.get("Data", "MuonTrack").setStatus(true);
        for (i = 0; i < hitTypes.length; ++i) {
            p = APar.get("Data", hitTypes[i]);
            p.setStatus(false);
        }
        ACanvas.getCanvas().repaintAllFromScratch();
        try {
            tracksOnlyArray = imageEncoder.getPNGData(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), ex.getMessage(), "Error saving canvas", 0);
            AAnimationControl.clenupActions();
            return;
        }
        AAnimationControl.setAllDataTypes(true, false);
        APar.get("Data", "RVx").setStatus(false);
        APar.get("Data", "SVx").setStatus(false);
        APar.get("Data", "SNP").setStatus(false);
        APar.get("Data", "STr").setStatus(false);
        APar.get("Data", "ETMis").setStatus(false);
        APar.get("Data", "SMTr").setStatus(false);
        APar.get("LAr", "Histogram").setStatus(true);
        APar.get("TILE", "Histogram").setStatus(true);
        ACanvas.getCanvas().repaintAllFromScratch();
        try {
            recoArray = imageEncoder.getPNGData(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), ex.getMessage(), "Error saving canvas", 0);
            AAnimationControl.clenupActions();
            return;
        }
        AnimatedEvent.showAnimation(width, height, noDataArray, hitsOnlyArray, tracksOnlyArray, recoArray);
        AAnimationControl.clenupActions();
    }
}

