/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ACheckBox;
import atlantis.parameters.ACommandProcessor;
import atlantis.parameters.AParameter;
import atlantis.parameters.AStatusParameter;
import hep.wired.util.DefaultTristateTreeNode;
import hep.wired.util.TristateCheckBox;
import java.util.Iterator;

public class ACheckNode
extends DefaultTristateTreeNode {
    public static final byte SINGLE_SELECTION = 0;
    public static final byte MULTI_SELECTION = 1;
    private byte selectionMode;
    private AParameter parameter;

    public ACheckNode(Object userObject, boolean selectionValue, byte selectionMode, AParameter parameter) {
        super(userObject, selectionValue, true);
        this.setSelectionMode(selectionMode);
        this.parameter = parameter;
    }

    public void setSelectionMode(byte selectionMode) {
        this.selectionMode = selectionMode;
    }

    public byte getSelectionMode() {
        return this.selectionMode;
    }

    public AParameter getParameter() {
        return this.parameter;
    }

    public void updateState() {
        if (this.children != null) {
            int checkedNumber = 0;
            for (ACheckNode aChildNode : this.children) {
                aChildNode.updateState();
                if (!aChildNode.isSelected()) continue;
                ++checkedNumber;
            }
            if (checkedNumber == 0) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
        } else {
            ACheckBox cellComponent = (ACheckBox)this.getUserObject();
            cellComponent.setSelected(this.getParameter().getStatus());
            this.setSelected(cellComponent.isSelected());
        }
    }

    public void getClicked(boolean selectionFlag, boolean statusChange) {
        this.setSelected(selectionFlag);
        if (this.parameter instanceof AStatusParameter && statusChange) {
            AStatusParameter theStatusParameter = (AStatusParameter)this.parameter;
            ACommandProcessor.receive(theStatusParameter.getName());
            theStatusParameter.apply();
        } else if (this.selectionMode == 1 && this.children != null) {
            ((TristateCheckBox)this.getUserObject()).setSelected(selectionFlag);
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ACheckNode aChildNode;
                aChildNode.getClicked(selectionFlag, (aChildNode = (ACheckNode)((Object)it.next())).isSelected() != selectionFlag);
            }
        }
        if (this.parent != null) {
            ((ACheckNode)((Object)this.parent)).updateState();
        }
    }
}

