/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.AColorMap;
import atlantis.gui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class AColorComboBoxRenderer
extends JLabel
implements ListCellRenderer {
    private ColorIcon icon = new ColorIcon();
    private Border selectedBorder;
    private Border deselectedBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int colorIndex = (Integer)value;
        Color[] colorMap = AColorMap.getColors();
        Color color = colorMap[colorIndex];
        this.icon.setColor(color);
        this.setIcon(this.icon);
        this.setText("" + (Integer)value);
        if (isSelected) {
            this.selectedBorder = BorderFactory.createLineBorder(list.getSelectionBackground(), 2);
            this.setBorder(this.selectedBorder);
            ToolTipManager.sharedInstance().setInitialDelay(1);
            ToolTipManager.sharedInstance().setReshowDelay(1);
            String message = color.equals(Color.black) ? "Black: " : (color.equals(Color.blue) ? "Blue: " : (color.equals(Color.cyan) ? "Cyan: " : (color.equals(Color.darkGray) ? "DarkGray: " : (color.equals(Color.gray) ? "Gray: " : (color.equals(Color.green) ? "Green: " : (color.equals(Color.lightGray) ? "LightGray: " : (color.equals(Color.magenta) ? "Magenta: " : (color.equals(Color.orange) ? "Orange: " : (color.equals(Color.pink) ? "Pink: " : (color.equals(Color.red) ? "Red: " : (color.equals(Color.white) ? "White: " : (color.equals(Color.yellow) ? "Yellow: " : ""))))))))))));
            list.setToolTipText(message + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        } else {
            this.setBorder(this.deselectedBorder);
        }
        return this;
    }
}

