/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.event.AEvent;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class AColorHelpDialog
extends JFrame
implements WindowListener {
    private static JTextField[] textField;
    public static Color[] colorMap;
    private static AColorHelpDialog instance;

    public static AColorHelpDialog getInstance() {
        if (Atlantis.isAtlantisHeadless()) {
            return null;
        }
        if (instance == null) {
            instance = new AColorHelpDialog();
        }
        return instance;
    }

    public void update() {
        if (!this.isVisible()) {
            return;
        }
        this.getContentPane().removeAll();
        this.validate();
        String[] dataObjectsToDisplay = new String[]{"RVx", "TRT", "SiCluster", "SiClusterRDO", "S3D", "PixelCluster", "PixelRDO", "TrigS3D", "MDT", "CSC", "RPC", "TGC", "EmTauROI", "JetROI", "MuonROI", "LVL1TriggerTower", "LVL1JetElement", "STr", "SNP", "SMTr", "SVx"};
        String[] dataObjectsWithCollectionsToDisplay = new String[]{"InDetTrack", "InDetSegment", "Cluster", "MuonTrack", "MuonSegment", "Jet", "ETMis", "BJet", "Electron", "Muon", "Photon", "TauJet", "CompositeParticle"};
        String[] geometryObjectsToDisplay = new String[]{"PIXFill", "SILFill", "TRTFill", "SolFill", "ECALFill", "HCALFill", "RPCFill", "TGCFill", "MDTFill", "CSCFill", "BkgFill"};
        int numObjects = Math.max(dataObjectsWithCollectionsToDisplay.length, dataObjectsToDisplay.length);
        int numOfColumns = 4;
        this.getContentPane().setLayout(new GridLayout(numObjects + 1, numOfColumns));
        textField = new JTextField[(numObjects + 1) * 4];
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        this.fillTextField(0, Color.white, Color.black, "       Geometry color");
        this.fillTextField(1, Color.white, Color.black, "       Color of objects without collections");
        this.fillTextField(2, Color.white, Color.black, "       Color of objects with collections");
        this.fillTextField(3, Color.white, Color.black, "       Object Collection");
        for (int j = 0; j < numObjects; ++j) {
            String text;
            int i = 4 * j + 4;
            if (j < geometryObjectsToDisplay.length) {
                Color backgroundColor = colorMap[APar.get("Det", geometryObjectsToDisplay[j]).getI()];
                text = APar.get("Det", geometryObjectsToDisplay[j]).getScreenName();
                this.fillTextField(i, backgroundColor, text);
            } else {
                this.fillTextField(i);
            }
            ++i;
            if (j < dataObjectsToDisplay.length) {
                this.fillTextField(i, dataObjectsToDisplay[j]);
            } else {
                this.fillTextField(i);
            }
            ++i;
            if (j < dataObjectsWithCollectionsToDisplay.length) {
                this.fillTextField(i, dataObjectsWithCollectionsToDisplay[j]);
            } else {
                this.fillTextField(i);
            }
            ++i;
            if (j < dataObjectsWithCollectionsToDisplay.length) {
                String[] collections = event.getActiveCollectionNames(dataObjectsWithCollectionsToDisplay[j]);
                text = !APar.get("Data", dataObjectsWithCollectionsToDisplay[j]).getStatus() || collections == null || collections.length == 0 ? "n/a" : (collections.length > 1 ? ">1 selected" : collections[0].substring(dataObjectsWithCollectionsToDisplay[j].length()));
                this.fillTextField(i, Color.white, Color.black, text);
                continue;
            }
            this.fillTextField(i);
        }
        this.invalidate();
        this.pack();
    }

    private void fillTextField(int index, Color background, Color foreground, String text) {
        if (textField[index] == null) {
            AColorHelpDialog.textField[index] = new JTextField();
        }
        textField[index].setEditable(false);
        textField[index].setBackground(background);
        if (foreground != null) {
            textField[index].setForeground(foreground);
        }
        if (text != null) {
            textField[index].setText(text);
        }
        this.getContentPane().add(textField[index]);
    }

    private void fillTextField(int index) {
        this.fillTextField(index, new Color(184, 207, 229), null, null);
    }

    private void fillTextField(int index, Color background, String text) {
        if (background.getBlue() == background.getRed() && background.getBlue() == background.getGreen() && background.getBlue() <= 128) {
            this.fillTextField(index, background, Color.white, text);
        } else {
            this.fillTextField(index, background, Color.black, text);
        }
    }

    private void fillTextField(int index, String object) {
        if (APar.get(object, "ColorFunction") == null || APar.get(object, "ColorFunction").getI() == 0) {
            Color backgroundColor = colorMap[APar.get(object, "Constant").getI()];
            String text = object;
            if (!APar.get("Data", object).getStatus()) {
                text = text + " - data type not active";
            }
            this.fillTextField(index, backgroundColor, text);
        } else {
            String text = object;
            text = APar.get("Data", object).getStatus() ? text + " is not being colored constant" : text + " - data type not active";
            this.fillTextField(index, Color.white, Color.black, text);
        }
    }

    private AColorHelpDialog() {
        this.setTitle("Current window Geometry and Object colors and Object Collection");
        AUtilities.setIconImage(this);
        this.setDefaultCloseOperation(2);
        this.update();
        this.setResizable(false);
        this.addWindowListener(this);
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int screenHeight = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        this.setLocation((int)Math.max(0.0, 0.1 * (double)screenWidth), (int)Math.max(0.0, 0.1 * (double)screenHeight));
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void windowOpened(WindowEvent e) {
        this.update();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        colorMap = AColorMap.getColors();
        instance = null;
    }
}

