/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.graphics.colormap.MappedColor;
import atlantis.gui.AExceptionHandler;
import atlantis.parameters.APar;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AXMLErrorHandler;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AColorMap {
    private static ALogger logger = ALogger.getLogger(AColorMap.class);
    private static final boolean VALIDATION = true;
    public static final int NO_COLOR = -1;
    public static final int INVISIBLE = -2;
    public static final int BG = 8;
    public static final int WH = 0;
    public static final int GY = 14;
    public static final int RD = 20;
    public static final int GN = 21;
    public static final int BL = 22;
    public static final int YE = 23;
    public static final int MA = 24;
    public static final int CY = 25;
    public static final int BK = 26;
    public static final int OR = 27;
    public static final int CB = 28;
    private static final String[] mapNames = new String[]{"Default(1)", "Default(2)", "M4+M5", "GrayDet", "Original", "Gray", "B/W", "HitCol", "GrayHitCol"};
    private static final String[] mapNamesPS = new String[]{"default1", "default2", "m4m5", "graydet", "original", "gray", "bw", "hitcol", "grayhitcol"};
    protected static MappedColor[][] maps;
    private static int numColors;
    private static int numMaps;
    public static final int COLOR_MAP_DEFAULT1 = 0;
    public static final int COLOR_MAP_DEFAULT2 = 1;
    public static final int COLOR_MAP_M4M5 = 2;
    public static final int COLOR_MAP_GRAYDET = 3;
    public static final int COLOR_MAP_ORIGINAL = 4;
    public static final int COLOR_MAP_GRAY = 5;
    public static final int COLOR_MAP_BW = 6;
    public static final int COLOR_MAP_HITCOL = 7;
    public static final int COLOR_MAP_GRAY_HITCOL = 8;
    static int currentMap;

    public static void readColorMap(String name) {
        String fileName = null;
        if (name != null && new File(name).canRead()) {
            fileName = name;
        } else {
            if (name != null) {
                logger.warn("Can't read color map file: " + name);
            }
            fileName = ".Atlantis-colormap.xml";
            String fileNameFull = Atlantis.USER_HOME_DIR + Atlantis.FILE_SEPAR + fileName;
            fileName = new File(fileNameFull).canRead() ? fileNameFull : Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "colormap.xml";
        }
        logger.info("Using color map file: " + fileName);
        try {
            InputStream isColorMap = AUtilities.getFileAsStream(fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new AXMLErrorHandler());
            Element colormap = parser.parse(isColorMap).getDocumentElement();
            NamedNodeMap cm = colormap.getAttributes();
            numMaps = Integer.parseInt(cm.getNamedItem("numMaps").getNodeValue().trim());
            numColors = Integer.parseInt(cm.getNamedItem("numColors").getNodeValue().trim());
            maps = new MappedColor[numMaps][numColors];
            NodeList list = colormap.getChildNodes();
            int count = list.getLength();
            for (int i = 0; i < count; ++i) {
                Node mapping = list.item(i);
                if (mapping.getNodeType() != 1) continue;
                NamedNodeMap atts = mapping.getAttributes();
                try {
                    int map = Integer.parseInt(atts.getNamedItem("map").getNodeValue().trim());
                    int index = Integer.parseInt(atts.getNamedItem("index").getNodeValue().trim());
                    int r = Integer.parseInt(atts.getNamedItem("r").getNodeValue().trim());
                    int g = Integer.parseInt(atts.getNamedItem("g").getNodeValue().trim());
                    int b = Integer.parseInt(atts.getNamedItem("b").getNodeValue().trim());
                    if (map >= maps.length || index >= maps[map].length) continue;
                    AColorMap.maps[map][index] = new MappedColor(r, g, b, index);
                    continue;
                }
                catch (NumberFormatException e) {
                    AExceptionHandler.processException("Colour map error:\n" + mapping, e);
                }
            }
        }
        catch (Exception e) {
            AExceptionHandler.processException("Error while reading colour map:\n" + fileName, e);
        }
        for (int i = 0; i < maps.length; ++i) {
            for (int j = 0; j < maps[i].length; ++j) {
                if (maps[i][j] != null) continue;
                AOutput.append("\nColorMap (" + i + "," + j + ") is not present", "BAD_COMMAND");
            }
        }
    }

    public static int getNumMaps() {
        return numMaps;
    }

    public static int getNumColors() {
        return numColors;
    }

    public static String getColorMapXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>\n<!DOCTYPE colormap  [\n <!ELEMENT colormap (Mapping*)> <!ATTLIST colormap\n   numMaps   CDATA #REQUIRED\n   numColors CDATA #REQUIRED>\n <!ELEMENT Mapping EMPTY>\n <!ATTLIST Mapping\n   map   CDATA #REQUIRED\n   index CDATA #REQUIRED\n   r     CDATA #REQUIRED\n   g     CDATA #REQUIRED\n   b     CDATA #REQUIRED>\n]>\n\n\n");
        buffer.append("<colormap numMaps=\"" + maps.length + "\" numColors=\"" + maps[0].length + "\" >\n");
        for (int i = 0; i < maps.length; ++i) {
            for (int j = 0; j < maps[i].length; ++j) {
                int r = maps[i][j].getRed();
                int g = maps[i][j].getGreen();
                int b = maps[i][j].getBlue();
                buffer.append("  <Mapping  map=\"" + i + "\" index=\"" + j + "\"  r=\"" + r + "\" g=\"" + g + "\" b=\"" + b + "\"/>\n");
            }
        }
        buffer.append("</colormap>\n");
        return buffer.toString();
    }

    public static String getPSPrologColorMap() {
        StringBuffer s = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        s.append(newLine);
        for (int i = 0; i < maps.length; ++i) {
            s.append("/" + mapNamesPS[i] + "ColorMap" + newLine);
            s.append("<<" + newLine);
            for (int j = 0; j < maps[i].length; ++j) {
                s.append(" /C" + j + " [" + AMath.d2s((double)maps[i][j].getRed() / 255.0, 3) + " " + AMath.d2s((double)maps[i][j].getGreen() / 255.0, 3) + " " + AMath.d2s((double)maps[i][j].getBlue() / 255.0, 3) + "]" + newLine);
            }
            s.append(">> def" + newLine);
            s.append(newLine);
        }
        return s.toString();
    }

    public static Color[] getColors(int map) {
        Color[] col = new Color[maps[map].length];
        for (int i = 0; i < col.length; ++i) {
            col[i] = maps[map][i];
        }
        return col;
    }

    public static Color[] getShades(int num) {
        assert (num >= 2);
        Color[] col = new Color[num];
        col[0] = new Color(170, 170, 170);
        for (int i = 1; i < num - 1; ++i) {
            col[i] = new Color(255 * i / num, 80, 255 - 255 * i / num);
        }
        return col;
    }

    public static Color[] getColors() {
        return AColorMap.getColors(currentMap);
    }

    public static void setColorMap(int map) {
        if (map >= 0 && map < maps.length) {
            currentMap = map;
            APar.get("Prefs", "ColorMap").setI(map);
        }
    }

    public static void setColorMap(String mapName) {
        for (int i = 0; i < mapNames.length; ++i) {
            if (!mapNames[i].equals(mapName)) continue;
            AColorMap.setColorMap(i);
        }
    }

    public static int getColorMap() {
        return currentMap;
    }

    public static boolean drawFrames() {
        return currentMap == 5 || currentMap == 6;
    }

    public static String getPSColorMapName() {
        return mapNamesPS[AColorMap.getColorMap()];
    }

    public MappedColor getMappedColor(int colorIndex) {
        if (colorIndex < 0 && colorIndex >= maps[currentMap].length) {
            return null;
        }
        return maps[currentMap][colorIndex];
    }

    public Color getColor(int colorIndex) {
        if (colorIndex < 0 && colorIndex >= maps[currentMap].length) {
            return null;
        }
        return maps[currentMap][colorIndex];
    }

    public static String getTag(int colorIndex) {
        if (colorIndex < 0 && colorIndex >= maps[0].length) {
            return null;
        }
        return "C" + colorIndex;
    }

    public static String[] getMapNames() {
        return (String[])mapNames.clone();
    }

    static {
        currentMap = 0;
    }
}

