/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.gui.AColorMap;
import atlantis.hypatia.HTrackMomentaWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AColorMapDialog
extends JDialog
implements ActionListener {
    private JPanel choosePanel;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton selected;

    public AColorMapDialog() {
        super(HTrackMomentaWindow.getGUI(), "Select Map Dialog", true);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.choosePanel = new JPanel();
        this.choosePanel.setBorder(BorderFactory.createTitledBorder(" Select Color Map "));
        ButtonGroup group = new ButtonGroup();
        this.choosePanel.setLayout(new GridLayout(5, 1));
        for (int i = 0; i < AColorMap.getMapNames().length - 2; ++i) {
            JRadioButton r = new JRadioButton(AColorMap.getMapNames()[i]);
            r.addActionListener(this);
            if (AColorMap.getColorMap() == i) {
                this.selected = r;
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            group.add(r);
            this.choosePanel.add(r);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.choosePanel, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AColorMap.setColorMap(AColorMapDialog.this.selected.getText());
                ACanvas.getCanvas().repaintAllFromScratch();
                AColorMapDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AColorMapDialog.this.dispose();
            }
        });
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.selected = (JRadioButton)e.getSource();
    }
}

