/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.graphics.colormap.MappedColor;
import atlantis.gui.AColorMap;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.gui.AFlowLayout;
import atlantis.gui.AGUI;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AColorMapEditor
extends JDialog
implements ADragListener {
    private static AColorMapEditor instance;
    private JColorChooser colorChooser;
    private ADnDLabel[][] labels = new ADnDLabel[AColorMap.getNumMaps()][AColorMap.getNumColors()];
    private int colorMap;
    private int index;
    private MappedColor previousColor;
    private ADnDLabel source;
    private JPanel colorPanel;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;

    private AColorMapEditor() {
        super(HTrackMomentaWindow.getGUI(), "Color Map Editor", false);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.colorChooser = new JColorChooser();
        this.colorPanel = new JPanel();
        this.colorPanel.setLayout(new GridLayout(AColorMap.getNumColors() + 1, AColorMap.getNumMaps() + 1, 0, 0));
        JLabel padding = new JLabel("");
        this.colorPanel.add(padding);
        for (int i = 0; i < AColorMap.getNumMaps(); ++i) {
            JLabel label = new JLabel("  " + AColorMap.getMapNames()[i] + "  ", 0);
            label.setFont(new Font("Dialog", 1, 14));
            this.colorPanel.add(label);
        }
        LabelMouseListener labelMouseListener = new LabelMouseListener();
        for (int j = 0; j < AColorMap.getNumColors(); ++j) {
            JLabel label = new JLabel("" + j, 0);
            label.setFont(new Font("Dialog", 1, 14));
            this.colorPanel.add(label);
            for (int i = 0; i < AColorMap.getNumMaps(); ++i) {
                Color[] col = AColorMap.getColors(i);
                this.labels[i][j] = new ADnDLabel("text", false);
                this.labels[i][j].addDragListener(this);
                this.labels[i][j].setOpaque(true);
                this.labels[i][j].setBackground(col[j]);
                this.labels[i][j].setForeground(col[j]);
                this.labels[i][j].setToolTipText(col[j].getRed() + ", " + col[j].getGreen() + ", " + col[j].getBlue());
                this.setLineBorder(this.labels[i][j]);
                this.labels[i][j].addMouseListener(labelMouseListener);
                this.colorPanel.add(this.labels[i][j]);
            }
        }
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new AFlowLayout(10, 10));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AColorMapEditor.this.applyColors();
                AColorMapEditor.this.dispose();
                instance = null;
            }
        });
        this.buttonsPanel.add(this.okButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AColorMapEditor.this.applyColors();
            }
        });
        this.buttonsPanel.add(this.applyButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AColorMapEditor.this.dispose();
                instance = null;
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.colorPanel, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        this.setVisible(true);
    }

    public static AColorMapEditor getInstance() {
        if (instance == null) {
            instance = new AColorMapEditor();
        }
        return instance;
    }

    public void updateColors() {
        if (instance != null) {
            for (int i = 0; i < AColorMap.maps.length; ++i) {
                for (int j = 0; j < AColorMap.maps[i].length; ++j) {
                    MappedColor c = AColorMap.maps[i][j];
                    this.labels[i][j].setBackground(c);
                    this.labels[i][j].setForeground(c);
                    this.labels[i][j].setToolTipText(c.getRed() + ", " + c.getGreen() + ", " + c.getBlue());
                }
            }
            this.repaint();
        }
    }

    public void dragPerformed(Object from, Object to, int action) {
        ADnDLabel fromLabel = (ADnDLabel)from;
        ADnDLabel toLabel = (ADnDLabel)to;
        toLabel.setBackground(fromLabel.getBackground());
    }

    private void setLineBorder(JComponent comp) {
        comp.setBorder(BorderFactory.createLineBorder(new Color(207, 207, 207), 3));
    }

    private void getPosition() {
        block0: for (int i = 0; i < AColorMap.getNumMaps(); ++i) {
            for (int j = 0; j < AColorMap.getNumColors(); ++j) {
                if (this.labels[i][j] != this.source) continue;
                this.colorMap = i;
                this.index = j;
                continue block0;
            }
        }
    }

    private void applyColors() {
        for (int i = 0; i < AColorMap.maps.length; ++i) {
            for (int j = 0; j < AColorMap.maps[i].length; ++j) {
                Color c = this.labels[i][j].getBackground();
                AColorMap.maps[i][j] = new MappedColor(c.getRed(), c.getGreen(), c.getBlue(), j);
            }
        }
        AGUI.repaintTable();
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    class LabelMouseListener
    extends MouseAdapter {
        LabelMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                AColorMapEditor.this.source = (ADnDLabel)e.getSource();
                AColorMapEditor.this.colorChooser;
                Color color = JColorChooser.showDialog(instance, "Color Map Editor - Chooser", AColorMapEditor.this.source.getBackground());
                if (color != null) {
                    AColorMapEditor.this.source.setBackground(color);
                    AColorMapEditor.this.source.setForeground(color);
                    AColorMapEditor.this.setLineBorder(AColorMapEditor.this.source);
                    AColorMapEditor.this.source.setToolTipText(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            AColorMapEditor.this.source = (ADnDLabel)e.getSource();
            AColorMapEditor.this.getPosition();
            if (AUtilities.isRightMouseButton(e)) {
                if (AColorMapEditor.this.index < 8) {
                    for (int j = 8; j < AColorMap.getNumColors(); ++j) {
                        AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].setBackground(AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][AColorMapEditor.this.index].getBackground());
                    }
                } else {
                    for (int j = 0; j < 8; ++j) {
                        AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].setForeground(AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][AColorMapEditor.this.index].getForeground());
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                AColorMapEditor.this.previousColor = AColorMap.maps[AColorMapEditor.this.colorMap][AColorMapEditor.this.index];
                MappedColor c = AColorMap.maps[AColorMapEditor.this.colorMap][AColorMapEditor.this.index];
                AColorMap.maps[((AColorMapEditor)AColorMapEditor.this).colorMap][((AColorMapEditor)AColorMapEditor.this).index] = c.getGreen() > 128 ? AColorMap.maps[AColorMapEditor.this.colorMap][26] : AColorMap.maps[AColorMapEditor.this.colorMap][0];
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (AUtilities.isRightMouseButton(e)) {
                if (AColorMapEditor.this.index < 8) {
                    for (int j = 8; j < AColorMap.getNumColors(); ++j) {
                        AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].setBackground(AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].getForeground());
                    }
                } else {
                    for (int j = 0; j < 8; ++j) {
                        AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].setForeground(AColorMapEditor.this.labels[AColorMapEditor.this.colorMap][j].getBackground());
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                AColorMap.maps[((AColorMapEditor)AColorMapEditor.this).colorMap][((AColorMapEditor)AColorMapEditor.this).index] = AColorMapEditor.this.previousColor;
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        }
    }
}

