/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.parameters.AParametersGroup;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class AConfigWriter {
    private static ALogger logger = ALogger.getLogger(AConfigWriter.class);

    private AConfigWriter() {
    }

    public static String getConfiguration(String sourceFile) {
        logger.trace("Trying to read the distribution configuration ...");
        String config = null;
        StringBuffer output = new StringBuffer("");
        config = AConfigWriter.readConfiguration(sourceFile);
        if (config != null) {
            logger.debug("Loading source configuration successful.");
            output.append(config);
            output.append(AConfigWriter.getParametersDifferences());
            output.append(AConfigWriter.getWindowCorners());
            output.append("\n</AtlantisConfiguration>\n");
            return output.toString();
        }
        logger.error("Loading source configuration failed.");
        return null;
    }

    private static String getParametersDifferences() {
        StringBuffer output = new StringBuffer("");
        output.append("\n\n");
        output.append("\t<ParameterDifferences>\n");
        AParametersGroup[][] group = APar.getUIGroups();
        for (int i = 0; i < group.length; ++i) {
            for (int j = 0; j < group[i].length; ++j) {
                Vector v = group[i][j].getParameters(999);
                for (int k = 0; k < v.size(); ++k) {
                    output.append(((AParameter)v.elementAt(k)).getDifferences(group[i][j].getGroupName()));
                }
            }
        }
        output.append("\t</ParameterDifferences>\n\n");
        return output.toString();
    }

    private static String getWindowCorners() {
        StringBuffer output = new StringBuffer("");
        output.append("\n\n");
        output.append("\t<WindowCorners>\n");
        String[] windowNames = ACanvas.getCanvas().getKnownWindowNames();
        for (int i = 0; i < windowNames.length; ++i) {
            Point2D.Double[] corners = ACanvas.getCanvas().getWindow(windowNames[i]).getUserCorners();
            if (corners == null) continue;
            output.append("\t\t<CORNERS windowName=\"" + windowNames[i] + "\"");
            for (int j = 0; j < corners.length; ++j) {
                output.append(" x" + j + "=\"" + corners[j].getX() + "\"");
                output.append(" y" + j + "=\"" + corners[j].getY() + "\"");
            }
            output.append("/>\n");
        }
        output.append("\t</WindowCorners>\n\n\n");
        return output.toString();
    }

    private static String readLogicLine(BufferedReader reader) throws IOException {
        String startLine = reader.readLine();
        if (startLine == null) {
            return null;
        }
        StringBuffer logicLine = new StringBuffer(startLine);
        while (logicLine.indexOf("<") >= 0 && logicLine.indexOf(">") < 0) {
            logicLine.append("\n");
            logicLine.append(reader.readLine());
        }
        return logicLine.toString();
    }

    private static String readConfiguration(String fileName) {
        String groupName = "";
        String parameterName = "";
        AParameter aParam = null;
        BufferedReader curr = null;
        StringBuffer buffer = new StringBuffer("");
        StringBuffer output = new StringBuffer("");
        boolean inComment = false;
        try {
            String str;
            logger.debug("Trying to open configuration file: " + fileName);
            InputStream fis = AUtilities.getFileAsStream(fileName);
            InputStreamReader isr = new InputStreamReader(fis);
            curr = new BufferedReader(isr, 10000);
            while ((str = AConfigWriter.readLogicLine(curr)) != null) {
                buffer = new StringBuffer(str);
                if (buffer.indexOf("<!--") >= 0) {
                    inComment = true;
                }
                if (buffer.indexOf("-->") >= 0) {
                    inComment = false;
                }
                if (!inComment) {
                    AWindow w;
                    String name;
                    if (buffer.indexOf("</Parameters>") >= 0) {
                        output.append(buffer);
                        output.append("\n");
                        break;
                    }
                    if (buffer.indexOf("<Canvas") >= 0) {
                        buffer = AConfigWriter.replace(buffer, "startupLayout", ACanvas.getCanvas().getCurrentLayout().getName());
                        String ar = Double.toString(ACanvas.getCanvas().getAspectRatio());
                        buffer = AConfigWriter.replace(buffer, "aspectRatio", ar);
                    }
                    if (buffer.indexOf("<UsedWindow") >= 0 && (name = AConfigWriter.get(buffer, "name")) != null && (w = ACanvas.getCanvas().getWindow(name)) != null) {
                        if (w.getProjection() != null) {
                            buffer = AConfigWriter.replace(buffer, "projection", w.getProjection().getName());
                        }
                        buffer = AConfigWriter.replace(buffer, "group", w.getGroupName());
                    }
                    if (buffer.indexOf("<Layout") >= 0 && (name = AConfigWriter.get(buffer, "name")) != null && name.equals(ACanvas.getCanvas().getCurrentLayout().getName())) {
                        buffer = AConfigWriter.replace(buffer, "startupWindow", ACanvas.getCanvas().getCurrentWindowName());
                        buffer = AConfigWriter.replace(buffer, "startup", ACanvas.getCanvas().getStartupString());
                    }
                    if (buffer.indexOf("<Group") >= 0) {
                        groupName = AConfigWriter.get(buffer, "name");
                    }
                    aParam = null;
                    if (buffer.indexOf(" fn=\"") >= 0 && buffer.indexOf("<StatusRoot") < 0 && buffer.indexOf("<StatusGroup") < 0) {
                        parameterName = AConfigWriter.removeSpaces(AConfigWriter.get(buffer, "fn"));
                        aParam = APar.getUnknown(groupName, parameterName);
                    }
                    if (aParam != null) {
                        int index;
                        if (buffer.indexOf(" st=\"") >= 0) {
                            String status = "OFF";
                            if (aParam.getStatus()) {
                                status = "ON";
                            }
                            buffer = AConfigWriter.replace(buffer, "st", status);
                        }
                        if (buffer.indexOf(" va=\"") >= 0) {
                            String value = aParam.getValue();
                            if (parameterName.equals("Area/Energy")) {
                                value = "0.0";
                            } else if (parameterName.endsWith("Collections")) {
                                value = "0";
                            }
                            buffer = AConfigWriter.replace(buffer, "va", value);
                        }
                        if (buffer.indexOf(" dop=\"") >= 0) {
                            String dop = aParam.getOperator();
                            if (dop.equals("<")) {
                                dop = "&lt;";
                            }
                            if (dop.equals("<=")) {
                                dop = "&le;";
                            }
                            if (dop.equals(">")) {
                                dop = "&gt;";
                            }
                            if (dop.equals(">=")) {
                                dop = "&ge;";
                            }
                            buffer = AConfigWriter.replace(buffer, "dop", dop);
                        }
                        if (buffer.indexOf(" scope=\"") >= 0) {
                            if (aParam.getScope() == 2) {
                                buffer = AConfigWriter.replace(buffer, "scope", "GLOBAL");
                            } else if (aParam.getScope() == 1) {
                                buffer = AConfigWriter.replace(buffer, "scope", "LOCAL");
                            }
                        } else if (buffer.indexOf(" fn=\"") > 0 && aParam.getScope() != APar.getGroup(groupName).getScope() && (index = buffer.indexOf("/>")) > 0) {
                            if (aParam.getScope() == 2) {
                                buffer.insert(index, " scope=\"GLOBAL\"");
                            } else {
                                buffer.insert(index, " scope=\"LOCAL\"");
                            }
                        }
                    }
                }
                output.append(buffer);
                output.append("\n");
            }
            curr.close();
        }
        catch (IOException ex) {
            String m = "I/O error occured when reading the source configuration file: " + fileName;
            logger.error(m);
            logger.debug(m, ex);
            output = null;
        }
        catch (AAtlantisException ae) {
            // empty catch block
        }
        return output != null ? output.toString() : null;
    }

    private static String removeSpaces(String name) {
        StringBuffer strBuffer = new StringBuffer(name);
        int i = 0;
        while (i < strBuffer.length()) {
            if (Character.isWhitespace(strBuffer.charAt(i))) {
                strBuffer.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return new String(strBuffer);
    }

    private static StringBuffer replace(StringBuffer s, String variable, String text) {
        int name = s.indexOf(variable + "=\"");
        if (name >= 0) {
            int start = s.indexOf("\"", name);
            int stop = s.indexOf("\"", start + 1);
            s.delete(start + 1, stop);
            s.insert(start + 1, text);
        }
        return s;
    }

    private static String get(StringBuffer s, String variable) {
        int name = s.indexOf(" " + variable + "=\"");
        if (name >= 0) {
            int start = s.indexOf("\"", name);
            int stop = s.indexOf("\"", start + 1);
            return s.substring(start + 1, stop);
        }
        return null;
    }
}

