/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.Timer;

public class AControlButton
extends JButton {
    public static final int STANDARD_ACTION = 0;
    public static final int ACCELERATED_ACTION = 1;
    private ActionListener controlListener;
    private ActionEvent standardAction;
    private ActionEvent acceleratedAction;
    private long ticks;
    private Timer timer;
    private int initialDelay;
    private int tickLength;
    private int accelerationLimit;
    private boolean ignoreClick = false;

    public AControlButton(String text, int initialDelay, int tickLength, int accelerationLimit) {
        super(text);
        this.initialDelay = initialDelay;
        this.tickLength = tickLength;
        this.accelerationLimit = accelerationLimit;
        this.initialize();
    }

    private void initialize() {
        this.standardAction = new ActionEvent(this, 0, "", 0);
        this.acceleratedAction = new ActionEvent(this, 0, "", 1);
        this.timer = new Timer(this.tickLength, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AControlButton.this.ticks++;
                AControlButton.this.fireControlActionPerformed();
                AControlButton.this.ignoreClick = true;
            }
        });
        this.timer.setInitialDelay(this.initialDelay);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AControlButton.this.ticks = 0L;
                AControlButton.this.timer.restart();
            }

            public void mouseReleased(MouseEvent e) {
                AControlButton.this.timer.stop();
            }

            public void mouseClicked(MouseEvent e) {
                if (AControlButton.this.ignoreClick) {
                    AControlButton.this.ignoreClick = false;
                } else {
                    AControlButton.this.fireControlActionPerformed();
                }
            }
        });
    }

    private void fireControlActionPerformed() {
        if (this.controlListener != null) {
            if (this.ticks > (long)this.accelerationLimit) {
                this.controlListener.actionPerformed(this.acceleratedAction);
            } else {
                this.controlListener.actionPerformed(this.standardAction);
            }
        }
    }

    public void addControlActionListener(ActionListener controlListener) {
        if (this.controlListener != null) {
            throw new Error("AControlButton supports only 1 listener");
        }
        this.controlListener = controlListener;
    }
}

