/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.event.AEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ACrashReporter
implements Thread.UncaughtExceptionHandler {
    private static final String title = "An uncaught exception occured";
    private static final String msg = "An uncaught exception occured!\n\nPlease help us prevent this in the future by reporting this incident.\nIf you click yes, Atlantis will try to open your mail client and create\na preformatted crash report for you. You can review the information\nand add additional comments before it is sent.\n\nDo you want to report this crash?";
    private static final String address = "atlas-atlantis-developers@cern.ch";
    private static final String tag = "[crash-report] ";
    private static final String[] properties = new String[]{"java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "os.name", "os.arch", "os.version"};

    public void uncaughtException(Thread t, Throwable e) {
        int confirm = JOptionPane.showConfirmDialog(null, msg, title, 0, 2, null);
        if (confirm == 0) {
            String report = "### Please explain briefly what you did when the problem occured (optional)\n\n";
            report = report + "\n### Exception information\n\n";
            report = report + ACrashReporter.getExceptionInformation(e);
            report = report + "\n### General information\n\n";
            report = report + ACrashReporter.getGeneralInformation();
            report = report + "\n### Event information\n\n";
            report = report + ACrashReporter.getEventInformation();
            this.saveToFile(report);
        }
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "utf-8").replaceAll("\\+", "%20");
        }
        catch (Throwable ex) {
            return s;
        }
    }

    private void saveToFile(String report) {
        String directory = Atlantis.getHomeDirectory();
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setDialogTitle("Save crash report");
        chooser.setSelectedFile(new File("crash-report.txt"));
        report = "### Atlantis crash report, please send to atlas-atlantis-developers@cern.ch\n\n" + report;
        while (chooser.showSaveDialog(null) == 0) {
            File file = chooser.getSelectedFile();
            try {
                FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
                ((OutputStream)out).write(report.getBytes());
                ((OutputStream)out).close();
                JOptionPane.showMessageDialog(null, "The crash report has been saved successfully.\nPlease send the file to atlas-atlantis-developers@cern.ch");
                return;
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(null, "Cannot write file: " + ex.toString());
            }
        }
    }

    private static String getSubject(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            return tag + st[0].toString();
        }
        return tag + e.toString();
    }

    private static String getGeneralInformation() {
        String s = "";
        s = s + "Atlantis version = " + Atlantis.versionAtlantisJava + "\n";
        for (String property : properties) {
            String value = System.getProperty(property);
            if (value == null) {
                value = "(not set)";
            }
            s = s + property + " = " + value + "\n";
        }
        return s;
    }

    private static String getExceptionInformation(Throwable e) {
        StackTraceElement[] st;
        String s = "";
        String pad = "";
        s = s + e.toString() + "\n\n";
        for (StackTraceElement traceline : st = e.getStackTrace()) {
            s = s + pad + traceline + "\n";
            pad = "  ";
        }
        return s;
    }

    private static String getEventInformation() {
        String[][] info;
        String s = "";
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event == null) {
            return "(no current event)";
        }
        s = s + "Source = " + event.getSourceName() + "\n";
        s = s + "Run = " + event.getRunNumber() + "\n";
        s = s + "Event = " + event.getEventNumber() + "\n";
        s = s + "\nData types present:\n";
        for (String[] item : info = event.getInfo()) {
            s = s + "  " + item[0] + " (" + item[1] + ")\n";
        }
        return s;
    }
}

