/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;

public class ACursorFactory {
    private static ALogger logger = ALogger.getLogger(ACursorFactory.class);
    private static ACursorFactory instance;
    private String CursorSize;
    private String BAndW = "";
    private final boolean CustomCursors;
    private Cursor DefaultCursor = null;
    private Cursor DragValidCursor = null;
    private Cursor DragInvalidCursor = null;
    private Cursor ZoomCursor = null;
    private Cursor MoveCursor = null;
    private Cursor RotateCursor = null;
    private Cursor PickCursor = null;
    private Cursor RectSelectCursor = null;
    private Cursor SyncCursor = null;
    private Cursor FishEyeCursor = null;
    private Image FishEyeIndicator = null;
    private Image AtlasLogo = null;

    public boolean getCustomCursors() {
        return this.CustomCursors;
    }

    public Cursor getDefaultCursor() {
        return this.DefaultCursor;
    }

    public Cursor getDragValidCursor() {
        return this.DragValidCursor;
    }

    public Cursor getDragInvalidCursor() {
        return this.DragValidCursor;
    }

    public Cursor getZoomCursor() {
        return this.ZoomCursor;
    }

    public Cursor getMoveCursor() {
        return this.MoveCursor;
    }

    public Cursor getRotateCursor() {
        return this.RotateCursor;
    }

    public Cursor getPickCursor() {
        return this.PickCursor;
    }

    public Cursor getRectSelectCursor() {
        return this.RectSelectCursor;
    }

    public Cursor getSyncCursor() {
        return this.SyncCursor;
    }

    public Cursor getFishEyeCursor() {
        return this.FishEyeCursor;
    }

    public Image getFishEyeIndicator() {
        return this.FishEyeIndicator;
    }

    public Image getAtlasLogo() {
        return this.AtlasLogo;
    }

    public static ACursorFactory getInstance() {
        if (instance == null) {
            instance = new ACursorFactory();
        }
        return instance;
    }

    private ACursorFactory() {
        logger.debug("Creating cursor and image factory ...");
        String path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_fisheye_" + this.BAndW + "32x32.gif";
        this.FishEyeIndicator = AUtilities.getFileAsImageIcon(path).getImage();
        path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "atlas_logo_big.png";
        this.AtlasLogo = AUtilities.getFileAsImageIcon(path).getImage();
        if (Atlantis.isAtlantisHeadless()) {
            this.CustomCursors = false;
            return;
        }
        Dimension BestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(64, 64);
        if (BestCursorSize.width > 0) {
            this.CustomCursors = true;
            this.CursorSize = BestCursorSize.width < 48 ? "32x32" : "64x64";
            this.BAndW = Toolkit.getDefaultToolkit().getMaximumCursorColors() < 255 ? "bw_" : "";
            logger.info("Using " + this.BAndW + this.CursorSize + " cursors");
            Toolkit tools = Toolkit.getDefaultToolkit();
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_DnD_valid_" + this.CursorSize + ".gif";
            Image ValidDnDImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.DragValidCursor = tools.createCustomCursor(ValidDnDImg, new Point(1, 1), "ValidDnD");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_DnD_invalid_" + this.CursorSize + ".gif";
            Image InvalidDnDImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.DragInvalidCursor = tools.createCustomCursor(InvalidDnDImg, new Point(9, 9), "InvalidDnD");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_zoom_" + this.BAndW + this.CursorSize + ".gif";
            Image ZoomImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.ZoomCursor = tools.createCustomCursor(ZoomImg, new Point(9, 9), "Zoom");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_move_" + this.CursorSize + ".gif";
            Image MoveImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.MoveCursor = tools.createCustomCursor(MoveImg, new Point(10, 10), "Move");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_rotate_" + this.BAndW + this.CursorSize + ".gif";
            Image RotateImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.RotateCursor = tools.createCustomCursor(RotateImg, new Point(11, 11), "Rotate");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_pick_" + this.CursorSize + ".gif";
            Image PickImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.PickCursor = tools.createCustomCursor(PickImg, new Point(6, 1), "Pick");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_rectsel_" + this.CursorSize + ".gif";
            Image RectSelectImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.RectSelectCursor = tools.createCustomCursor(RectSelectImg, new Point(12, 12), "RectSelect");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_sync_" + this.CursorSize + ".gif";
            Image SyncImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.SyncCursor = tools.createCustomCursor(SyncImg, new Point(10, 10), "Sync");
            path = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "cursor_fisheye_" + this.BAndW + this.CursorSize + ".gif";
            Image FishEyeImg = AUtilities.getFileAsImageIcon(path).getImage();
            this.FishEyeCursor = tools.createCustomCursor(FishEyeImg, new Point(1, 8), "FishEye");
        } else {
            this.CustomCursors = false;
        }
        if (this.DefaultCursor == null) {
            this.DefaultCursor = new Cursor(0);
        }
        if (this.DragValidCursor == null) {
            this.DragValidCursor = DragSource.DefaultMoveDrop;
        }
        if (this.DragInvalidCursor == null) {
            this.DragInvalidCursor = DragSource.DefaultMoveNoDrop;
        }
        if (this.ZoomCursor == null) {
            this.ZoomCursor = new Cursor(0);
        }
        if (this.MoveCursor == null) {
            this.MoveCursor = new Cursor(13);
        }
        if (this.RotateCursor == null) {
            this.RotateCursor = new Cursor(0);
        }
        if (this.PickCursor == null) {
            this.PickCursor = new Cursor(12);
        }
        if (this.RectSelectCursor == null) {
            this.RectSelectCursor = new Cursor(6);
        }
        if (this.SyncCursor == null) {
            this.SyncCursor = new Cursor(1);
        }
    }
}

