/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import java.awt.Dimension;

public class ADefaultCellAttribute {
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    protected int rowSize;
    protected int columnSize;
    protected int[][][] span;

    public ADefaultCellAttribute() {
        this(1, 1);
    }

    public ADefaultCellAttribute(int numRows, int numColumns) {
        this.setSize(new Dimension(numColumns, numRows));
    }

    protected void initValue() {
        for (int i = 0; i < this.span.length; ++i) {
            for (int j = 0; j < this.span[i].length; ++j) {
                this.span[i][j][1] = 1;
                this.span[i][j][0] = 1;
            }
        }
    }

    public int[] getSpan(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            int[] ret_code = new int[]{1, 1};
            return ret_code;
        }
        return this.span[row][column];
    }

    public boolean isVisible(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return false;
        }
        return this.span[row][column][1] >= 1 && this.span[row][column][0] >= 1;
    }

    public void combine(int[] rows, int[] columns) {
        int i;
        if (this.isOutOfBounds(rows, columns)) {
            return;
        }
        int rowSpan = rows.length;
        int columnSpan = columns.length;
        int startRow = rows[0];
        int startColumn = columns[0];
        for (i = 0; i < rowSpan; ++i) {
            for (int j = 0; j < columnSpan; ++j) {
                if (this.span[startRow + i][startColumn + j][1] == 1 && this.span[startRow + i][startColumn + j][0] == 1) continue;
                return;
            }
        }
        i = 0;
        int ii = 0;
        while (i < rowSpan) {
            int jj = 0;
            for (int j = 0; j < columnSpan; ++j) {
                this.span[startRow + i][startColumn + j][1] = jj--;
                this.span[startRow + i][startColumn + j][0] = ii;
            }
            ++i;
            --ii;
        }
        this.span[startRow][startColumn][1] = columnSpan;
        this.span[startRow][startColumn][0] = rowSpan;
    }

    public Dimension getSize() {
        return new Dimension(this.rowSize, this.columnSize);
    }

    public void setSize(Dimension size) {
        this.columnSize = size.width;
        this.rowSize = size.height;
        this.span = new int[this.rowSize][this.columnSize][2];
        this.initValue();
    }

    protected boolean isOutOfBounds(int row, int column) {
        return row < 0 || this.rowSize <= row || column < 0 || this.columnSize <= column;
    }

    protected boolean isOutOfBounds(int[] rows, int[] columns) {
        int i;
        for (i = 0; i < rows.length; ++i) {
            if (rows[i] >= 0 && this.rowSize > rows[i]) continue;
            return true;
        }
        for (i = 0; i < columns.length; ++i) {
            if (columns[i] >= 0 && this.columnSize > columns[i]) continue;
            return true;
        }
        return false;
    }
}

