/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ADemoLoop;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACommandProcessor;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADemoDialog
extends JFrame
implements ActionListener {
    private static final ALogger logger = ALogger.getLogger(ADemoDialog.class);
    private JSpinner timerSpinner;
    private SpinnerNumberModel timerSpinnerModel;
    private static final Integer TIMER_MIN = new Integer(1);
    private static final Integer TIMER_MAX = new Integer(120);
    private static final Integer TIMER_INIT = new Integer(3);
    private final Vector<JButton> projectionButtons = new Vector();
    private JTextField sequenceTextField = null;
    private JPanel projControlPanel = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JButton closeButton = null;
    private ADemoLoop demo = null;
    private static ADemoDialog instance = null;

    public static ADemoDialog getInstance() {
        if (instance == null) {
            instance = new ADemoDialog();
        }
        return instance;
    }

    private ADemoDialog() {
        super("Demo");
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        JPanel timerControlPanel = this.createTimeControlPanel();
        this.projControlPanel = this.createProjControlPanel();
        JPanel buttonControlPanel = this.createButtonControlPanel();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setOpaque(true);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 10;
        contentPane.add((Component)timerControlPanel, c);
        contentPane.add((Component)this.projControlPanel, c);
        contentPane.add((Component)buttonControlPanel, c);
        this.setResizable(false);
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        AUtilities.setIconImage(this);
    }

    private JPanel createTimeControlPanel() {
        JPanel aPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        aPanel.setOpaque(true);
        aPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel timerLabel = new JLabel("Interval");
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        aPanel.add((Component)timerLabel, c);
        this.timerSpinner = new JSpinner();
        this.timerSpinner.setEnabled(true);
        this.timerSpinnerModel = new SpinnerNumberModel(TIMER_INIT, TIMER_MIN, TIMER_MAX, new Integer(1));
        this.timerSpinner.setModel(this.timerSpinnerModel);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        aPanel.add((Component)this.timerSpinner, c);
        c.weightx = 0.5;
        c.gridwidth = 0;
        c.gridx = 2;
        aPanel.add((Component)new JLabel(" sec"), c);
        c.gridx = -1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        aPanel.add((Component)new JLabel("Sequence:"), c);
        this.sequenceTextField = new JTextField();
        c.gridwidth = 0;
        c.fill = 2;
        aPanel.add((Component)this.sequenceTextField, c);
        return aPanel;
    }

    private JPanel createProjControlPanel() {
        JPanel aPanel = new JPanel(new GridLayout(3, 4));
        aPanel.setOpaque(true);
        Border outerBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        TitledBorder innerBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), "Add Projection / Action");
        aPanel.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        for (String projName : AProjectionsManager.getKnownProjectionNames()) {
            if (!AProjectionsManager.useProjectionInDemoMode(projName)) continue;
            String projScreenName = AProjectionsManager.getProjection(projName).getScreenName();
            JButton projButton = new JButton(projScreenName);
            projButton.setName(projName);
            projButton.setFocusPainted(false);
            projButton.addActionListener(this);
            aPanel.add(projButton);
        }
        JButton nextEvtBut = new JButton("Next event");
        nextEvtBut.setName("NE");
        nextEvtBut.addActionListener(this);
        aPanel.add(nextEvtBut);
        return aPanel;
    }

    private JPanel createButtonControlPanel() {
        Dimension buttonDimension = new Dimension(100, 25);
        JPanel aPanel = new JPanel(new GridBagLayout());
        aPanel.setOpaque(true);
        aPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        GridBagConstraints c = new GridBagConstraints();
        this.startButton = new JButton("Start");
        this.startButton.setEnabled(true);
        this.startButton.setPreferredSize(buttonDimension);
        this.startButton.addActionListener(this);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        aPanel.add((Component)this.startButton, c);
        this.stopButton = new JButton("Stop");
        this.stopButton.setFocusPainted(false);
        this.stopButton.setEnabled(false);
        this.stopButton.setPreferredSize(buttonDimension);
        this.stopButton.addActionListener(this);
        aPanel.add((Component)this.stopButton, c);
        JSeparator aSeparator = new JSeparator(1);
        aPanel.add((Component)aSeparator, c);
        this.closeButton = new JButton("Close");
        this.closeButton.setFocusPainted(false);
        this.closeButton.setEnabled(true);
        this.closeButton.setPreferredSize(buttonDimension);
        this.closeButton.addActionListener(this);
        c.gridwidth = 0;
        aPanel.add((Component)this.closeButton, c);
        return aPanel;
    }

    boolean isRunning() {
        if (this.demo == null) {
            return false;
        }
        return this.demo.isRunning();
    }

    int getTimerInterval() {
        return 1000 * this.timerSpinnerModel.getNumber().intValue();
    }

    public void setTimerInterval(Integer intervalInSec) {
        try {
            this.timerSpinnerModel.setValue(intervalInSec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setSequence(String projNames) {
        this.sequenceTextField.setText(projNames);
    }

    public void setDefaultSequence() {
        String sequence = "";
        for (String projName : AProjectionsManager.getKnownProjectionNames()) {
            if (!AProjectionsManager.defaultProjectionInDemoMode(projName)) continue;
            sequence = sequence + projName + ":";
        }
        sequence = sequence + "NE";
        this.sequenceTextField.setText(sequence);
    }

    private Vector<String> getSequence() {
        return new Vector<String>(Arrays.asList(this.sequenceTextField.getText().split(":")));
    }

    public boolean validateSequence() {
        Vector<String> sequence = this.getSequence();
        if (sequence.size() < 1) {
            JOptionPane.showMessageDialog(this, "No projection/event is selected, please select at least select one", "Warning", 2);
            return false;
        }
        for (String projName : sequence) {
            if (projName.equals("NE") || Arrays.asList(AProjectionsManager.getKnownProjectionNames()).contains(projName) && AProjectionsManager.useProjectionInDemoMode(projName)) continue;
            JOptionPane.showMessageDialog(this, "Not a valid projection name: '" + projName + "'", "Warning", 2);
            return false;
        }
        return true;
    }

    public void startDemo() {
        if (!this.validateSequence()) {
            return;
        }
        ACommandProcessor.receive("WW");
        this.demo = new ADemoLoop(this.getTimerInterval(), this.getSequence(), false);
        this.demo.startDemoLoop();
        this.timerSpinner.setEnabled(false);
        this.sequenceTextField.setEnabled(false);
        for (Component comp : this.projControlPanel.getComponents()) {
            comp.setEnabled(false);
        }
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    synchronized void stopDemo() {
        this.demo.stopDemoLoop();
        this.timerSpinner.setEnabled(true);
        this.sequenceTextField.setEnabled(true);
        for (Component comp : this.projControlPanel.getComponents()) {
            comp.setEnabled(true);
        }
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
        this.closeButton.setEnabled(true);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this.startDemo();
        } else if (e.getSource() == this.stopButton) {
            this.stopDemo();
        } else if (e.getSource() == this.closeButton) {
            this.dispose();
        } else {
            String projName = ((JButton)e.getSource()).getName();
            String sequence = this.sequenceTextField.getText();
            sequence = sequence + (sequence.length() != 0 ? ":" : "") + projName;
            this.sequenceTextField.setText(sequence);
        }
    }
}

