/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.event.AEventSource;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACommandProcessor;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADemoLoop
extends Timer
implements ActionListener {
    private static ALogger logger = ALogger.getLogger(ADemoLoop.class);
    private boolean isRunning = false;
    private boolean stopOnNoMoreEvents = false;
    private final ArrayList projectionList = new ArrayList();
    Iterator<String> projIter = null;

    public ADemoLoop(int sleepTime, Vector<String> projectionList, boolean stopOnNoMoreEvents) {
        super(sleepTime, null);
        this.addActionListener(this);
        this.setInitialDelay(0);
        for (String projName : projectionList) {
            this.projectionList.add(projName);
        }
        this.stopOnNoMoreEvents = stopOnNoMoreEvents;
    }

    public void startDemoLoop() {
        logger.trace("Starting demo loop with interval " + Integer.toString(this.getDelay()) + " ms and projections " + this.projectionList.toString());
        this.projIter = this.projectionList.listIterator(0);
        this.start();
    }

    public void stopDemoLoop() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.projIter.hasNext()) {
            this.projIter = this.projectionList.listIterator(0);
        }
        String projName = this.projIter.next();
        logger.trace("Next in demo loop: " + projName);
        if (projName.equals("NE")) {
            Iterator<String> nextProjIter;
            if (!this.changeEvent()) {
                this.stop();
                ADemoLoop aDemoLoop = this;
                synchronized (aDemoLoop) {
                    this.notifyAll();
                }
            }
            if ((nextProjIter = this.projIter).hasNext() && !nextProjIter.next().equals("NE")) {
                this.restart();
            }
            logger.trace("Timer is" + (this.isRunning() ? " running" : " stopped") + " with " + this.getDelay() + " ms delay");
        } else {
            this.changeProjection(projName);
        }
    }

    private void changeProjection(String projName) {
        AProjection p = AProjectionsManager.getProjection(projName);
        ACanvas.getCanvas().getCurrentWindow().setProjection(p);
        if (projName.equals("YX") || projName.equals("RZ") || projName.equals("XZ") || projName.equals("YZ")) {
            ((AProjection2D)p).setAspectRatio1(ACanvas.getCanvas().getCurrentWindow());
        }
        ACommandProcessor.receive(projName + ".");
    }

    private boolean changeEvent() {
        try {
            Atlantis.getEventManager().nextEvent();
            return true;
        }
        catch (AEventSource.NoMoreEventsException ex) {
            logger.info("No next event for demo - " + (this.stopOnNoMoreEvents ? "stopping loop" : "keeping same"));
            return !this.stopOnNoMoreEvents;
        }
        catch (AEventSource.InvalidEventSourceException ex) {
            logger.warn("Invalid event source for demo - " + (this.stopOnNoMoreEvents ? "stopping loop" : "will try again") + "\n" + ex.getCauseMessages());
            if (Atlantis.isAtlantisHeadless()) {
                return !this.stopOnNoMoreEvents;
            }
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "Invalid event source for demo - stopping loop", "Warning", 2);
            return false;
        }
        catch (AEventSource.ReadEventException ex) {
            logger.warn("Received invalid event - stopping loop:\n" + ex.getCauseMessages());
            if (Atlantis.isAtlantisHeadless()) {
                return false;
            }
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "Received invalid event for demo - stopping loop", "Warning", 2);
            return false;
        }
    }
}

