/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ACallBack;
import atlantis.gui.ACursorFactory;
import atlantis.gui.ADragListener;
import atlantis.gui.AObjectTransferable;
import atlantis.utils.AOutput;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Vector;
import javax.swing.JLabel;

public class ADnDLabel
extends JLabel
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DragSource dragSource = null;
    private Vector dragListeners;
    private boolean dragHighlight;
    private String[] page;
    public static final Cursor DROP_VALID = ACursorFactory.getInstance().getDragValidCursor();
    public static final Cursor DROP_INVALID = ACursorFactory.getInstance().getDragInvalidCursor();
    private Color old;

    public JLabel getLabel() {
        return this;
    }

    public ADnDLabel(String name, boolean dragHighlight) {
        super(name, 0);
        this.setName(name);
        this.setOpaque(true);
        this.page = null;
        this.dragHighlight = dragHighlight;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.setDropTarget(new DropTarget(this, this));
        this.dragListeners = new Vector();
    }

    public ADnDLabel(String name, String[] wnames, boolean dragHighlight) {
        super(name, 0);
        this.setName(name);
        this.setOpaque(true);
        this.page = wnames;
        this.dragHighlight = dragHighlight;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.setDropTarget(new DropTarget(this, this));
        this.dragListeners = new Vector();
    }

    public Dimension getPreferredSize() {
        return new Dimension(15, 15);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(2);
        if (this.dragHighlight) {
            this.old = this.getBackground();
            this.setBackground(new Color(150, 150, 150));
        }
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.dragHighlight) {
            this.setBackground(this.old);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            DataFlavor javaObjectDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
            if (transferable.isDataFlavorSupported(javaObjectDataFlavor)) {
                dtde.acceptDrop(2);
                Object object = transferable.getTransferData(javaObjectDataFlavor);
                if (object instanceof ACallBack) {
                    ((ACallBack)object).callBack(this);
                } else {
                    this.fireDragEvent(object);
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                AOutput.append("Cannot accept drop\n", "BAD_COMMAND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    private void fireDragEvent(Object from) {
        for (int i = 0; i < this.dragListeners.size(); ++i) {
            ((ADragListener)this.dragListeners.get(i)).dragPerformed(from, this, -1);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DROP_VALID);
    }

    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DROP_INVALID);
    }

    public void dragOver(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DROP_VALID);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.dragSource.startDrag(dge, DROP_VALID, new AObjectTransferable(this), this);
    }

    public void addDragListener(ADragListener l) {
        this.dragListeners.addElement(l);
    }

    public String[] returnPageName() {
        return this.page;
    }
}

