/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.event.AEvent;
import atlantis.event.ANewEventListener;
import atlantis.utils.ALogPane;
import atlantis.utils.AMath;

public class AEventInfoPrinter
implements ANewEventListener {
    private ALogPane logPane = null;

    public AEventInfoPrinter(ALogPane output) {
        this.logPane = output;
        Atlantis.getEventManager().addNewEventListener(this);
    }

    private void printEventInfo(AEvent event, ALogPane dest) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String r = "\n" + event.getSourceName() + " (" + event.getRunNumber() + "00" + event.getEventNumber() + ")\n";
            dest.append(r + "\n", "NORMAL");
            return;
        }
        int lineLen = 39;
        String r = "\n" + event.getSourceName() + "\n" + "run number: " + event.getRunNumber() + " event number: " + event.getEventNumber() + "\n" + "--------------------------------------\n";
        String[][] s = event.getInfo();
        for (int i = 0; i < s.length; ++i) {
            r = r + AMath.ensureWidth(s[i][0], lineLen) + ": " + s[i][1] + "\n";
        }
        dest.append(r + "\n", "NORMAL");
    }

    public void newEvent(AEvent event) {
        this.printEventInfo(event, this.logPane);
    }
}

