/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.event.AEventSource;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.ALogPane;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AEventLoopDialog
extends JFrame
implements WindowListener,
ActionListener,
ChangeListener {
    private static ALogger logger = ALogger.getLogger(AEventLoopDialog.class);
    private static AEventLoopDialog instance;
    private static final String TITLE = "Event loop";
    private static final Integer SPINNER_INIT;
    private static final Integer SPINNER_MIN;
    private static final Integer SPINNER_MAX;
    private static final Integer SPINNER_STEP;
    private static JButton button;
    private static JSpinner updateIntervalSpinner;
    private static ALogPane log;
    private static final Timer timer;

    private AEventLoopDialog() {
        super(TITLE);
        this.createGUI();
    }

    public static AEventLoopDialog getInstance() {
        if (instance == null) {
            instance = new AEventLoopDialog();
        }
        return instance;
    }

    public void setUpdateInterval(int UpdateInterval) {
        try {
            updateIntervalSpinner.setValue(UpdateInterval);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void createGUI() {
        int defaultGap = 5;
        Border defaultBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        SpinnerNumberModel numberModel = new SpinnerNumberModel(SPINNER_INIT, SPINNER_MIN, SPINNER_MAX, SPINNER_STEP);
        updateIntervalSpinner = new JSpinner(numberModel);
        updateIntervalSpinner.addChangeListener(this);
        JPanel loopingPanel = new JPanel();
        loopingPanel.setLayout(new BorderLayout(5, 0));
        loopingPanel.setBorder(defaultBorder);
        loopingPanel.add((Component)updateIntervalSpinner, "Center");
        loopingPanel.add((Component)new JLabel("[secs]"), "East");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        buttonsPanel.setBorder(defaultBorder);
        button = new JButton("Start");
        button.setPreferredSize(new Dimension(100, 25));
        buttonsPanel.add((Component)button, "Center");
        button.addActionListener(this);
        JPanel topRowPanel = new JPanel();
        topRowPanel.setLayout(new BorderLayout(5, 0));
        topRowPanel.add((Component)loopingPanel, "Center");
        topRowPanel.add((Component)buttonsPanel, "East");
        JPanel logPanel = new JPanel();
        logPanel.setLayout(new BorderLayout(0, 0));
        logPanel.setBorder(defaultBorder);
        log = new ALogPane();
        log.setEnabled(true);
        log.setBorder(BorderFactory.createLineBorder(Color.black));
        log.setRequestFocusEnabled(false);
        log.setPreferredSize(new Dimension(350, 200));
        logPanel.add((Component)log, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel upperMainPanel = new JPanel();
        upperMainPanel.setLayout(new BorderLayout(0, 0));
        upperMainPanel.add((Component)topRowPanel, "North");
        mainPanel.add((Component)upperMainPanel, "North");
        mainPanel.add((Component)logPanel, "Center");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setLocation(HTrackMomentaWindow.getGUI().getX(), HTrackMomentaWindow.getGUI().getY());
        AUtilities.setIconImage(this);
        this.addWindowListener(this);
        timer.addActionListener(this);
        timer.setInitialDelay(0);
    }

    public void stateChanged(ChangeEvent e) {
        timer.setDelay((Integer)updateIntervalSpinner.getValue() * 1000);
    }

    public void windowClosing(WindowEvent e) {
        if (timer.isRunning()) {
            this.stopEventLoop();
        }
    }

    private void timeStampedLog(String msg) {
        SimpleDateFormat dateForm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.append("\n" + dateForm.format(new Date()) + " ", "NORMAL_BOLD");
        log.append(msg);
    }

    private void getNextEvent() {
        try {
            this.timeStampedLog("Reading next event...");
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.NoMoreEventsException ex) {
            log.append("\n -- No next event available");
            logger.info("No next event available:\n" + ex.getCauseMessages());
        }
        catch (AEventSource.InvalidEventSourceException ex) {
            log.append("\n -- Invalid event source");
            logger.warn("Invalid event source:\n" + ex.getCauseMessages());
        }
        catch (AEventSource.ReadEventException ex) {
            log.append("\n -- Received invalid event");
            logger.warn("Received invalid event:\n" + ex.getCauseMessages());
        }
    }

    private void stopEventLoop() {
        timer.stop();
        button.setText("Start");
        updateIntervalSpinner.setEnabled(true);
        this.timeStampedLog("Stopped event loop...");
    }

    public void startEventLoop() {
        this.timeStampedLog("Starting event loop...");
        updateIntervalSpinner.setEnabled(false);
        button.setText("Stop");
        timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == timer) {
            this.getNextEvent();
            return;
        }
        if (timer.isRunning()) {
            this.stopEventLoop();
        } else {
            this.startEventLoop();
        }
    }

    public void showDialog() {
        this.setExtendedState(this.getExtendedState() & 0xFFFFFFFE);
        this.setVisible(true);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        SPINNER_INIT = new Integer(4);
        SPINNER_MIN = new Integer(1);
        SPINNER_MAX = new Integer(120);
        SPINNER_STEP = new Integer(2);
        button = null;
        updateIntervalSpinner = null;
        log = null;
        timer = new Timer(SPINNER_INIT * 1000, null);
    }
}

