/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.ALVL1ResultData;
import atlantis.data.ATriggerInfoData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.event.ANewEventListener;
import atlantis.gui.AFlowLayout;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AUtilities;
import com.Ostermiller.util.CSVParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class AEventPropertiesDialog
extends JFrame
implements ANewEventListener {
    private static ALogger logger = ALogger.getLogger(AEventPropertiesDialog.class);
    private JTable table;
    private JTable propertiesTable;
    private JTable level1Table;
    private JTable level2Table;
    private JTable eventFilterTable;
    private JTable trigInfoItemsTable;
    private JTable trigInfoStreamTable;
    private JTable userSelectedTable;
    private JTable mbtsTable;
    private JPanel buttonsPanel;
    private JTabbedPane tabbedPane;
    private JButton okButton;
    private JButton refreshButton;
    private static AEventPropertiesDialog instance = null;
    protected static String[] USER_ITEMS = null;
    private static final String LOOKUP_FILENAME = "epusti.csv";
    private static final String LOOKUP_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "epusti.csv";

    public static boolean isInUse() {
        return instance != null && instance.isVisible();
    }

    public static AEventPropertiesDialog getInstance() {
        if (instance == null) {
            instance = new AEventPropertiesDialog();
        }
        return instance;
    }

    public AEventPropertiesDialog() {
        Atlantis.getEventManager().addNewEventListener(this);
        this.setTitle("Event Properties Dialog");
        AUtilities.setIconImage(this);
        try {
            Class[] cargs = new Class[]{Boolean.TYPE};
            Method thm = this.getClass().getMethod("setAlwaysOnTop", cargs);
            Object[] oargs = new Object[]{Boolean.TRUE};
            thm.invoke((Object)this, oargs);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Atlantis.getEventManager().getCurrentEvent() == null) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "Current event is null\n(no event data currently present)", "Event null", 2);
            return;
        }
        try {
            this.readFromLookupFile();
        }
        catch (AAtlantisException ex) {
            logger.warn(": reading " + LOOKUP_FILE + " failed, user trigger items will not " + "be available, reason: " + ex.getMessage(), ex);
        }
        this.fillTabbedPane(0);
        this.addButtonPane();
        this.setDefaultCloseOperation(2);
        this.pack();
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        this.setVisible(true);
    }

    private void readFromLookupFile() throws AAtlantisException {
        if (USER_ITEMS == null) {
            try {
                InputStream is = AUtilities.getFileAsStream(LOOKUP_FILE);
                CSVParser parser = new CSVParser(is);
                parser.setCommentStart("#");
                String valueArray = parser.nextValue();
                CSVParser parserArray = new CSVParser((Reader)new StringReader(valueArray));
                String[][] s = parserArray.getAllValues();
                if (s != null) {
                    USER_ITEMS = s[0];
                }
            }
            catch (IOException e) {
                throw new AAtlantisException("exception while reading file: " + LOOKUP_FILE);
            }
            catch (AAtlantisException e) {
                throw e;
            }
        }
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void updatePane() {
        JTabbedPane currentTabbedPane = (JTabbedPane)this.getContentPane().getComponent(0);
        int currentIndex = currentTabbedPane.getSelectedIndex();
        this.getContentPane().removeAll();
        this.validate();
        this.fillTabbedPane(currentIndex);
        this.addButtonPane();
        this.pack();
    }

    private void addButtonPane() {
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventPropertiesDialog.this.dispose();
            }
        });
        this.refreshButton = new JButton("Refresh Cuts");
        this.refreshButton.setToolTipText("Display data passing cuts for active window");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventPropertiesDialog.this.updatePane();
            }
        });
        this.buttonsPanel = new JPanel(new AFlowLayout(10, 5));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.refreshButton);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    private void fillTabbedPane(int index) {
        this.fillTablePane();
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        Vector keys = (Vector)event.getCollections().get("LVL1Result");
        ALVL1ResultData[] lvl1ResultData = null;
        if (keys != null) {
            lvl1ResultData = new ALVL1ResultData[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                String colLvl1 = "LVL1Result" + (String)keys.elementAt(i);
                lvl1ResultData[i] = (ALVL1ResultData)event.get(colLvl1);
            }
        }
        ATriggerInfoData triggerInfoData = event.getTriggerInfoData();
        this.fillPropertiesPane(lvl1ResultData, triggerInfoData);
        String[][] L1_items = this.fillLevel1Pane(lvl1ResultData);
        String[][] L2_items = this.fillLevel2Pane(lvl1ResultData);
        String[][] EF_items = this.fillEventFilterPane(lvl1ResultData);
        this.fillTrigInfoItemsPane(triggerInfoData);
        this.fillTrigInfoStreamPane(triggerInfoData);
        this.fillUserSelectedPane(L1_items, L2_items, EF_items);
        this.fillmbtsPane();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Number of Hits", new JScrollPane(this.table));
        this.tabbedPane.addTab("Properties", new JScrollPane(this.propertiesTable));
        this.tabbedPane.addTab("Level 1 Trigger Items", new JScrollPane(this.level1Table));
        this.tabbedPane.addTab("Level 2 Trigger Items", new JScrollPane(this.level2Table));
        this.tabbedPane.addTab("Event Filter Trigger Items", new JScrollPane(this.eventFilterTable));
        this.tabbedPane.addTab("Trigger Info Items", new JScrollPane(this.trigInfoItemsTable));
        this.tabbedPane.addTab("Trigger Info Stream Tag", new JScrollPane(this.trigInfoStreamTable));
        this.tabbedPane.addTab("User Selected Trigger Items", new JScrollPane(this.userSelectedTable));
        this.tabbedPane.addTab("All MBTS cell details", new JScrollPane(this.mbtsTable));
        this.tabbedPane.setSelectedIndex(index);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private void fillTablePane() {
        this.table = new JTable(Atlantis.getEventManager().getCurrentEvent().getInfoDraw(), new String[]{"detector / datatype", "data items", "passing cuts"});
        this.table.setRowHeight(20);
        this.table.setFont(new Font("Monospaced", 0, 16));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
    }

    private void fillPropertiesPane(ALVL1ResultData[] lvl1ResultData, ATriggerInfoData triggerInfoData) {
        Object[][] properties;
        double et = 0.0;
        List calo = Atlantis.getEventManager().getCurrentEvent().getCalorimeters();
        for (int i = 0; i < calo.size(); ++i) {
            et += ((ACalorimeterData)calo.get(i)).getTotalTransverseEnergy();
        }
        if (lvl1ResultData == null) {
            if (triggerInfoData == null) {
                properties = new String[2][2];
                properties[1][0] = "Trigger Decision";
                properties[1][1] = "N/A";
            } else {
                properties = new String[7][2];
                properties[1][0] = "Trigger Decision";
                properties[1][1] = "N/A";
                properties[2][0] = "Trigger Info: Level 1 EtMiss";
                properties[2][1] = String.valueOf(triggerInfoData.getEnergyEtMiss(0));
                properties[3][0] = "Trigger Info: Level 1 SumEt";
                properties[3][1] = String.valueOf(triggerInfoData.getEnergyEtMiss(0));
                properties[4][0] = "Trigger Info: ExtL1ID";
                properties[4][1] = triggerInfoData.getTrigInfoExtL1ID(0);
                properties[5][0] = "Trigger Info: Lvl1Type";
                properties[5][1] = triggerInfoData.getTrigInfoLvl1Type(0);
                properties[6][0] = "Trigger Info: Status";
                properties[6][1] = triggerInfoData.getTrigInfoStatus(0);
            }
        } else {
            properties = new String[5 * lvl1ResultData.length + 6][2];
            properties[1][0] = "Trigger Info: Level 1 EtMiss";
            properties[2][0] = "Trigger Info: Level 1 SumEt";
            properties[3][0] = "Trigger Info: ExtL1ID";
            properties[4][0] = "Trigger Info: Lvl1Type";
            properties[5][0] = "Trigger Info: Status";
            if (triggerInfoData != null) {
                properties[1][1] = String.valueOf(triggerInfoData.getEnergyEtMiss(0));
                properties[2][1] = String.valueOf(triggerInfoData.getEnergySumEt(0));
                properties[3][1] = triggerInfoData.getTrigInfoExtL1ID(0);
                properties[4][1] = triggerInfoData.getTrigInfoLvl1Type(0);
                properties[5][1] = triggerInfoData.getTrigInfoStatus(0);
            } else {
                properties[1][1] = "N/A";
                properties[2][1] = "N/A";
                properties[3][1] = "N/A";
                properties[4][1] = "N/A";
                properties[5][1] = "N/A";
            }
            for (int j = 0; j < lvl1ResultData.length; ++j) {
                int ref = j * 5;
                String name = lvl1ResultData[j].getStoreGateKey();
                properties[6 + ref][0] = name + ": Level 1 result";
                properties[7 + ref][0] = name + ": Level 2 result";
                properties[8 + ref][0] = name + ": Event Filter result";
                properties[9 + ref][0] = name + ": Level 1 EtMiss";
                properties[10 + ref][0] = name + ": Level 1 SumEt";
                int[] temp = new int[]{lvl1ResultData[j].getPassedL1(0), lvl1ResultData[j].getPassedL2(0), lvl1ResultData[j].getPassedEF(0)};
                block7: for (int i = 0; i < 3; ++i) {
                    switch (temp[i]) {
                        case -1: {
                            properties[i + 6 + ref][1] = "N/C";
                            continue block7;
                        }
                        case 0: {
                            properties[i + 6 + ref][1] = "failed";
                            continue block7;
                        }
                        case 1: {
                            properties[i + 6 + ref][1] = "passed";
                            continue block7;
                        }
                        default: {
                            properties[i + 6 + ref][1] = "N/A";
                        }
                    }
                }
                float LVL1EtMiss = lvl1ResultData[j].getEnergyEtMiss(0);
                float LVL1SumEt = lvl1ResultData[j].getEnergySumEt(0);
                properties[9 + ref][1] = LVL1EtMiss > 0.0f ? String.valueOf(LVL1EtMiss) : "N/A";
                properties[10 + ref][1] = LVL1SumEt > 0.0f ? String.valueOf(LVL1SumEt) : "N/A";
            }
        }
        properties[0][0] = "Transv. Energy (GeV)";
        properties[0][1] = AMath.d2s(et, 2);
        this.propertiesTable = new JTable(properties, new String[]{"Name", "Value"});
        this.propertiesTable.setRowHeight(20);
        this.propertiesTable.setFont(new Font("Monospaced", 0, 16));
        this.propertiesTable.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.propertiesTable.getColumnModel().getColumn(1).setPreferredWidth(100);
    }

    private String[][] fillLevel1Pane(ALVL1ResultData[] lvl1ResultData) {
        Object[][] properties;
        if (lvl1ResultData == null) {
            properties = new String[1][2];
            properties[0][0] = "N/A";
            properties[0][1] = "N/A";
        } else {
            int j;
            String[][] items = new String[lvl1ResultData.length][];
            String[][] prescales = new String[lvl1ResultData.length][];
            int numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                items[j] = lvl1ResultData[j].getCtpItemListSplit(0, false);
                prescales[j] = lvl1ResultData[j].getPrescaleListL1Split(0);
                numItems += items[j].length;
            }
            properties = new String[numItems][2];
            numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                String name = lvl1ResultData[j].getStoreGateKey();
                for (int i = 0; i < items[j].length; ++i) {
                    properties[numItems][0] = name + ": " + items[j][i];
                    properties[numItems][1] = prescales[j] != null && i < prescales[j].length ? prescales[j][i] : "N/A";
                    ++numItems;
                }
            }
        }
        this.level1Table = new JTable(properties, new String[]{"Item passed", "Prescale"});
        this.level1Table.setRowHeight(20);
        this.level1Table.setFont(new Font("Monospaced", 0, 16));
        this.level1Table.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.level1Table.getColumnModel().getColumn(1).setPreferredWidth(100);
        return properties;
    }

    private String[][] fillLevel2Pane(ALVL1ResultData[] lvl1ResultData) {
        Object[][] properties;
        if (lvl1ResultData == null) {
            properties = new String[1][2];
            properties[0][0] = "N/A";
            properties[0][1] = "N/A";
        } else {
            int j;
            String[][] items = new String[lvl1ResultData.length][];
            String[][] prescales = new String[lvl1ResultData.length][];
            int numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                items[j] = lvl1ResultData[j].getitemListL2Split(0, false);
                prescales[j] = lvl1ResultData[j].getPrescaleListL2Split(0);
                numItems += items[j].length;
            }
            properties = new String[numItems][2];
            numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                String name = lvl1ResultData[j].getStoreGateKey();
                for (int i = 0; i < items[j].length; ++i) {
                    properties[numItems][0] = name + ": " + items[j][i];
                    properties[numItems][1] = prescales[j] != null && i < prescales[j].length ? prescales[j][i] : "N/A";
                    ++numItems;
                }
            }
        }
        this.level2Table = new JTable(properties, new String[]{"Item passed", "Prescale"});
        this.level2Table.setRowHeight(20);
        this.level2Table.setFont(new Font("Monospaced", 0, 16));
        this.level2Table.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.level2Table.getColumnModel().getColumn(1).setPreferredWidth(100);
        return properties;
    }

    private String[][] fillEventFilterPane(ALVL1ResultData[] lvl1ResultData) {
        Object[][] properties;
        if (lvl1ResultData == null) {
            properties = new String[1][2];
            properties[0][0] = "N/A";
            properties[0][1] = "N/A";
        } else {
            int j;
            String[][] items = new String[lvl1ResultData.length][];
            String[][] prescales = new String[lvl1ResultData.length][];
            int numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                items[j] = lvl1ResultData[j].getitemListEFSplit(0, false);
                prescales[j] = lvl1ResultData[j].getPrescaleListEFSplit(0);
                numItems += items[j].length;
            }
            properties = new String[numItems][2];
            numItems = 0;
            for (j = 0; j < lvl1ResultData.length; ++j) {
                String name = lvl1ResultData[j].getStoreGateKey();
                for (int i = 0; i < items[j].length; ++i) {
                    properties[numItems][0] = name + ": " + items[j][i];
                    properties[numItems][1] = prescales[j] != null && i < prescales[j].length ? prescales[j][i] : "N/A";
                    ++numItems;
                }
            }
        }
        this.eventFilterTable = new JTable(properties, new String[]{"Item passed", "Prescale"});
        this.eventFilterTable.setRowHeight(20);
        this.eventFilterTable.setFont(new Font("Monospaced", 0, 16));
        this.eventFilterTable.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.eventFilterTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        return properties;
    }

    private void fillTrigInfoItemsPane(ATriggerInfoData triggerInfoData) {
        Object[][] properties;
        if (triggerInfoData == null) {
            properties = new String[1][3];
            properties[0][0] = "N/A";
            properties[0][1] = "N/A";
            properties[0][2] = "N/A";
        } else {
            String[] itemsL1 = triggerInfoData.getTrigInfoL1SplitHex(0);
            String[] itemsL2 = triggerInfoData.getTrigInfoL2SplitHex(0);
            String[] itemsEF = triggerInfoData.getTrigInfoEFSplitHex(0);
            int items = Math.max(Math.max(itemsL1.length, itemsL2.length), itemsEF.length);
            properties = new String[items][3];
            for (int i = 0; i < items; ++i) {
                properties[i][0] = i < itemsL1.length ? itemsL1[i] : "";
                properties[i][1] = i < itemsL2.length ? itemsL2[i] : "";
                properties[i][2] = i < itemsEF.length ? itemsEF[i] : "";
            }
        }
        this.trigInfoItemsTable = new JTable(properties, new String[]{"L1", "L2", "EF"});
        this.trigInfoItemsTable.setRowHeight(20);
        this.trigInfoItemsTable.setFont(new Font("Monospaced", 0, 16));
        this.trigInfoItemsTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.trigInfoItemsTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.trigInfoItemsTable.getColumnModel().getColumn(1).setPreferredWidth(100);
    }

    private void fillTrigInfoStreamPane(ATriggerInfoData triggerInfoData) {
        Object[][] properties;
        if (triggerInfoData == null) {
            properties = new String[1][1];
            properties[0][0] = "N/A";
        } else {
            String[] items = triggerInfoData.getTrigInfoStreamTagSplit(0);
            properties = new String[items.length][1];
            for (int i = 0; i < items.length; ++i) {
                properties[i][0] = items[i];
            }
        }
        this.trigInfoStreamTable = new JTable(properties, new String[]{"Stream Tag"});
        this.trigInfoStreamTable.setRowHeight(20);
        this.trigInfoStreamTable.setFont(new Font("Monospaced", 0, 16));
        this.trigInfoStreamTable.getColumnModel().getColumn(0).setPreferredWidth(450);
    }

    private void fillUserSelectedPane(String[][] L1_items, String[][] L2_items, String[][] EF_items) {
        Object[][] properties;
        if (USER_ITEMS == null) {
            properties = new String[1][2];
            properties[0][0] = "Please add items to: epusti.csv";
            properties[0][1] = "N/A";
        } else {
            int i;
            int j;
            int i2;
            Vector<String> v_c1 = new Vector<String>();
            Vector<String> v_c2 = new Vector<String>();
            Vector<String> v_u = new Vector<String>();
            for (i2 = 0; i2 < USER_ITEMS.length; ++i2) {
                v_u.add(USER_ITEMS[i2]);
            }
            for (j = 0; j < L1_items.length; ++j) {
                for (i = 0; i < v_u.size(); ++i) {
                    if (!v_u.elementAt(i).equals(L1_items[j][0])) continue;
                    v_c1.add(L1_items[j][0]);
                    v_c2.add(L1_items[j][1]);
                    v_u.remove(i);
                }
            }
            if (v_u.size() > 0) {
                for (j = 0; j < L2_items.length; ++j) {
                    for (i = 0; i < v_u.size(); ++i) {
                        if (!v_u.elementAt(i).equals(L2_items[j][0])) continue;
                        v_c1.add(L2_items[j][0]);
                        v_c2.add(L2_items[j][1]);
                        v_u.remove(i);
                    }
                }
            }
            if (v_u.size() > 0) {
                for (j = 0; j < EF_items.length; ++j) {
                    for (i = 0; i < v_u.size(); ++i) {
                        if (!v_u.elementAt(i).equals(EF_items[j][0])) continue;
                        v_c1.add(EF_items[j][0]);
                        v_c2.add(EF_items[j][1]);
                        v_u.remove(i);
                    }
                }
            }
            properties = new String[v_c1.size()][2];
            for (i2 = 0; i2 < v_c1.size(); ++i2) {
                properties[i2][0] = v_c1.elementAt(i2).toString();
                properties[i2][1] = v_c2.elementAt(i2).toString();
            }
        }
        this.userSelectedTable = new JTable(properties, new String[]{"Item passed", "Prescale"});
        this.userSelectedTable.setRowHeight(20);
        this.userSelectedTable.setFont(new Font("Monospaced", 0, 16));
        this.userSelectedTable.getColumnModel().getColumn(0).setPreferredWidth(350);
        this.userSelectedTable.getColumnModel().getColumn(1).setPreferredWidth(100);
    }

    private void fillmbtsPane() {
        Object[][] properties;
        AData calorimeter = null;
        List detectors = Atlantis.getEventManager().getCurrentEvent().getCalorimeters();
        for (int det = 0; det < detectors.size(); ++det) {
            ACalorimeterData testcalorimeter = (ACalorimeterData)detectors.get(det);
            if (!testcalorimeter.getName().equals("MBTS") || testcalorimeter.getNumData() <= 0) continue;
            calorimeter = testcalorimeter;
        }
        if (calorimeter == null) {
            properties = new String[1][5];
            properties[0][0] = "N/A";
            properties[0][1] = "N/A";
            properties[0][2] = "N/A";
            properties[0][3] = "N/A";
            properties[0][4] = "N/A";
        } else {
            properties = new String[calorimeter.getNumData()][5];
            for (int i = 0; i < calorimeter.getNumData(); ++i) {
                properties[i][0] = "" + i;
                properties[i][1] = "" + AMath.d2s(((ACalorimeterData)calorimeter).getET(i), 3);
                properties[i][2] = "" + AMath.d2s(((ACalorimeterData)calorimeter).getEta(i), 1);
                properties[i][3] = "" + AMath.d2s(((ACalorimeterData)calorimeter).getPhi(i), 1);
                properties[i][4] = "" + ((ACalorimeterData)calorimeter).getSampling(i);
            }
        }
        this.mbtsTable = new JTable(properties, new String[]{"Index", "Energy (MeV)", "Type", "Module", "Channel"});
        this.mbtsTable.setRowHeight(20);
        this.mbtsTable.setFont(new Font("Monospaced", 0, 16));
        this.mbtsTable.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.mbtsTable.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.mbtsTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.mbtsTable.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.mbtsTable.getColumnModel().getColumn(4).setPreferredWidth(90);
    }

    public void newEvent(AEvent event) {
        if (AEventPropertiesDialog.isInUse()) {
            this.updatePane();
        }
    }
}

