/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.event.AEventSource;
import atlantis.gui.AGUI;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.interactions.AModifier;
import atlantis.parameters.APar;
import atlantis.utils.ALogger;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;

public class AEventQueue
extends EventQueue {
    private static int keyboardState;
    private static AModifier defInt;
    private KeyEvent keyEvent;
    private static final ALogger logger;
    private static boolean isRightMouseButton;

    public static int getKeyboardState() {
        int ret = 0;
        ret = keyboardState == 0 ? defInt.getKeyCode() : keyboardState;
        if (ret == 70) {
            APar.get("Projection", "SkipData").setStatus(true);
        } else {
            APar.get("Projection", "SkipData").setStatus(false);
        }
        return ret;
    }

    public static AModifier getDefault() {
        return defInt;
    }

    public static void setDefault(AModifier mod) {
        defInt = mod;
    }

    public static int getKeyboardDefault() {
        return defInt.getKeyCode();
    }

    public static boolean getIntRightMouseButton() {
        if (keyboardState == 0) {
            return defInt.getRightClick() || isRightMouseButton;
        }
        return isRightMouseButton;
    }

    public static boolean getRightMouseButton() {
        return isRightMouseButton;
    }

    protected void dispatchEvent(AWTEvent event) {
        super.dispatchEvent(event);
        if (event instanceof KeyEvent) {
            this.keyEvent = (KeyEvent)event;
            switch (this.keyEvent.getID()) {
                case 401: {
                    String msg;
                    if (this.keyEvent.getKeyCode() == 17) {
                        isRightMouseButton = true;
                        return;
                    }
                    keyboardState = this.keyEvent.getKeyCode();
                    if (this.keyEvent.getKeyCode() == 33) {
                        System.out.println("Go to previous event");
                        try {
                            Atlantis.getEventManager().previousEvent();
                        }
                        catch (AEventSource.NoMoreEventsException nme) {
                            msg = "Already at first event from this source!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                            logger.warn(nme.getCauseMessages());
                        }
                        catch (AEventSource.InvalidEventSourceException ies) {
                            msg = "Not a valid event source - please select one!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                            logger.warn(ies.getCauseMessages());
                        }
                        catch (AEventSource.ReadEventException ree) {
                            msg = "Can not read event(s)!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                            logger.warn(ree.getCauseMessages());
                        }
                    }
                    if (this.keyEvent.getKeyCode() == 34) {
                        System.out.println("Go to next event");
                        try {
                            Atlantis.getEventManager().nextEvent();
                        }
                        catch (AEventSource.NoMoreEventsException nme) {
                            msg = "Already at last event from this source!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                            logger.warn(nme.getCauseMessages());
                        }
                        catch (AEventSource.InvalidEventSourceException ies) {
                            msg = "Not a valid event source - please select one!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                            logger.warn(ies.getCauseMessages());
                        }
                        catch (AEventSource.ReadEventException ree) {
                            msg = "Can not read event(s)!";
                            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                            logger.warn(ree.getCauseMessages());
                        }
                    }
                    if (this.keyEvent.getKeyCode() != 70) break;
                    APar.get("Projection", "SkipData").setStatus(true);
                    break;
                }
                case 402: {
                    if (this.keyEvent.getKeyCode() == 17) {
                        isRightMouseButton = false;
                        return;
                    }
                    keyboardState = 0;
                    if (this.keyEvent.getKeyCode() != 70) break;
                    APar.get("Projection", "SkipData").setStatus(false);
                    ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
                }
            }
        }
    }

    static {
        defInt = new AModifier(0, false, "");
        logger = ALogger.getLogger(AGUI.class);
    }
}

