/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.config.ADefaultValues;
import atlantis.event.AEventSource;
import atlantis.event.ANewEventSourceListener;
import atlantis.event.AStreamedEventSource;
import atlantis.gui.AGUI;
import atlantis.gui.AReadFileChooser;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AEventSourceToolBar
extends JToolBar
implements ANewEventSourceListener {
    private JTextField addressBar;
    private JComboBox eventStreamComboBox;
    private JRadioButton randomButton;
    private JRadioButton sequentialButton;
    private JRadioButton loopButton;
    private static final ALogger logger = ALogger.getLogger(AGUI.class);

    public AEventSourceToolBar() {
        String iconPath = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR;
        ImageIcon openIcon = AUtilities.getFileAsImageIcon(iconPath + "toolbar_open.png");
        JButton openFile = new JButton(openIcon);
        openFile.setVerticalTextPosition(3);
        openFile.setHorizontalTextPosition(0);
        openFile.setMargin(new Insets(0, 0, 0, 0));
        openFile.setToolTipText("Open local file");
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.openFileButtonAction();
            }
        });
        this.add(openFile);
        this.addressBar = new JTextField(30);
        this.addressBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.addressBarAction((JTextField)e.getSource());
            }
        });
        this.add(this.addressBar);
        ImageIcon nextIcon = AUtilities.getFileAsImageIcon(iconPath + "toolbar_next.png");
        ImageIcon previousIcon = AUtilities.getFileAsImageIcon(iconPath + "toolbar_previous.png");
        JButton nextButton = new JButton(nextIcon);
        JButton previousButton = new JButton(previousIcon);
        nextButton.setVerticalTextPosition(3);
        nextButton.setHorizontalTextPosition(0);
        nextButton.setMargin(new Insets(0, 0, 0, 0));
        nextButton.setToolTipText("Next event (PageDown)");
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.nextButtonAction();
            }
        });
        previousButton.setVerticalTextPosition(3);
        previousButton.setHorizontalTextPosition(0);
        previousButton.setMargin(new Insets(0, 0, 0, 0));
        previousButton.setToolTipText("Previous event (PageUp)");
        previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.previousButtonAction();
            }
        });
        this.add(previousButton);
        this.add(nextButton);
        this.addSeparator();
        String[] streamNames = new String[]{"--n/a--"};
        this.eventStreamComboBox = new JComboBox<String>(streamNames);
        this.eventStreamComboBox.setVisible(false);
        this.add(this.eventStreamComboBox);
        ImageIcon sequentialIcon = AUtilities.getFileAsImageIcon(iconPath + "mode_sequential.png");
        ImageIcon loopIcon = AUtilities.getFileAsImageIcon(iconPath + "mode_loop.png");
        ImageIcon randomIcon = AUtilities.getFileAsImageIcon(iconPath + "mode_random.png");
        ImageIcon sequentialIconOn = AUtilities.getFileAsImageIcon(iconPath + "mode_sequential_on.png");
        ImageIcon loopIconOn = AUtilities.getFileAsImageIcon(iconPath + "mode_loop_on.png");
        ImageIcon randomIconOn = AUtilities.getFileAsImageIcon(iconPath + "mode_random_on.png");
        ButtonGroup group = new ButtonGroup();
        this.sequentialButton = new JRadioButton(sequentialIcon);
        this.sequentialButton.setSelectedIcon(sequentialIconOn);
        this.sequentialButton.setToolTipText("Sequential mode");
        this.loopButton = new JRadioButton(loopIcon);
        this.loopButton.setSelectedIcon(loopIconOn);
        this.loopButton.setToolTipText("Loop mode");
        this.randomButton = new JRadioButton(randomIcon);
        this.randomButton.setSelectedIcon(randomIconOn);
        this.randomButton.setToolTipText("Random mode");
        this.sequentialButton.setEnabled(false);
        this.loopButton.setEnabled(false);
        this.randomButton.setEnabled(false);
        this.sequentialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.navigationModeAction(AEventSource.NavigationMode.SEQUENTIAL);
            }
        });
        this.loopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.navigationModeAction(AEventSource.NavigationMode.LOOP);
            }
        });
        this.randomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventSourceToolBar.this.navigationModeAction(AEventSource.NavigationMode.RANDOM);
            }
        });
        group.add(this.sequentialButton);
        group.add(this.loopButton);
        group.add(this.randomButton);
        this.add(this.sequentialButton);
        this.add(this.loopButton);
        this.add(this.randomButton);
    }

    private synchronized void addressBarAction(JTextField tf) {
        String sourceName = tf.getText();
        if (!sourceName.contains("://")) {
            sourceName = "file://" + sourceName;
        }
        try {
            Atlantis.getEventManager().setEventSource(sourceName);
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.NoMoreEventsException nme) {
            JOptionPane.showMessageDialog(this, "No more events found from this source!", "No more events", 0);
            logger.warn(nme.getCauseMessages());
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            JOptionPane.showMessageDialog(this, "Not a valid event source: " + sourceName, "Invalid event source", 0);
            logger.error(ies.getCauseMessages());
        }
        catch (AEventSource.ReadEventException ree) {
            JOptionPane.showMessageDialog(this, "Cannot read event(s).", "Read error", 0);
            logger.warn(ree.getCauseMessages());
        }
    }

    private synchronized void previousButtonAction() {
        try {
            Atlantis.getEventManager().previousEvent();
        }
        catch (AEventSource.NoMoreEventsException nme) {
            String msg = "Already at first event from this source!";
            JOptionPane.showMessageDialog(this, msg, "No more events", 0);
            logger.warn(nme.getCauseMessages());
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Not a valid event source - please select one!";
            JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
            logger.warn(ies.getCauseMessages());
        }
        catch (AEventSource.ReadEventException ree) {
            String msg = "Can not read event(s)!";
            JOptionPane.showMessageDialog(this, msg, "Read error", 0);
            logger.warn(ree.getCauseMessages());
        }
    }

    private synchronized void nextButtonAction() {
        try {
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.NoMoreEventsException nme) {
            String msg = "Already at last event from this source!";
            JOptionPane.showMessageDialog(this, msg, "No more events", 0);
            logger.warn(nme.getCauseMessages());
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Not a valid event source - please select one!";
            JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
            logger.warn(ies.getCauseMessages());
        }
        catch (AEventSource.ReadEventException ree) {
            String msg = "Can not read event(s)!";
            JOptionPane.showMessageDialog(this, msg, "Read error", 0);
            logger.warn(ree.getCauseMessages());
        }
    }

    private synchronized void openFileButtonAction() {
        String lastLoc = ADefaultValues.get("LastEventFilesSourceDir");
        AReadFileChooser fileDialog = new AReadFileChooser(lastLoc);
        if (fileDialog.showOpenDialog(null) == 0) {
            String fullFilePath = "file://" + fileDialog.getSelectedFile().getPath();
            try {
                if (!fileDialog.getSelectedFile().getPath().equals("")) {
                    ADefaultValues.set("LastEventFilesSourceDir", fileDialog.getSelectedFile().getPath());
                }
                Atlantis.getEventManager().setEventSource(fullFilePath);
                Atlantis.getEventManager().nextEvent();
            }
            catch (AEventSource.NoMoreEventsException nme) {
                String msg = "No events found from this source!";
                JOptionPane.showMessageDialog(this, msg, "No more events", 0);
                logger.warn(nme.getCauseMessages());
            }
            catch (AEventSource.InvalidEventSourceException ies) {
                String msg = "Not a valid event source";
                JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
                logger.warn(ies.getCauseMessages());
            }
            catch (AEventSource.ReadEventException ree) {
                String msg = "Can not read event(s)";
                JOptionPane.showMessageDialog(this, msg, "Read error", 0);
                logger.warn(ree.getCauseMessages());
            }
        }
    }

    private synchronized void navigationModeAction(AEventSource.NavigationMode mode) {
        try {
            Atlantis.getEventManager().setNavigationMode(mode);
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            JOptionPane.showMessageDialog(this, ies.getCauseMessages(), "Invalid navigation mode", 0);
        }
    }

    private synchronized void selectedStreamAction(AStreamedEventSource source) {
        String stream = (String)this.eventStreamComboBox.getSelectedItem();
        try {
            source.setStream(stream);
            Atlantis.getEventManager().nextEvent();
            this.addressBar.setText(source.getSourceName());
        }
        catch (AEventSource.NoMoreEventsException nme) {
        }
        catch (AStreamedEventSource.InvalidStreamException ise) {
            String msg = "Cannot set stream '" + stream + "' for event source";
            JOptionPane.showMessageDialog(this, msg, "Invalid stream", 0);
            logger.error(msg + "\n" + ise.getCauseMessages());
            this.eventStreamComboBox.removeAllItems();
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Invalid event source when setting new stream";
            JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
            logger.error(msg + "\n" + ies.getCauseMessages());
            this.eventStreamComboBox.removeAllItems();
        }
        catch (AEventSource.ReadEventException ree) {
            String msg = "Can not read event from new stream '" + stream + "'";
            JOptionPane.showMessageDialog(this, msg, "Invalid event", 0);
            logger.error(msg + "\n" + ree.getCauseMessages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateEventStreamCombo(AStreamedEventSource eventSource) {
        Vector<Object> streamNames = new Vector();
        try {
            streamNames = eventSource.getAvailableStreams();
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Invalid event source when getting stream list";
            logger.error(msg + "\n" + ies.getCauseMessages());
        }
        finally {
            DefaultComboBoxModel newDataModel = new DefaultComboBoxModel(streamNames);
            newDataModel.setSelectedItem(this.eventStreamComboBox.getSelectedItem());
            this.eventStreamComboBox.setModel(newDataModel);
        }
    }

    public synchronized void newEventSource(final AEventSource eventSource) {
        this.eventStreamComboBox.setVisible(false);
        if (eventSource instanceof AStreamedEventSource) {
            AStreamedEventSource streamedSource = (AStreamedEventSource)eventSource;
            this.updateEventStreamCombo(streamedSource);
            for (ActionListener actionListener : this.eventStreamComboBox.getActionListeners()) {
                this.eventStreamComboBox.removeActionListener(actionListener);
            }
            for (EventListener eventListener : this.eventStreamComboBox.getPopupMenuListeners()) {
                this.eventStreamComboBox.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            try {
                this.eventStreamComboBox.setSelectedItem(((AStreamedEventSource)eventSource).getStream());
            }
            catch (AEventSource.InvalidEventSourceException ies) {
                String msg = "Invalid event source when getting stream list";
                JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
                logger.error(msg + "\n" + ies.getCauseMessages());
            }
            catch (AEventSource.NoMoreEventsException nme) {
                String msg = "No streams (yet) available for this source";
                JOptionPane.showMessageDialog(this, msg, "Invalid source", 0);
                logger.error(msg + "\n" + nme.getCauseMessages());
            }
            this.eventStreamComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AEventSourceToolBar.this.selectedStreamAction((AStreamedEventSource)eventSource);
                }
            });
            this.eventStreamComboBox.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AEventSourceToolBar.this.updateEventStreamCombo((AStreamedEventSource)eventSource);
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.eventStreamComboBox.setVisible(true);
        }
        this.repaint();
        this.sequentialButton.setEnabled(false);
        this.loopButton.setEnabled(false);
        this.randomButton.setEnabled(false);
        if (eventSource.supportsNavigationMode(AEventSource.NavigationMode.SEQUENTIAL)) {
            if (eventSource.getNavigationMode() == AEventSource.NavigationMode.SEQUENTIAL) {
                this.sequentialButton.setSelected(true);
            }
            this.sequentialButton.setEnabled(true);
        }
        if (eventSource.supportsNavigationMode(AEventSource.NavigationMode.LOOP)) {
            if (eventSource.getNavigationMode() == AEventSource.NavigationMode.LOOP) {
                this.loopButton.setSelected(true);
            }
            this.loopButton.setEnabled(true);
        }
        if (eventSource.supportsNavigationMode(AEventSource.NavigationMode.RANDOM)) {
            if (eventSource.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
                this.randomButton.setSelected(true);
            }
            this.randomButton.setEnabled(true);
        }
        this.addressBar.setText(eventSource.getSourceName());
    }

    public void updateToolBarEventName(String eventSource) {
        this.addressBar.setText(eventSource);
    }
}

