/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.gui.ADemoDialog;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AOutput;
import javax.swing.JOptionPane;

public class AExceptionHandler {
    public void handle(Throwable exception) {
        AExceptionHandler.processException("AWT Event Dispatch Thread Exception:", exception);
    }

    public static void processException(String message, Throwable exception) {
        exception.printStackTrace();
        AExceptionHandler.showMessageDialog(message);
    }

    public static void processException(String type, String message) {
        if (type.equals("fatal")) {
            AExceptionHandler.showMessageDialog(type + ": " + message + "\n");
            System.exit(1);
        }
        if (type.equals("warning")) {
            AExceptionHandler.showMessageDialog(type + ": " + message + "\n");
        }
        AOutput.append(type + ": " + message + "\n", "BAD_COMMAND");
    }

    private static void showMessageDialog(String message) {
        if (Atlantis.isAtlantisHeadless()) {
            return;
        }
        if (ADemoDialog.getInstance().isRunning()) {
            return;
        }
        JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), message, "Atlantis", 0);
    }
}

