/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.config.ADefaultValues;
import atlantis.event.AEventSource;
import atlantis.gui.AAnimationControl;
import atlantis.gui.AClosingConfirmationDialog;
import atlantis.gui.AEventLoopDialog;
import atlantis.gui.AEventPropertiesDialog;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AReadFileChooser;
import atlantis.gui.AReadGeometryChooser;
import atlantis.gui.ASaveCanvasDialog;
import atlantis.hypatia.HExtensionFileFilter;
import atlantis.hypatia.HInvariantMassWindow;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.ALogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class AFileControl
extends JMenu {
    private static ALogger logger = ALogger.getLogger(AFileControl.class);

    public AFileControl() {
        super("File");
        this.add("Read Event Locally").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AFileControl.readEventLocally();
            }
        });
        this.add("Read Event From URL (live)").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AFileControl.readEventFromURL();
            }
        });
        this.add(new JSeparator());
        this.add("Clear Hypatia Project").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HInvariantMassWindow.clearInvariantMassTable();
            }
        });
        this.add("Load Hypatia Project").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                HExtensionFileFilter filter = new HExtensionFileFilter();
                filter.addExtension(".hyp");
                filter.setDescription("Hypatia files");
                chooser.setFileFilter(filter);
                int result = chooser.showOpenDialog(AFileControl.this);
                if (result == 0) {
                    try {
                        String name = chooser.getSelectedFile().getPath();
                        BufferedReader in = new BufferedReader(new FileReader(name));
                        HInvariantMassWindow.loadHypatiaProject(in);
                        in.close();
                        AExceptionHandler.processException("info", "Hypatia project was loaded.");
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.add("Save Hypatia Project").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HInvariantMassWindow.getData().size() > 0) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setCurrentDirectory(new File("."));
                    HExtensionFileFilter filter = new HExtensionFileFilter();
                    filter.addExtension(".hyp");
                    filter.setDescription("Hypatia files");
                    chooser.setFileFilter(filter);
                    int result = chooser.showSaveDialog(AFileControl.this);
                    if (result == 0) {
                        try {
                            String name = chooser.getSelectedFile().getPath();
                            if (!name.contains(".hyp")) {
                                name = name + ".hyp";
                            }
                            BufferedWriter out = new BufferedWriter(new FileWriter(name));
                            HInvariantMassWindow.saveHypatiaProject(out);
                            out.close();
                            AExceptionHandler.processException("info", "Hypatia project was saved.");
                        }
                        catch (IOException exception) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    AExceptionHandler.processException("warning", "Hypatia Invariant Mass Table is empty.");
                }
            }
        });
        this.add(new JSeparator());
        this.add("Loop over events").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventLoopDialog.getInstance().showDialog();
            }
        });
        this.add(new JSeparator());
        this.add("Save Image of Canvas").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ASaveCanvasDialog dialog = new ASaveCanvasDialog();
                dialog.showDialog();
            }
        });
        this.add("Animated Event").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AAnimationControl();
            }
        });
        this.add(new JSeparator());
        this.add("Event Properties").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEventPropertiesDialog.getInstance().setVisible(true);
            }
        });
        this.add(new JSeparator());
        this.add("Read Geometry").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AReadGeometryChooser();
            }
        });
        if (logger.isDebugEnabled()) {
            this.add("Memory information").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("\nMemory information:");
                    System.gc();
                    long total = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    long max = Runtime.getRuntime().maxMemory();
                    int fac = 0x100000;
                    System.out.println(" total: " + total + " B  " + total / (long)fac + " MB");
                    System.out.println(" free : " + free + " B  " + free / (long)fac + " MB");
                    System.out.println(" max  : " + max + " B  " + max / (long)fac + " MB");
                }
            });
        }
        this.add(new JSeparator());
        this.add("Exit").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AClosingConfirmationDialog(HTrackMomentaWindow.getGUI()).exitApp();
            }
        });
    }

    private static void readEventLocally() {
        String lastLoc = ADefaultValues.get("LastEventFilesSourceDir");
        AReadFileChooser fileDialog = new AReadFileChooser(lastLoc);
        if (fileDialog.showOpenDialog(HTrackMomentaWindow.getGUI()) == 0) {
            String fullFilePath = "file://" + fileDialog.getSelectedFile().getPath();
            try {
                if (!fileDialog.getSelectedFile().getPath().equals("")) {
                    ADefaultValues.set("LastEventFilesSourceDir", fileDialog.getSelectedFile().getPath());
                }
                Atlantis.getEventManager().setEventSource(fullFilePath);
                Atlantis.getEventManager().nextEvent();
            }
            catch (AEventSource.NoMoreEventsException nme) {
                String msg = "No events found from this source!";
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                logger.warn(nme.getCauseMessages());
            }
            catch (AEventSource.InvalidEventSourceException ies) {
                String msg = "Not a valid event source";
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                logger.warn(ies.getCauseMessages());
            }
            catch (AEventSource.ReadEventException ree) {
                String msg = "Can not read event(s)";
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                logger.warn(ree.getCauseMessages());
            }
        }
    }

    private static void readEventFromURL() {
        String urlString = JOptionPane.showInputDialog(HTrackMomentaWindow.getGUI(), "Enter URL:", "http://atlas-live.cern.ch/event_files/Default");
        if (urlString == null || urlString.trim().length() == 0) {
            return;
        }
        try {
            Atlantis.getEventManager().setEventSource(urlString);
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.NoMoreEventsException nme) {
            String msg = "No events found from this source!";
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
            logger.warn(nme.getCauseMessages());
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Not a valid event source";
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
            logger.warn(ies.getCauseMessages());
        }
        catch (AEventSource.ReadEventException ree) {
            String msg = "Can not read event(s)";
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
            logger.warn(ree.getCauseMessages());
        }
    }
}

