/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class AFlowLayout
implements LayoutManager {
    private int hgap;
    private int vgap;

    public AFlowLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public Dimension preferredLayoutSize(Container target) {
        Insets insets = target.getInsets();
        Dimension D = target.getSize();
        int W = D.width - insets.left - insets.right;
        int L = this.hgap;
        int y = this.vgap;
        int hmax = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Dimension d = target.getComponent(i).getPreferredSize();
            int w = d.width;
            int h = d.height;
            if (L + w + this.hgap < W) {
                L += w + this.hgap;
                if (h <= hmax) continue;
                hmax = h;
                continue;
            }
            L = this.hgap + w + this.hgap;
            y += hmax + this.vgap;
            hmax = 0;
            if (h <= hmax) continue;
            hmax = h;
        }
        if (target.getComponentCount() > 0) {
            y += hmax + this.vgap;
        }
        return new Dimension(W, y);
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension D = target.getSize();
        int W = D.width - insets.left - insets.right;
        int L = this.hgap;
        int y = this.vgap;
        int from = 0;
        int to = 0;
        int hmax = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Dimension d = target.getComponent(i).getPreferredSize();
            int w = d.width;
            int h = d.height;
            if (L + w + this.hgap < W) {
                L += w + this.hgap;
                to = i;
                if (h <= hmax) continue;
                hmax = h;
                continue;
            }
            this.layout(target, this.hgap + insets.left + (W / 2 - L / 2), y, from, to);
            L = this.hgap + w + this.hgap;
            from = i;
            to = i;
            y += hmax + this.vgap;
            hmax = 0;
            if (h <= hmax) continue;
            hmax = h;
        }
        if (target.getComponentCount() > 0) {
            this.layout(target, this.hgap + insets.left + (W / 2 - L / 2), y, from, to);
        }
    }

    public void layout(Container target, int x, int y, int from, int to) {
        int xi = x;
        for (int i = from; i <= to; ++i) {
            Component comp = target.getComponent(i);
            Dimension d = comp.getPreferredSize();
            comp.setBounds(xi, y, d.width, d.height);
            xi += d.width + this.hgap;
        }
    }
}

