/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.ALayoutChangeListener;
import atlantis.canvas.AWindow;
import atlantis.event.AEventSource;
import atlantis.gui.AClosingConfirmationDialog;
import atlantis.gui.ADemoDialog;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.gui.AEventSourceToolBar;
import atlantis.gui.AFileControl;
import atlantis.gui.AGUILayoutManager;
import atlantis.gui.AHelpControl;
import atlantis.gui.AHelpSystem;
import atlantis.gui.AInteractionToolBar;
import atlantis.gui.AItemTabbedPane;
import atlantis.gui.AListsControl;
import atlantis.gui.AParametersPage;
import atlantis.gui.APasswordDialog;
import atlantis.gui.APreferencesControl;
import atlantis.gui.AWindowControl;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACommandProcessor;
import atlantis.parameters.APar;
import atlantis.parameters.AParametersGroup;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.Authenticator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AGUI
extends JFrame
implements ChangeListener,
ALayoutChangeListener {
    private static final ALogger logger = ALogger.getLogger(AGUI.class);
    private static AItemTabbedPane[] tabbedPane;
    private static AParametersPage[][] pages;
    private static AParametersGroup[][] groups;
    private static ChangeListener[] tabChangeListener;
    private static ChangeListener outerTabChangeListener;
    private static AGUI instance;
    private static JPanel panel;
    private static JSplitPane split;
    private static JTabbedPane outerTabbedPane;
    private static AInteractionToolBar interactionToolBar;

    public static AGUI getGUI() {
        if (Atlantis.isAtlantisHeadless()) {
            return null;
        }
        if (instance == null) {
            instance = new AGUI();
        }
        return instance;
    }

    private AGUI() {
        super("Atlantis GUI");
        logger.debug("Creating GUI...");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new AClosingConfirmationDialog(this));
        this.getContentPane().setLayout(new BorderLayout());
        AUtilities.setIconImage(this);
        JMenuBar menuBar = this.constructAndGetMenuBar();
        this.setJMenuBar(menuBar);
        AEventSourceToolBar toolBar = new AEventSourceToolBar();
        this.add((Component)toolBar, "First");
        Atlantis.getEventManager().addNewEventSourceListener(toolBar);
        panel = new JPanel(new AGUILayoutManager());
        panel.add((Component)new AWindowControl(), AGUILayoutManager.AVAILABLExPREFERRED);
        groups = APar.getUIGroups();
        pages = new AParametersPage[groups.length][];
        tabbedPane = new AItemTabbedPane[groups.length];
        tabChangeListener = new TabChangeListener[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            AGUI.pages[i] = new AParametersPage[groups[i].length];
            AGUI.tabbedPane[i] = new AItemTabbedPane(2);
            for (int j = 0; j < groups[i].length; ++j) {
                AGUI.pages[i][j] = new AParametersPage(groups[i][j]);
                tabbedPane[i].addTab(groups[i][j].getScreenName(), null, pages[i][j], groups[i][j].getToolTip());
                if (!groups[i][j].getScreenName().equals("Residual") && !groups[i][j].getScreenName().equals("Physics")) continue;
                tabbedPane[i].setEnabledAt(tabbedPane[i].getTabCount() - 1, false);
            }
            tabbedPane[i].setSelectedIndex(-1);
            AGUI.tabChangeListener[i] = new TabChangeListener();
            tabbedPane[i].addChangeListener(tabChangeListener[i]);
            tabbedPane[i].addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (AUtilities.isRightMouseButton(e)) {
                        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                        int tab = tabbedPane.getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY());
                        int parentTab = ((JTabbedPane)tabbedPane.getParent()).getSelectedIndex();
                        if (tab != -1) {
                            String helpName = groups[parentTab][tab].getGroupName();
                            AHelpSystem.getInstance().showPage(helpName);
                        }
                    }
                }
            });
        }
        outerTabbedPane = new AItemTabbedPane(1);
        String[] superGroups = APar.getUISuperGroups();
        String[] superGroupTips = APar.getUISuperGroupTips();
        for (int i = 0; i < superGroups.length; ++i) {
            outerTabbedPane.addTab(superGroups[i], null, tabbedPane[i], superGroupTips[i]);
        }
        outerTabChangeListener = new OuterTabChangeListener();
        outerTabbedPane.addChangeListener(outerTabChangeListener);
        outerTabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JTabbedPane tabbedPane;
                int tab;
                if (AUtilities.isRightMouseButton(e) && (tab = (tabbedPane = (JTabbedPane)e.getSource()).getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY())) != -1) {
                    String helpName = tabbedPane.getTitleAt(tab);
                    AHelpSystem.getInstance().showPage(helpName);
                }
            }
        });
        panel.add((Component)outerTabbedPane, AGUILayoutManager.AVAILABLExAVAILABLE);
        split = new JSplitPane(0, panel, AOutput.getOutputDisplay());
        split.setOneTouchExpandable(true);
        split.setResizeWeight(0.75);
        this.getContentPane().add(split);
        ACanvas.getCanvas().addWindowChangeListener(this);
        String[] wName = ACanvas.getCanvas().getKnownWindowNames();
        for (int i = 0; i < wName.length; ++i) {
            AWindow w = ACanvas.getCanvas().getWindow(wName[i]);
            w.addProjectionChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AWindow window = (AWindow)e.getSource();
                    if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
                        if (interactionToolBar != null) {
                            panel.remove(interactionToolBar);
                        }
                        interactionToolBar = window.getInteractionToolBar();
                        if (interactionToolBar == null) {
                            window.getInteractionManager().forgetContext();
                        } else {
                            panel.add(interactionToolBar, AGUILayoutManager.AVAILABLExPREFERRED, 0);
                            interactionToolBar.connect();
                            AGUI.this.validate();
                        }
                    }
                }
            });
            w.addGroupChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AWindow window = (AWindow)e.getSource();
                    if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
                        AGUI.setSelectedTab(window.getGroupName());
                    }
                }
            });
        }
        Authenticator.setDefault(APasswordDialog.getAuthenticator(this));
    }

    private JMenuBar constructAndGetMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new AFileControl());
        menuBar.add(new APreferencesControl());
        menuBar.add(new AListsControl());
        JButton defaults = new JButton(" Reset ");
        defaults.setToolTipText("qs");
        defaults.setBorder(null);
        defaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Atlantis.restoreDefaults();
            }
        });
        menuBar.add(defaults);
        JButton demoButton = new JButton(" Demo ");
        demoButton.setToolTipText("Start Demo mode");
        demoButton.setBorder(null);
        demoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ADemoDialog.getInstance().setVisible(true);
            }
        });
        menuBar.add(demoButton);
        JButton backButton = new JButton(" Previous ");
        backButton.setBorder(null);
        backButton.setToolTipText("Read previous event (PageUp)");
        backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Atlantis.getEventManager().previousEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    String msg = "Already at first event from this source!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                    logger.warn(nme.getCauseMessages());
                }
                catch (AEventSource.InvalidEventSourceException ies) {
                    String msg = "Not a valid event source - please select one!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                    logger.warn(ies.getCauseMessages());
                }
                catch (AEventSource.ReadEventException ree) {
                    String msg = "Can not read event(s)!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                    logger.warn(ree.getCauseMessages());
                }
            }
        });
        menuBar.add(backButton);
        JButton forwardButton = new JButton(" Next ");
        forwardButton.setBorder(null);
        forwardButton.setToolTipText("Read next event (PageDown)");
        forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Atlantis.getEventManager().nextEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    String msg = "Already at last event from this source!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                    logger.warn(nme.getCauseMessages());
                }
                catch (AEventSource.InvalidEventSourceException ies) {
                    String msg = "Not a valid event source - please select one!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                    logger.warn(ies.getCauseMessages());
                }
                catch (AEventSource.ReadEventException ree) {
                    String msg = "Can not read event(s)!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                    logger.warn(ree.getCauseMessages());
                }
            }
        });
        menuBar.add(forwardButton);
        menuBar.add(new AHelpControl());
        return menuBar;
    }

    public void layoutChanged(ACanvas canvas) {
        Rectangle screenSize = canvas.getScreenSize();
        int useWidth = screenSize.width;
        if (Atlantis.MAX_WIDTH > 0 && useWidth > Atlantis.MAX_WIDTH) {
            useWidth = Atlantis.MAX_WIDTH;
        }
        Rectangle canvbound = canvas.getStartupCanvasSize();
        int guiHeight = canvbound.height;
        if (canvas.getCurrentLayout().getName().equals("FULL SCREEN")) {
            int guiWidth = useWidth / 4;
            this.setBounds(useWidth * 3 / 4, 0, guiWidth, guiHeight);
            int state = this.getExtendedState();
            this.setExtendedState(state |= 1);
        } else {
            int guiWidth = useWidth - canvbound.width - canvbound.x;
            this.setBounds(canvbound.x + canvbound.width, canvbound.y, guiWidth, guiHeight);
        }
    }

    public void stateChanged(ChangeEvent e) {
        AGUI.setSelectedTab(ACanvas.getCanvas().getCurrentWindow().getGroupName());
        if (interactionToolBar != null) {
            panel.remove(interactionToolBar);
        }
        if ((interactionToolBar = ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar()) != null) {
            panel.add(interactionToolBar, AGUILayoutManager.AVAILABLExPREFERRED, 0);
            interactionToolBar.connect();
        }
        this.validate();
    }

    private static void setSelectedTab(String newTabName) {
        block0: for (int i = 0; i < groups.length; ++i) {
            for (int j = 0; j < groups[i].length; ++j) {
                if (!groups[i][j].getGroupName().equals(newTabName)) continue;
                for (int k = 0; k < groups.length; ++k) {
                    if (k == i || tabbedPane[k].getSelectedIndex() == -1) continue;
                    tabbedPane[k].removeChangeListener(tabChangeListener[k]);
                    tabbedPane[k].setSelectedIndex(-1);
                    tabbedPane[k].addChangeListener(tabChangeListener[k]);
                }
                tabbedPane[i].removeChangeListener(tabChangeListener[i]);
                tabbedPane[i].setSelectedIndex(j);
                tabbedPane[i].addChangeListener(tabChangeListener[i]);
                outerTabbedPane.setSelectedIndex(i);
                if (AGUI.pages[i][j].pTable == null) continue block0;
                AGUI.pages[i][j].pTable.refresh();
                continue block0;
            }
        }
    }

    public static String getCurrentGroup() {
        return ACanvas.getCanvas().getCurrentWindow().getGroupName();
    }

    public static void refresh() {
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                for (int j = 0; j < groups[i].length; ++j) {
                    if (AGUI.pages[i][j].pTable == null) continue;
                    AGUI.pages[i][j].pTable.refresh();
                }
            }
        }
    }

    public static void repaintTable() {
        if (tabbedPane != null) {
            for (int i = 0; i < tabbedPane.length; ++i) {
                if (tabbedPane[i] == null) continue;
                tabbedPane[i].repaint();
            }
        }
    }

    static class TabDragListener
    implements ADragListener {
        TabDragListener() {
        }

        public void dragPerformed(Object from, Object to, int action) {
            String wName = to instanceof ADnDLabel ? ((ADnDLabel)to).getText() : (to instanceof AWindow ? ((AWindow)to).getName() : "???");
            JTabbedPane tp = (JTabbedPane)from;
            String tabName = tp.getTitleAt(tp.getSelectedIndex());
            AOutput.append("Drag of " + tabName + " into window " + wName + "\n", "COMMAND");
            APar.copyCurrentGroupLocalsTo(wName);
            ACanvas.getCanvas().getWindow(wName).repaintFromScratch();
        }
    }

    class OuterTabChangeListener
    implements ChangeListener {
        OuterTabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int parentIndex = tabbedPane.getSelectedIndex();
            if (parentIndex > -1) {
                JTabbedPane child = (JTabbedPane)tabbedPane.getSelectedComponent();
                if (child.getTabCount() == 0) {
                    child.setSelectedIndex(-1);
                } else {
                    int index = 0;
                    String name = groups[parentIndex][index].getGroupName();
                    if (groups[parentIndex][index].getUIUsage() == 2) {
                        name = ACanvas.getCanvas().getCurrentWindow().getProjection().getName();
                        for (int i = 0; i < groups[parentIndex].length; ++i) {
                            if (!groups[parentIndex][i].getGroupName().equals(name)) continue;
                            index = i;
                        }
                    }
                    ACommandProcessor.receive(name + ".");
                    pages[parentIndex][index].repaint();
                    pages[parentIndex][index].pTable.refresh();
                    if (groups[parentIndex][index].getUIUsage() == 2) {
                        AProjection p = AProjectionsManager.getProjection(name);
                        ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                    }
                }
            }
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int index = tabbedPane.getSelectedIndex();
            if (index > -1) {
                int parentIndex = ((JTabbedPane)tabbedPane.getParent()).getSelectedIndex();
                String name = groups[parentIndex][index].getGroupName();
                ACommandProcessor.receive(name + ".");
                pages[parentIndex][index].repaint();
                pages[parentIndex][index].pTable.refresh();
                if (groups[parentIndex][index].getUIUsage() == 2) {
                    AProjection p = AProjectionsManager.getProjection(name);
                    ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                }
            }
        }
    }
}

