/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.gui.ARunAnotherLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AGridLayout
implements LayoutManager2 {
    private Dimension gridSize;
    private int cellSize;
    private Dimension initialSize;
    public static final int CONSTRAINED = 0;
    public static final int PREFERRED = 1;
    private int layoutType;
    private boolean secondLayout;
    public static final String GRID_SIZE_ERROR = "Grid size must have width and height > 0.";
    public static final String ASPECT_RATIO_ERROR = "Aspect ratio must have width and height > 0.";
    public static final String CONSTRAINT_ERROR = "Constraint must be a Rectangle with positive width and height.";
    public static final String AGRID_LAYOUT_CONSTRAINT = "ConstrainedGridLayout.RectangularConstraint";

    public AGridLayout(Dimension gridSize, Dimension initialSize) {
        this.layoutType = 0;
        this.setGridSize(gridSize);
        this.secondLayout = true;
        this.initialSize = initialSize;
    }

    public AGridLayout(Dimension gridSize, int cellSize) {
        this.layoutType = 1;
        this.setGridSize(gridSize);
        this.cellSize = cellSize;
        this.secondLayout = false;
        this.initialSize = null;
    }

    private void setGridSize(Dimension gridSize) {
        if (gridSize.width <= 0 || gridSize.height <= 0 || gridSize.width > 100 || gridSize.height > 100) {
            throw new IllegalArgumentException(GRID_SIZE_ERROR);
        }
        this.gridSize = new Dimension(0, 0);
        this.gridSize.setSize(gridSize);
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setConstraints(Component comp, Rectangle constraints) {
        if (comp instanceof JComponent) {
            Rectangle copy = new Rectangle(constraints);
            JComponent jc = (JComponent)comp;
            jc.putClientProperty(AGRID_LAYOUT_CONSTRAINT, copy);
        }
    }

    public Rectangle getConstraints(Component comp) {
        JComponent jc;
        Object constraint;
        Rectangle r = null;
        if (comp instanceof JComponent && (constraint = (jc = (JComponent)comp).getClientProperty(AGRID_LAYOUT_CONSTRAINT)) instanceof Rectangle) {
            r = (Rectangle)constraint;
        }
        return r != null ? new Rectangle(r) : null;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.layoutType == 0) {
            Dimension d = parent.getSize();
            if (this.initialSize != null) {
                d = new Dimension(this.initialSize);
                this.initialSize = null;
            }
            int hCellSize = d.width / this.gridSize.width;
            int vCellSize = d.height / this.gridSize.height;
            if (ACanvas.getCanvas().getCurrentLayout().getName().equals("FULL SCREEN")) {
                return new Dimension(this.gridSize.width * hCellSize, this.gridSize.height * vCellSize);
            }
            this.cellSize = Math.min(hCellSize, vCellSize);
        }
        return new Dimension(this.gridSize.width * this.cellSize, this.gridSize.height * this.cellSize);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int hCellSize = d.width / this.gridSize.width;
        int vCellSize = d.height / this.gridSize.height;
        int compCount = parent.getComponentCount();
        for (int i = 0; i < compCount; ++i) {
            Component comp = parent.getComponent(i);
            Rectangle r = this.getConstraints(comp);
            if (r == null) continue;
            if (ACanvas.getCanvas().getCurrentLayout().getName().equals("FULL SCREEN")) {
                comp.setBounds(r.x * hCellSize, r.y * vCellSize, r.width * hCellSize, r.height * vCellSize);
                continue;
            }
            comp.setBounds(r.x * this.cellSize, r.y * this.cellSize, r.width * this.cellSize, r.height * this.cellSize);
        }
        if (this.secondLayout) {
            SwingUtilities.invokeLater(new ARunAnotherLayout(parent));
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Rectangle) {
            Rectangle r = (Rectangle)constraints;
            if (r.width <= 0 || r.height <= 0) {
                throw new IllegalArgumentException(CONSTRAINT_ERROR);
            }
            this.setConstraints(comp, r);
        } else if (constraints != null) {
            throw new IllegalArgumentException(CONSTRAINT_ERROR);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

