/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JFrame;

public class AHelpSystem
extends JFrame {
    private static ALogger logger = ALogger.getLogger(AHelpSystem.class);
    private static AHelpSystem instance = null;
    private static String hsPath = "jhelpset.hs";
    private static JHelp helpViewer = null;

    private AHelpSystem() {
        super("Atlantis Online Help");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AHelpSystem.this.dispose();
                instance = null;
            }
        });
        this.getContentPane().add((Component)helpViewer);
        this.setDefaultCloseOperation(2);
        AUtilities.setIconImage(this);
        this.setSize(900, 600);
    }

    public static AHelpSystem getInstance() {
        if (instance == null) {
            instance = new AHelpSystem();
        }
        return instance;
    }

    public void showPage(String pageName) {
        try {
            helpViewer.setCurrentID(pageName);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((int)Math.max(0.0, (screenSize.getWidth() - (double)this.getWidth()) / 2.0), (int)((screenSize.getHeight() - (double)this.getHeight()) / 3.0));
            this.setExtendedState(this.getExtendedState() & 0xFFFFFFFE);
            this.setVisible(true);
        }
        catch (BadIDException ex) {
            AOutput.alwaysAppend("\nNo help for \"" + pageName + "\", sorry.\n", "BAD_COMMAND");
        }
    }

    private static HelpSet getHelpSet(String helpSetFile) {
        HelpSet hs = null;
        ClassLoader cl = AHelpSystem.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpSetFile);
            hs = new HelpSet(cl, hsURL);
        }
        catch (Exception ee) {
            logger.error("AHelpSystem: " + ee.getMessage(), ee);
            logger.error("AHelpSystem: " + helpSetFile + " not found");
        }
        return hs;
    }

    static {
        HelpSet hs = AHelpSystem.getHelpSet(hsPath);
        helpViewer = new JHelp(hs);
        helpViewer.setCurrentID("HelpHowTo");
    }
}

