/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.gui.AHelpSystem;
import atlantis.gui.AMouseHelpDialog;
import atlantis.interactions.AInteractionGroup;
import atlantis.interactions.AInteractionsManager;
import atlantis.utils.AUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class AInteractionToolBar
extends JToolBar {
    private AInteractionsManager iManager;
    private AInteractionGroup currentGroup;
    private AInteractionGroup previousGroup;
    private JPanel controls;
    private static final String iconBasePath = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "interaction_";
    private ButtonGroup buttonGroup;
    Vector<AInteractionGroup> groups;

    public AInteractionToolBar(AInteractionsManager iManager) {
        this.setLayout(new FlowLayout());
        this.setFloatable(false);
        this.iManager = iManager;
        this.groups = new Vector();
        this.controls = new JPanel();
        this.buttonGroup = new ButtonGroup();
    }

    public AInteractionsManager getInteractionsManager() {
        return this.iManager;
    }

    public void connect() {
        this.iManager.setContext(this.getSelectedGroup());
        if (this.getSelectedGroup() != null) {
            AMouseHelpDialog.getInstance();
            AMouseHelpDialog.processInteractionChange(this.getSelectedGroup().getInteractions());
        }
    }

    public void addGroup(AInteractionGroup group, String toolTipText) {
        this.groups.addElement(group);
        final String groupName = group.getGroupName();
        String iconPath = iconBasePath + groupName.toLowerCase() + ".png";
        ImageIcon newIcon = AUtilities.getFileAsImageIcon(iconPath);
        JToggleButton newButton = new JToggleButton(newIcon);
        newButton.setName(group.getGroupName());
        newButton.setToolTipText(toolTipText);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AInteractionToolBar.this.buttonClicked(groupName);
            }
        });
        newButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JToggleButton butt;
                if (AUtilities.isRightMouseButton(e) && AInteractionToolBar.this.findGroup((butt = (JToggleButton)e.getSource()).getName()) != null) {
                    String className = AInteractionToolBar.this.findGroup(butt.getName()).getClass().getName();
                    String temp = className.substring(className.lastIndexOf(46) + ".A".length());
                    className = temp.substring(0, temp.length() - "Group".length());
                    AHelpSystem.getInstance().showPage(className);
                }
            }
        });
        this.remove(this.controls);
        this.buttonGroup.add(newButton);
        this.add(newButton);
        this.add((Component)this.controls, -1);
        this.validate();
        this.repaint();
    }

    public AInteractionGroup[] getGroups() {
        return this.groups.toArray(new AInteractionGroup[0]);
    }

    public AInteractionGroup getSelectedGroup() {
        return this.currentGroup;
    }

    public String getSelectedGroupName() {
        return this.currentGroup.getGroupName();
    }

    public void setSelectedGroup(String groupName) {
        for (AInteractionGroup iG : this.groups) {
            if (!iG.getGroupName().equals(groupName)) continue;
            for (int i = 0; i < this.groups.size(); ++i) {
                if (!(this.getComponentAtIndex(i) instanceof JToggleButton) || !this.getComponentAtIndex(i).getName().equals(groupName)) continue;
                ((JToggleButton)this.getComponentAtIndex(i)).doClick();
                return;
            }
        }
    }

    public AInteractionGroup findGroup(String screenName) {
        for (AInteractionGroup iG : this.groups) {
            if (!iG.getGroupName().equals(screenName)) continue;
            return iG;
        }
        return null;
    }

    public void setDefaultGroup() {
        if (this.groups.size() > 0) {
            this.setSelectedGroup(this.groups.elementAt(0).getGroupName());
        }
    }

    public void restorePreviousGroup() {
        if (this.previousGroup != null) {
            this.setSelectedGroup(this.previousGroup.getGroupName());
        }
    }

    public void buttonClicked(String groupName) {
        AInteractionGroup deselectedGroup = this.currentGroup;
        for (AInteractionGroup iG : this.groups) {
            int i;
            String[] wName;
            if (!iG.getGroupName().equals(groupName)) continue;
            this.iManager.setContext(iG);
            this.remove(this.controls);
            this.controls = iG.hasAdditionalControls() ? iG.getAdditionalControls() : new JPanel();
            this.add((Component)this.controls, -1);
            this.validate();
            this.repaint();
            AMouseHelpDialog.getInstance();
            AMouseHelpDialog.processInteractionChange(iG.getInteractions());
            if (this.currentGroup != null && this.currentGroup.isWindowGroup()) {
                this.previousGroup = this.currentGroup;
            }
            this.currentGroup = iG;
            if (ACanvas.getCanvas().getCurrentWindow() != null && iG.isCanvasGroup() && this.iManager.getWindow().isCurrent()) {
                wName = ACanvas.getCanvas().getCurrentLayout().getWindowNames();
                for (i = 0; i < wName.length; ++i) {
                    if (wName[i].equals(this.iManager.getWindow().getName())) continue;
                    ACanvas.getCanvas().getWindow(wName[i]).getInteractionToolBar().setSelectedGroup(iG.getGroupName());
                }
            }
            if (deselectedGroup == null || !deselectedGroup.isCanvasGroup() || !this.iManager.getWindow().isCurrent()) continue;
            wName = ACanvas.getCanvas().getCurrentLayout().getWindowNames();
            for (i = 0; i < wName.length; ++i) {
                if (wName[i].equals(this.iManager.getWindow().getName())) continue;
                ACanvas.getCanvas().getWindow(wName[i]).getInteractionToolBar().restorePreviousGroup();
            }
        }
    }
}

