/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import java.awt.Graphics;
import javax.swing.JPanel;

public abstract class ALazyPanel
extends JPanel {
    private boolean lazyConstructorCalled = false;

    public void paint(Graphics g) {
        this.callLazyConstructor();
        super.paint(g);
    }

    public void paintAll(Graphics g) {
        this.callLazyConstructor();
        super.paintAll(g);
    }

    public void paintComponents(Graphics g) {
        this.callLazyConstructor();
        super.paintComponents(g);
    }

    public void repaint() {
        this.callLazyConstructor();
        super.repaint();
    }

    public void repaint(long l) {
        this.callLazyConstructor();
        super.repaint(l);
    }

    public void repaint(int i1, int i2, int i3, int i4) {
        this.callLazyConstructor();
        super.repaint(i1, i2, i3, i4);
    }

    public void repaint(long l, int i1, int i2, int i3, int i4) {
        this.callLazyConstructor();
        super.repaint(l, i1, i2, i3, i4);
    }

    public void update(Graphics g) {
        this.callLazyConstructor();
        super.update(g);
    }

    public final synchronized void callLazyConstructor() {
        if (!this.lazyConstructorCalled && this.getParent() != null) {
            this.lazyConstructor();
            this.lazyConstructorCalled = true;
            this.validate();
        }
    }

    protected abstract void lazyConstructor();
}

