/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.AColorMap;
import atlantis.gui.APreferencesControl;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class ALegendWindow
extends JFrame
implements WindowListener {
    private static JTextField[] titleField = new JTextField[2];
    private static JTextField[] textField;
    private static ALegendWindow instance;

    public static ALegendWindow getInstance() {
        if (instance == null) {
            instance = new ALegendWindow();
        }
        return instance;
    }

    public void addEnergyText(AWindow window, double[] Energies, double Energy, Color[] colorMap) {
        if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
            this.getContentPane().removeAll();
            this.validate();
            this.getContentPane().setLayout(new GridLayout(Energies.length + titleField.length, 1));
            titleField[0].setText("Color Energy thresholds:");
            this.getContentPane().add(titleField[0]);
            if (titleField[1] == null) {
                ALegendWindow.titleField[1] = new JTextField();
            }
            titleField[1].setEditable(false);
            titleField[1].setBackground(Color.white);
            titleField[1].setForeground(Color.black);
            titleField[1].setText("Maximum Cell Energy: " + Math.rint(1000.0 * Energy) / 1000.0 + " GeV ");
            this.getContentPane().add(titleField[1]);
            String s = "";
            for (int i = Energies.length - 1; i >= 0; --i) {
                if (textField[i] == null) {
                    ALegendWindow.textField[i] = new JTextField();
                }
                textField[i].setEditable(false);
                s = i < 10 ? "0" + i : "" + i;
                s = "Color " + s + " Energy from: " + Math.rint(1000.0 * Energies[i]) / 1000.0 + " GeV";
                textField[i].setText(s);
                textField[i].setBackground(colorMap[i]);
                if (colorMap[i].getRed() + colorMap[i].getGreen() + colorMap[i].getBlue() <= 128) {
                    textField[i].setForeground(Color.white);
                } else {
                    textField[i].setForeground(Color.black);
                }
                this.getContentPane().add(textField[i]);
            }
            this.invalidate();
            this.pack();
            this.setVisible(true);
        }
    }

    public void addEnergyText(AWindow window, double minEnergy, double maxEnergy) {
        if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
            this.getContentPane().removeAll();
            this.validate();
            this.getContentPane().setLayout(new GridLayout(3, 1));
            titleField[0].setText("Color Energy thresholds:");
            this.getContentPane().add(titleField[0]);
            if (titleField[1] == null) {
                ALegendWindow.titleField[1] = new JTextField();
            }
            titleField[1].setEditable(false);
            titleField[1].setBackground(Color.white);
            titleField[1].setForeground(Color.black);
            titleField[1].setText("Maximum Cell Energy: " + Math.rint(1000.0 * maxEnergy) / 1000.0 + " GeV ");
            this.getContentPane().add(titleField[1]);
            if (textField[0] == null) {
                ALegendWindow.textField[0] = new JTextField();
            }
            textField[0].setEditable(false);
            textField[0].setText("Minimum Cell Energy: " + Math.rint(1000.0 * minEnergy) / 1000.0 + " GeV ");
            textField[0].setBackground(Color.white);
            textField[0].setForeground(Color.black);
            this.getContentPane().add(textField[0]);
            this.invalidate();
            this.pack();
            this.setVisible(true);
        }
    }

    public void clearText(AWindow window) {
        if (!titleField[0].getText().equals("Select colour by Energy to bring up scale") && window.equals(ACanvas.getCanvas().getCurrentWindow())) {
            this.getContentPane().removeAll();
            this.validate();
            this.getContentPane().setLayout(new GridLayout(1, 1));
            titleField[0].setText("Select colour by Energy to bring up scale");
            this.getContentPane().add(titleField[0]);
            this.invalidate();
            this.pack();
            this.setVisible(true);
        }
    }

    public void nothingToDisplay(AWindow window) {
        if (!titleField[0].getText().equals("Select LAr/HEC Summed and colour by Energy to bring up scale") && window.equals(ACanvas.getCanvas().getCurrentWindow())) {
            this.getContentPane().removeAll();
            this.validate();
            this.getContentPane().setLayout(new GridLayout(1, 1));
            titleField[0].setText("Select LAr/HEC Summed and colour by Energy to bring up scale");
            this.getContentPane().add(titleField[0]);
            this.invalidate();
            this.pack();
            this.setVisible(true);
        }
    }

    private ALegendWindow() {
        this.setTitle("Legend");
        AUtilities.setIconImage(this);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        int numColors = AColorMap.getNumColors();
        this.getContentPane().setLayout(new GridLayout(1, 1));
        textField = new JTextField[numColors];
        ALegendWindow.titleField[0] = new JTextField();
        titleField[0].setEditable(false);
        titleField[0].setBackground(Color.white);
        titleField[0].setForeground(Color.black);
        titleField[0].setText("Select LAr/HEC Summed and colour by Energy to bring up scale");
        this.getContentPane().add(titleField[0]);
        this.addWindowListener(this);
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        this.pack();
        this.setVisible(true);
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        APreferencesControl.setLegMenuItem(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        instance = null;
    }
}

