/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.gui.AEventQueue;
import atlantis.gui.MouseHelpRadio;
import atlantis.gui.RadioEditor;
import atlantis.gui.RadioRenderer;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AModifier;
import atlantis.utils.AUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AMouseHelpDialog
extends JFrame {
    private static JTable table;
    static Object[][] rowData;
    static Object[] columnNames;
    private static AMouseHelpDialog instance;

    private AMouseHelpDialog() {
        super("Help - Modifier Keys");
        AUtilities.setIconImage(this);
        table = new JTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 0) {
                    return new RadioRenderer();
                }
                return super.getCellRenderer(row, column);
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 0) {
                    return new RadioEditor();
                }
                return super.getCellEditor(row, column);
            }
        };
        table.setRowHeight(20);
        table.setFont(new Font("Monospaced", 0, table.getFont().getSize()));
        table.setRowSelectionAllowed(false);
        this.getContentPane().add((Component)table.getTableHeader(), "North");
        this.getContentPane().add((Component)table, "Center");
        this.setResizable(false);
        try {
            Class[] cargs = new Class[]{Boolean.TYPE};
            Method thm = this.getClass().getMethod("setAlwaysOnTop", cargs);
            Object[] oargs = new Object[]{Boolean.TRUE};
            thm.invoke((Object)this, oargs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AEventQueue.setDefault(AModifier.nothing);
            }
        });
        this.pack();
    }

    public static AMouseHelpDialog getInstance() {
        if (Atlantis.isAtlantisHeadless()) {
            return null;
        }
        if (instance == null) {
            instance = new AMouseHelpDialog();
        }
        return instance;
    }

    public void setVisible(boolean visible) {
        int screenWidth;
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int guiY = HTrackMomentaWindow.getGUI().getY();
        int dialogWidth = (int)instance.getPreferredSize().getWidth();
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > (screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth()))) {
            instance.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, guiY));
        } else {
            instance.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, guiY));
        }
        super.setVisible(visible);
    }

    public static void processInteractionChange(Vector interactions) {
        int j;
        int i;
        if (ACanvas.getCanvas().getCurrentWindow() == null) {
            return;
        }
        AModifier[] modifiers = ACanvas.getCanvas().getCurrentWindow().getInteractionManager().getMouseModifiers();
        ArrayList<AModifier> m = new ArrayList<AModifier>();
        for (i = 0; i < modifiers.length; ++i) {
            m.add(modifiers[i]);
        }
        for (i = 0; i < interactions.size(); ++i) {
            AModifier[] mod = ((AInteraction)interactions.get(i)).getModifiers();
            for (j = 0; j < mod.length; ++j) {
                m.add(mod[j]);
            }
        }
        for (i = 0; i < m.size(); ++i) {
            for (int j2 = i + 1; j2 < m.size(); ++j2) {
                if (m.get(i) == null || m.get(j2) == null || !((AModifier)m.get(i)).sameAs((AModifier)m.get(j2))) continue;
                m.set(i, null);
            }
        }
        Iterator it = m.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        for (int i2 = 0; i2 < m.size(); ++i2) {
            for (j = i2 + 1; j < m.size(); ++j) {
                String n = ((AModifier)m.get(i2)).toKeyString();
                String o = ((AModifier)m.get(j)).toKeyString();
                if (o.length() <= n.length() && (o.length() != n.length() || o.length() <= 0 || o.charAt(0) >= n.charAt(0))) continue;
                Object temp = m.get(i2);
                m.set(i2, (AModifier)m.get(j));
                m.set(j, (AModifier)temp);
            }
        }
        int foundnull = -1;
        for (int i3 = 0; i3 < m.size(); ++i3) {
            AModifier mod = (AModifier)m.get(i3);
            if (!mod.sameAs(AModifier.nothing)) continue;
            foundnull = i3;
        }
        if (foundnull == -1) {
            m.add(AModifier.nothing);
        }
        ButtonGroup bgroup = new ButtonGroup();
        rowData = new Object[m.size()][3];
        for (int i4 = 0; i4 < rowData.length; ++i4) {
            AModifier mod = (AModifier)m.get(i4);
            MouseHelpRadio but = new MouseHelpRadio(mod);
            if (mod.sameAs(AEventQueue.getDefault())) {
                but.setSelected(true);
            }
            if (mod.sameAs(AModifier.nothing)) {
                foundnull = i4;
            }
            bgroup.add(but);
            AMouseHelpDialog.rowData[i4][0] = but;
            AMouseHelpDialog.rowData[i4][1] = mod.toKeyString();
            AMouseHelpDialog.rowData[i4][2] = mod.toDescString();
        }
        columnNames = new String[]{"", "Key", "Action"};
        AbstractTableModel model = new AbstractTableModel(){

            public String getColumnName(int column) {
                return columnNames[column].toString();
            }

            public int getRowCount() {
                return rowData.length;
            }

            public int getColumnCount() {
                return columnNames.length;
            }

            public Object getValueAt(int row, int col) {
                return rowData[row][col];
            }

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            public void setValueAt(Object value, int row, int col) {
                AMouseHelpDialog.rowData[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        };
        table.setModel(model);
        table.getColumnModel().getColumn(0).setPreferredWidth(22);
        table.getColumnModel().getColumn(1).setPreferredWidth(80);
        table.getColumnModel().getColumn(2).setPreferredWidth(300);
        instance.pack();
    }
}

