/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ADefaultCellAttribute;
import atlantis.gui.AParamGUIDataModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;

public class AMultiSpanCellTableUI
extends BasicTableUI {
    public void paint(Graphics g, JComponent c) {
        for (int index = 0; index < this.table.getRowCount(); ++index) {
            this.paintRow(g, index);
        }
    }

    private void paintRow(Graphics g, int row) {
        AParamGUIDataModel tableModel = (AParamGUIDataModel)this.table.getModel();
        ADefaultCellAttribute cellAtt = tableModel.getCellAttribute();
        int numColumns = this.table.getColumnCount();
        for (int column = 0; column < numColumns; ++column) {
            int cellColumn;
            int cellRow;
            Rectangle cellRect = this.table.getCellRect(row, column, true);
            if (cellAtt.isVisible(row, column)) {
                cellRow = row;
                cellColumn = column;
            } else {
                cellRow = row + cellAtt.getSpan(row, column)[0];
                cellColumn = column + cellAtt.getSpan(row, column)[1];
            }
            this.paintCell(g, cellRect, cellRow, cellColumn);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        int spacingHeight = this.table.getRowMargin();
        int spacingWidth = this.table.getColumnModel().getColumnMargin();
        Color c = g.getColor();
        g.setColor(this.table.getGridColor());
        g.drawRect(cellRect.x, cellRect.y, cellRect.width - 1, cellRect.height - 1);
        g.setColor(c);
        cellRect.setBounds(cellRect.x + spacingWidth / 2, cellRect.y + spacingHeight / 2, cellRect.width - spacingWidth, cellRect.height - spacingHeight);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }
}

