/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ACheckBox;
import atlantis.gui.AMutableCheckBoxLayout;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Timer;

public class AMutableCheckBox
extends JPanel {
    private JLabel label;
    private ACheckBox checkBox;
    private Timer timer;
    private JPopupMenu popup;
    private String selectedText;
    private ActionListener statusActionListener;
    private ActionListener textActionListener;
    private Vector oper = new Vector();

    public AMutableCheckBox(String name) {
        this.setLayout(new AMutableCheckBoxLayout());
        this.setBorder(null);
        this.checkBox = new ACheckBox(name);
        this.checkBox.setBackground(new Color(204, 204, 204));
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AMutableCheckBox.this.statusActionListener != null) {
                    AMutableCheckBox.this.statusActionListener.actionPerformed(new ActionEvent(AMutableCheckBox.this.get(), 0, ""));
                }
            }
        });
        this.add("CHECKBOX", this.checkBox);
        this.popup = new JPopupMenu();
    }

    public void finalizeConstruction() {
        this.label = new JLabel("", 0);
        this.label.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1));
        LookAndFeel.installColorsAndFont(this.label, "CheckBox.background", "CheckBox.foreground", "CheckBox.font");
        this.add("LABEL", this.label);
        if (this.oper.size() > 2) {
            this.timer = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Dimension d = AMutableCheckBox.this.label.getSize();
                    AMutableCheckBox.this.popup.show(AMutableCheckBox.this.label, 0, d.height);
                }
            });
            this.timer.setRepeats(false);
        }
        if (this.oper.size() <= 2) {
            this.label.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (AUtilities.isRightMouseButton(e) || AMutableCheckBox.this.oper.size() == 1) {
                        return;
                    }
                    String text0 = (String)AMutableCheckBox.this.oper.elementAt(0);
                    String text1 = (String)AMutableCheckBox.this.oper.elementAt(1);
                    if (AMutableCheckBox.this.selectedText.equals(text0)) {
                        AMutableCheckBox.this.setSelectedText(text1);
                    } else if (AMutableCheckBox.this.selectedText.equals(text1)) {
                        AMutableCheckBox.this.setSelectedText(text0);
                    }
                    if (AMutableCheckBox.this.textActionListener != null) {
                        AMutableCheckBox.this.textActionListener.actionPerformed(new ActionEvent(AMutableCheckBox.this.get(), 0, ""));
                    }
                }
            });
        } else {
            this.label.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!AUtilities.isRightMouseButton(e)) {
                        AMutableCheckBox.this.timer.start();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (!AUtilities.isRightMouseButton(e)) {
                        AMutableCheckBox.this.timer.stop();
                    }
                }
            });
        }
    }

    private JPanel get() {
        return this;
    }

    public ACheckBox getCheckBox() {
        return this.checkBox;
    }

    public void addItem(String s) {
        this.oper.addElement(s);
        this.popup.add(s).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                AMutableCheckBox.this.setSelectedText(item.getText());
                if (AMutableCheckBox.this.textActionListener != null) {
                    AMutableCheckBox.this.textActionListener.actionPerformed(new ActionEvent(AMutableCheckBox.this.get(), 0, ""));
                }
            }
        });
    }

    public void setSelectedText(String text) {
        this.selectedText = text;
        this.label.setText(this.selectedText);
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public boolean getStatus() {
        return this.checkBox.isSelected();
    }

    public void setStatus(boolean status) {
        this.checkBox.setSelected(status);
    }

    public void addTextActionListener(ActionListener listener) {
        this.textActionListener = listener;
    }

    public void addStatusActionListener(ActionListener listener) {
        this.statusActionListener = listener;
    }

    public void setForeground(Color color) {
        if (this.checkBox != null) {
            this.checkBox.setForeground(color);
        }
    }
}

