/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ADefaultCellAttribute;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.parameters.AParametersGroup;
import atlantis.parameters.AStatusRootParameter;
import java.awt.Component;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AParamGUIDataModel
extends AbstractTableModel
implements TableCellEditor,
TableCellRenderer {
    private Vector parametersList;
    private int[] rowHeight;
    private boolean isTree = false;
    private JTree tree = null;
    private int treeRowNumber = -1;
    private ADefaultCellAttribute cellAtt;

    public AParamGUIDataModel(AParametersGroup group) {
        this.parametersList = group.getParameters(APar.getUserLevel());
        this.rowHeight = new int[this.parametersList.size()];
        this.cellAtt = new ADefaultCellAttribute(this.rowHeight.length, 2);
        for (int i = 0; i < this.parametersList.size(); ++i) {
            AParameter p = (AParameter)this.parametersList.elementAt(i);
            if (!p.isInitialized()) {
                p.initialize();
            }
            if (p instanceof AStatusRootParameter) {
                this.isTree = true;
                this.tree = (JTree)((AStatusRootParameter)p).getNameComponent();
                this.treeRowNumber = i;
                this.rowHeight[i] = this.tree.getRowCount() * (int)this.tree.getRowBounds(0).getHeight();
                int[] columns = new int[]{0, 1};
                int[] rows = new int[]{i};
                this.cellAtt.combine(rows, columns);
                continue;
            }
            this.rowHeight[i] = 25;
        }
    }

    public ADefaultCellAttribute getCellAttribute() {
        return this.cellAtt;
    }

    public int getRowHeight(int rowIndex) {
        return this.rowHeight[rowIndex];
    }

    public int getTreeRow() {
        return this.treeRowNumber;
    }

    public boolean hasTree() {
        return this.isTree;
    }

    public JTree getTree() {
        return this.tree;
    }

    public int getRowCount() {
        return this.parametersList.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return new Integer(0);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void refresh() {
        for (int i = 0; i < this.parametersList.size(); ++i) {
            AParameter p = (AParameter)this.parametersList.elementAt(i);
            p.refresh();
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        AParameter p = (AParameter)this.parametersList.elementAt(row);
        switch (column) {
            case 0: {
                return p.getNameComponent();
            }
            case 1: {
                return p.getValueComponent();
            }
        }
        return null;
    }

    public AParameter getParameter(int row) {
        return (AParameter)this.parametersList.elementAt(row);
    }

    public Object getCellEditorValue() {
        return new Integer(0);
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public void addCellEditorListener(CellEditorListener l) {
    }

    public void removeCellEditorListener(CellEditorListener l) {
    }
}

